/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.data.engine.internal.expando.model;

import com.liferay.data.engine.rest.dto.v2_0.DataDefinition;
import com.liferay.data.engine.rest.dto.v2_0.DataDefinitionField;
import com.liferay.data.engine.rest.dto.v2_0.DataRecord;
import com.liferay.data.engine.rest.resource.v2_0.DataDefinitionResource;
import com.liferay.data.engine.rest.resource.v2_0.DataRecordResource;
import com.liferay.dynamic.data.lists.model.DDLRecord;
import com.liferay.dynamic.data.lists.service.DDLRecordLocalServiceUtil;
import com.liferay.dynamic.data.mapping.exception.NoSuchStructureException;
import com.liferay.expando.kernel.model.ExpandoBridge;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.security.auth.GuestOrUserUtil;
import com.liferay.portal.kernel.service.GroupLocalService;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.HashMapBuilder;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.MapUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.UnicodeProperties;
import com.liferay.portal.kernel.util.Validator;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class DataEngineExpandoBridgeImpl
implements ExpandoBridge {
    private String _className;
    private long _classPK;
    private final long _companyGroupId;
    private long _companyId;
    private final DataDefinitionResource _dataDefinitionResource;
    private final DataRecordResource _dataRecordResource;

    public DataEngineExpandoBridgeImpl(String className, long classPK, long companyId, DataDefinitionResource.Factory dataDefinitionResourceFactory, DataRecordResource.Factory dataRecordResourceFactory, GroupLocalService groupLocalService) throws Exception {
        this._className = className;
        this._classPK = classPK;
        this._companyId = companyId;
        Group group = groupLocalService.fetchCompanyGroup(companyId);
        if (group == null) {
            throw new IllegalArgumentException("Invalid company " + companyId);
        }
        this._companyGroupId = group.getGroupId();
        DataDefinitionResource.Builder dataDefinitionResourceBuilder = dataDefinitionResourceFactory.create();
        this._dataDefinitionResource = dataDefinitionResourceBuilder.checkPermissions(false).user(GuestOrUserUtil.getGuestOrUser((long)this._companyId)).build();
        DataRecordResource.Builder dataRecordResourceBuilder = dataRecordResourceFactory.create();
        this._dataRecordResource = dataRecordResourceBuilder.checkPermissions(false).user(GuestOrUserUtil.getGuestOrUser((long)this._companyId)).build();
        DataDefinition dataDefinition = null;
        try {
            dataDefinition = this._getDataDefinition();
        }
        catch (Exception exception) {
            if (exception instanceof NoSuchStructureException || exception.getCause() instanceof NoSuchStructureException) {
                dataDefinition = new DataDefinition();
                dataDefinition.setAvailableLanguageIds(new String[]{"en_US"});
                dataDefinition.setDataDefinitionKey(this._className);
                dataDefinition.setName((Map)HashMapBuilder.put((Object)"en_US", (Object)this._className).build());
                dataDefinition.setStorageType("json");
            }
            throw exception;
        }
        if (Validator.isNull((Long)dataDefinition.getId())) {
            this._dataDefinitionResource.postSiteDataDefinitionByContentType(Long.valueOf(this._companyGroupId), "native-object", dataDefinition);
        }
    }

    public void addAttribute(String name) throws PortalException {
        this.addAttribute(name, false);
    }

    public void addAttribute(String name, boolean secure) throws PortalException {
        this.addAttribute(name, "text", secure);
    }

    public void addAttribute(String name, int type) throws PortalException {
        throw new UnsupportedOperationException();
    }

    public void addAttribute(String name, int type, boolean secure) throws PortalException {
        throw new UnsupportedOperationException();
    }

    public void addAttribute(String name, int type, Serializable defaultValue) throws PortalException {
        throw new UnsupportedOperationException();
    }

    public void addAttribute(String name, int type, Serializable defaultValue, boolean secure) throws PortalException {
        throw new UnsupportedOperationException();
    }

    public void addAttribute(String name, String type) throws PortalException {
        this.addAttribute(name, "text", false);
    }

    public void addAttribute(String name, String type, boolean secure) throws PortalException {
        this.addAttribute(name, type, null, secure);
    }

    public void addAttribute(String name, String type, Serializable defaultValue) throws PortalException {
        this.addAttribute(name, type, defaultValue, false);
    }

    public void addAttribute(String name, String fieldType, Serializable defaultValue, boolean secure) throws PortalException {
        try {
            DataDefinition dataDefinition = this._getDataDefinition();
            Object[] dataDefinitionFields = dataDefinition.getDataDefinitionFields();
            Optional<DataDefinitionField> dataDefinitionFieldsOptional = Stream.of(dataDefinitionFields).filter(dataDefinitionField -> StringUtil.equals((String)dataDefinitionField.getName(), (String)name)).findAny();
            if (dataDefinitionFieldsOptional.isPresent()) {
                return;
            }
            dataDefinition.setDataDefinitionFields((DataDefinitionField[])ArrayUtil.append((Object[])dataDefinitionFields, (Object)this.createDataDefinitionField(defaultValue, fieldType, name)));
            this._dataDefinitionResource.putDataDefinition(dataDefinition.getId(), dataDefinition);
        }
        catch (Exception exception) {
            throw new PortalException((Throwable)exception);
        }
    }

    public Serializable getAttribute(String name) {
        return this.getAttribute(name, false);
    }

    public Serializable getAttribute(String name, boolean secure) {
        if (this._classPK <= 0L) {
            throw new UnsupportedOperationException("Class primary key is less than or equal to 0");
        }
        try {
            DDLRecord ddlRecord = DDLRecordLocalServiceUtil.fetchFirstRecord((String)this._className, (long)this._classPK);
            if (ddlRecord == null) {
                return this.getAttributeDefault(name);
            }
            DataRecord dataRecord = this._dataRecordResource.getDataRecord(Long.valueOf(ddlRecord.getRecordId()));
            Map dataRecordValues = dataRecord.getDataRecordValues();
            return (Serializable)dataRecordValues.get(name);
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    public Serializable getAttributeDefault(String name) {
        try {
            DataDefinition dataDefinition = this._getDataDefinition();
            Optional<Serializable> serializableOptional = Stream.of(dataDefinition.getDataDefinitionFields()).filter(dataDefinitionField -> StringUtil.equals((String)dataDefinitionField.getName(), (String)name)).map(DataDefinitionField::getDefaultValue).filter(MapUtil::isNotEmpty).map(defaultValueMap -> (Serializable)defaultValueMap.get("en_US")).findFirst();
            return serializableOptional.get();
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    public Enumeration<String> getAttributeNames() {
        try {
            DataDefinition dataDefinition = this._getDataDefinition();
            return Collections.enumeration(Stream.of(dataDefinition.getDataDefinitionFields()).map(DataDefinitionField::getName).collect(Collectors.toList()));
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    public UnicodeProperties getAttributeProperties(String name) {
        try {
            UnicodeProperties unicodeProperties = new UnicodeProperties();
            DataDefinition dataDefinition = this._getDataDefinition();
            Stream.of(dataDefinition.getDataDefinitionFields()).filter(dataDefinitionField -> StringUtil.equals((String)name, (String)dataDefinitionField.getName())).forEach(dataDefinitionField -> unicodeProperties.put("fieldType", dataDefinitionField.getFieldType()));
            return unicodeProperties;
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    public Map<String, Serializable> getAttributes() {
        return this.getAttributes(false);
    }

    public Map<String, Serializable> getAttributes(boolean secure) {
        List attributeNames = ListUtil.fromEnumeration(this.getAttributeNames());
        Stream stream = attributeNames.stream();
        return stream.collect(Collectors.toMap(Function.identity(), this::getAttribute));
    }

    public Map<String, Serializable> getAttributes(Collection<String> names) {
        return this.getAttributes(names, false);
    }

    public Map<String, Serializable> getAttributes(Collection<String> names, boolean secure) {
        List attributeNames = ListUtil.fromEnumeration(this.getAttributeNames());
        Stream stream = attributeNames.stream();
        return stream.filter(names::contains).collect(Collectors.toMap(Function.identity(), this::getAttribute));
    }

    public int getAttributeType(String name) {
        throw new UnsupportedOperationException();
    }

    public String getClassName() {
        return this._className;
    }

    public long getClassPK() {
        return this._classPK;
    }

    public long getCompanyId() {
        return this._companyId;
    }

    public boolean hasAttribute(String name) {
        try {
            DataDefinition dataDefinition = this._getDataDefinition();
            Optional<DataDefinitionField> dataDefinitionFieldsOptional = Stream.of(dataDefinition.getDataDefinitionFields()).filter(dataDefinitionField -> StringUtil.equals((String)dataDefinitionField.getName(), (String)name)).findAny();
            return dataDefinitionFieldsOptional.isPresent();
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    public boolean isIndexEnabled() {
        return false;
    }

    public void setAttribute(String name, Serializable value) {
        this.setAttribute(name, value, false);
    }

    public void setAttribute(String name, Serializable value, boolean secure) {
        if (this._classPK <= 0L) {
            throw new UnsupportedOperationException("Class primary key is less than or equal to 0");
        }
        try {
            DDLRecord ddlRecord = DDLRecordLocalServiceUtil.fetchFirstRecord((String)this._className, (long)this._classPK);
            if (ddlRecord == null) {
                DataDefinition dataDefinition = this._getDataDefinition();
                DataRecord dataRecord = new DataRecord();
                dataRecord.setDataRecordValues((Map)HashMapBuilder.put((Object)name, (Object)value).build());
                dataRecord = this._dataRecordResource.postDataDefinitionDataRecord(dataDefinition.getId(), dataRecord);
                ddlRecord = DDLRecordLocalServiceUtil.getDDLRecord((long)dataRecord.getId());
                ddlRecord.setClassName(this._className);
                ddlRecord.setClassPK(this._classPK);
                DDLRecordLocalServiceUtil.updateDDLRecord((DDLRecord)ddlRecord);
            } else {
                DataRecord dataRecord = this._dataRecordResource.getDataRecord(Long.valueOf(ddlRecord.getRecordId()));
                Map dataRecordValues = dataRecord.getDataRecordValues();
                dataRecordValues.put(name, value);
                this._dataRecordResource.putDataRecord(dataRecord.getId(), dataRecord);
            }
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    public void setAttributeDefault(String name, Serializable defaultValue) {
        try {
            DataDefinition dataDefinition = this._getDataDefinition();
            Stream.of(dataDefinition.getDataDefinitionFields()).filter(dataDefinitionField -> StringUtil.equals((String)dataDefinitionField.getName(), (String)name)).map(DataDefinitionField::getDefaultValue).forEach(map -> map.put("en_US", defaultValue));
            this._updateDataDefinition(dataDefinition);
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    public void setAttributeProperties(String name, UnicodeProperties unicodeProperties) {
        this.setAttributeProperties(name, unicodeProperties, false);
    }

    public void setAttributeProperties(String name, UnicodeProperties unicodeProperties, boolean secure) {
        try {
            DataDefinition dataDefinition = this._getDataDefinition();
            Stream.of(dataDefinition.getDataDefinitionFields()).filter(dataDefinitionField -> StringUtil.equals((String)dataDefinitionField.getName(), (String)name)).forEach(dataDefinitionField -> dataDefinitionField.setFieldType(unicodeProperties.getProperty("fieldType")));
            this._updateDataDefinition(dataDefinition);
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    public void setAttributes(Map<String, Serializable> attributes) {
        this.setAttributes(attributes, false);
    }

    public void setAttributes(Map<String, Serializable> attributes, boolean secure) {
        for (Map.Entry<String, Serializable> entry : attributes.entrySet()) {
            this.setAttribute(entry.getKey(), entry.getValue());
        }
    }

    public void setAttributes(ServiceContext serviceContext) {
        this.setAttributes(serviceContext, false);
    }

    public void setAttributes(ServiceContext serviceContext, boolean secure) {
        throw new UnsupportedOperationException();
    }

    public void setClassName(String className) {
        this._className = className;
    }

    public void setClassPK(long classPK) {
        this._classPK = classPK;
    }

    public void setCompanyId(long companyId) {
        this._companyId = companyId;
    }

    public void setIndexEnabled(boolean indexEnabled) {
    }

    protected DataDefinitionField createDataDefinitionField(Serializable defaultValue, String fieldType, String name) {
        DataDefinitionField dataDefinitionField = new DataDefinitionField();
        dataDefinitionField.setDefaultValue((Map)HashMapBuilder.put((Object)"en_US", (Object)defaultValue).build());
        dataDefinitionField.setFieldType(fieldType);
        dataDefinitionField.setName(name);
        return dataDefinitionField;
    }

    private DataDefinition _getDataDefinition() throws Exception {
        return this._dataDefinitionResource.getSiteDataDefinitionByContentTypeByDataDefinitionKey(Long.valueOf(this._companyGroupId), "native-object", this._className);
    }

    private void _updateDataDefinition(DataDefinition dataDefinition) throws Exception {
        this._dataDefinitionResource.putDataDefinition(dataDefinition.getId(), dataDefinition);
    }
}

