/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of the Liferay Enterprise
 * Subscription License ("License"). You may not use this file except in
 * compliance with the License. You can obtain a copy of the License by
 * contacting Liferay, Inc. See the License for the specific language governing
 * permissions and limitations under the License, including but not limited to
 * distribution rights of the Software.
 *
 *
 *
 */

package com.liferay.data.engine.internal.upgrade.v2_1_1;

import com.liferay.data.engine.internal.upgrade.v2_1_1.util.DEDataDefinitionFieldLinkTable;
import com.liferay.portal.kernel.upgrade.UpgradeProcess;

/**
 * @author Eudaldo Alonso
 */
public class UpgradeDEDataDefinitionFieldLink extends UpgradeProcess {

	@Override
	protected void doUpgrade() throws Exception {
		if (hasColumnType("DEDataDefinitionFieldLink", "fieldName", "LONG")) {
			alter(
				DEDataDefinitionFieldLinkTable.class,
				new AlterColumnType("fieldName", "VARCHAR(75) null"));
		}
	}

}