/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of the Liferay Enterprise
 * Subscription License ("License"). You may not use this file except in
 * compliance with the License. You can obtain a copy of the License by
 * contacting Liferay, Inc. See the License for the specific language governing
 * permissions and limitations under the License, including but not limited to
 * distribution rights of the Software.
 *
 *
 *
 */

package com.liferay.data.engine.internal.upgrade.v2_1_0;

import com.liferay.data.engine.internal.upgrade.v2_1_0.util.DEDataDefinitionFieldLinkTable;
import com.liferay.portal.kernel.upgrade.UpgradeProcess;

/**
 * @author Pavel Savinov
 */
public class UpgradeDEDataDefinitionFieldLink extends UpgradeProcess {

	@Override
	protected void doUpgrade() throws Exception {
		if (!hasColumn("DEDataDefinitionFieldLink", "createDate")) {
			alter(
				DEDataDefinitionFieldLinkTable.class,
				new AlterTableAddColumn("createDate", "DATE null"));
		}

		if (!hasColumn("DEDataDefinitionFieldLink", "modifiedDate")) {
			alter(
				DEDataDefinitionFieldLinkTable.class,
				new AlterTableAddColumn("modifiedDate", "DATE null"));
		}

		if (!hasColumn("DEDataDefinitionFieldLink", "lastPublishDate")) {
			alter(
				DEDataDefinitionFieldLinkTable.class,
				new AlterTableAddColumn("lastPublishDate", "DATE null"));
		}
	}

}