/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of the Liferay Enterprise
 * Subscription License ("License"). You may not use this file except in
 * compliance with the License. You can obtain a copy of the License by
 * contacting Liferay, Inc. See the License for the specific language governing
 * permissions and limitations under the License, including but not limited to
 * distribution rights of the Software.
 *
 *
 *
 */

package com.liferay.data.engine.internal.nativeobject.tracker;

import com.liferay.data.engine.nativeobject.DataEngineNativeObject;
import com.liferay.data.engine.nativeobject.tracker.DataEngineNativeObjectTracker;
import com.liferay.portal.kernel.util.StringUtil;

import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.osgi.service.component.annotations.ReferencePolicyOption;

/**
 * @author Jeyvison Nascimento
 */
@Component(immediate = true, service = DataEngineNativeObjectTracker.class)
public class DataEngineNativeObjectTrackerImpl
	implements DataEngineNativeObjectTracker {

	@Override
	public DataEngineNativeObject getDataEngineNativeObject(String className) {
		return _dataEngineNativeObjects.get(StringUtil.toUpperCase(className));
	}

	@Override
	public Collection<DataEngineNativeObject> getDataEngineNativeObjects() {
		return _dataEngineNativeObjects.values();
	}

	@Reference(
		cardinality = ReferenceCardinality.MULTIPLE,
		policy = ReferencePolicy.DYNAMIC,
		policyOption = ReferencePolicyOption.GREEDY
	)
	protected void addDataEngineNativeObject(
			DataEngineNativeObject dataEngineNativeObject)
		throws Exception {

		_dataEngineNativeObjects.put(
			StringUtil.toUpperCase(dataEngineNativeObject.getClassName()),
			dataEngineNativeObject);
	}

	protected void removeDataEngineNativeObject(
		DataEngineNativeObject dataEngineNativeObject) {

		_dataEngineNativeObjects.remove(
			StringUtil.toUpperCase(dataEngineNativeObject.getClassName()));
	}

	private final Map<String, DataEngineNativeObject> _dataEngineNativeObjects =
		new ConcurrentHashMap<>();

}