/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
 * details.
 */

package com.liferay.data.engine.model.impl;

import com.liferay.data.engine.model.DEDataListView;
import com.liferay.data.engine.model.DEDataListViewModel;
import com.liferay.expando.kernel.model.ExpandoBridge;
import com.liferay.expando.kernel.util.ExpandoBridgeFactoryUtil;
import com.liferay.exportimport.kernel.lar.StagedModelType;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.bean.AutoEscapeBeanHandler;
import com.liferay.portal.kernel.exception.LocaleException;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.json.JSON;
import com.liferay.portal.kernel.model.CacheModel;
import com.liferay.portal.kernel.model.ModelWrapper;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.model.impl.BaseModelImpl;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.UserLocalServiceUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.LocalizationUtil;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.ProxyUtil;
import com.liferay.portal.kernel.util.Validator;

import java.io.Serializable;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationHandler;

import java.sql.Types;

import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.function.BiConsumer;
import java.util.function.Function;

/**
 * The base model implementation for the DEDataListView service. Represents a row in the &quot;DEDataListView&quot; database table, with each column mapped to a property of this class.
 *
 * <p>
 * This implementation and its corresponding interface <code>DEDataListViewModel</code> exist only as a container for the default property accessors generated by ServiceBuilder. Helper methods and all application logic should be put in {@link DEDataListViewImpl}.
 * </p>
 *
 * @author Brian Wing Shun Chan
 * @see DEDataListViewImpl
 * @generated
 */
public class DEDataListViewModelImpl
	extends BaseModelImpl<DEDataListView> implements DEDataListViewModel {

	/*
	 * NOTE FOR DEVELOPERS:
	 *
	 * Never modify or reference this class directly. All methods that expect a de data list view model instance should use the <code>DEDataListView</code> interface instead.
	 */
	public static final String TABLE_NAME = "DEDataListView";

	public static final Object[][] TABLE_COLUMNS = {
		{"uuid_", Types.VARCHAR}, {"deDataListViewId", Types.BIGINT},
		{"groupId", Types.BIGINT}, {"companyId", Types.BIGINT},
		{"userId", Types.BIGINT}, {"userName", Types.VARCHAR},
		{"createDate", Types.TIMESTAMP}, {"modifiedDate", Types.TIMESTAMP},
		{"appliedFilters", Types.VARCHAR}, {"ddmStructureId", Types.BIGINT},
		{"fieldNames", Types.CLOB}, {"name", Types.VARCHAR},
		{"sortField", Types.VARCHAR}
	};

	public static final Map<String, Integer> TABLE_COLUMNS_MAP =
		new HashMap<String, Integer>();

	static {
		TABLE_COLUMNS_MAP.put("uuid_", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("deDataListViewId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("groupId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("companyId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("userId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("userName", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("createDate", Types.TIMESTAMP);
		TABLE_COLUMNS_MAP.put("modifiedDate", Types.TIMESTAMP);
		TABLE_COLUMNS_MAP.put("appliedFilters", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("ddmStructureId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("fieldNames", Types.CLOB);
		TABLE_COLUMNS_MAP.put("name", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("sortField", Types.VARCHAR);
	}

	public static final String TABLE_SQL_CREATE =
		"create table DEDataListView (uuid_ VARCHAR(75) null,deDataListViewId LONG not null primary key,groupId LONG,companyId LONG,userId LONG,userName VARCHAR(75) null,createDate DATE null,modifiedDate DATE null,appliedFilters VARCHAR(75) null,ddmStructureId LONG,fieldNames TEXT null,name STRING null,sortField VARCHAR(75) null)";

	public static final String TABLE_SQL_DROP = "drop table DEDataListView";

	public static final String ORDER_BY_JPQL =
		" ORDER BY deDataListView.deDataListViewId ASC";

	public static final String ORDER_BY_SQL =
		" ORDER BY DEDataListView.deDataListViewId ASC";

	public static final String DATA_SOURCE = "liferayDataSource";

	public static final String SESSION_FACTORY = "liferaySessionFactory";

	public static final String TX_MANAGER = "liferayTransactionManager";

	public static final long COMPANYID_COLUMN_BITMASK = 1L;

	public static final long DDMSTRUCTUREID_COLUMN_BITMASK = 2L;

	public static final long GROUPID_COLUMN_BITMASK = 4L;

	public static final long UUID_COLUMN_BITMASK = 8L;

	public static final long DEDATALISTVIEWID_COLUMN_BITMASK = 16L;

	public static void setEntityCacheEnabled(boolean entityCacheEnabled) {
		_entityCacheEnabled = entityCacheEnabled;
	}

	public static void setFinderCacheEnabled(boolean finderCacheEnabled) {
		_finderCacheEnabled = finderCacheEnabled;
	}

	public DEDataListViewModelImpl() {
	}

	@Override
	public long getPrimaryKey() {
		return _deDataListViewId;
	}

	@Override
	public void setPrimaryKey(long primaryKey) {
		setDeDataListViewId(primaryKey);
	}

	@Override
	public Serializable getPrimaryKeyObj() {
		return _deDataListViewId;
	}

	@Override
	public void setPrimaryKeyObj(Serializable primaryKeyObj) {
		setPrimaryKey(((Long)primaryKeyObj).longValue());
	}

	@Override
	public Class<?> getModelClass() {
		return DEDataListView.class;
	}

	@Override
	public String getModelClassName() {
		return DEDataListView.class.getName();
	}

	@Override
	public Map<String, Object> getModelAttributes() {
		Map<String, Object> attributes = new HashMap<String, Object>();

		Map<String, Function<DEDataListView, Object>> attributeGetterFunctions =
			getAttributeGetterFunctions();

		for (Map.Entry<String, Function<DEDataListView, Object>> entry :
				attributeGetterFunctions.entrySet()) {

			String attributeName = entry.getKey();
			Function<DEDataListView, Object> attributeGetterFunction =
				entry.getValue();

			attributes.put(
				attributeName,
				attributeGetterFunction.apply((DEDataListView)this));
		}

		attributes.put("entityCacheEnabled", isEntityCacheEnabled());
		attributes.put("finderCacheEnabled", isFinderCacheEnabled());

		return attributes;
	}

	@Override
	public void setModelAttributes(Map<String, Object> attributes) {
		Map<String, BiConsumer<DEDataListView, Object>>
			attributeSetterBiConsumers = getAttributeSetterBiConsumers();

		for (Map.Entry<String, Object> entry : attributes.entrySet()) {
			String attributeName = entry.getKey();

			BiConsumer<DEDataListView, Object> attributeSetterBiConsumer =
				attributeSetterBiConsumers.get(attributeName);

			if (attributeSetterBiConsumer != null) {
				attributeSetterBiConsumer.accept(
					(DEDataListView)this, entry.getValue());
			}
		}
	}

	public Map<String, Function<DEDataListView, Object>>
		getAttributeGetterFunctions() {

		return _attributeGetterFunctions;
	}

	public Map<String, BiConsumer<DEDataListView, Object>>
		getAttributeSetterBiConsumers() {

		return _attributeSetterBiConsumers;
	}

	private static Function<InvocationHandler, DEDataListView>
		_getProxyProviderFunction() {

		Class<?> proxyClass = ProxyUtil.getProxyClass(
			DEDataListView.class.getClassLoader(), DEDataListView.class,
			ModelWrapper.class);

		try {
			Constructor<DEDataListView> constructor =
				(Constructor<DEDataListView>)proxyClass.getConstructor(
					InvocationHandler.class);

			return invocationHandler -> {
				try {
					return constructor.newInstance(invocationHandler);
				}
				catch (ReflectiveOperationException
							reflectiveOperationException) {

					throw new InternalError(reflectiveOperationException);
				}
			};
		}
		catch (NoSuchMethodException noSuchMethodException) {
			throw new InternalError(noSuchMethodException);
		}
	}

	private static final Map<String, Function<DEDataListView, Object>>
		_attributeGetterFunctions;
	private static final Map<String, BiConsumer<DEDataListView, Object>>
		_attributeSetterBiConsumers;

	static {
		Map<String, Function<DEDataListView, Object>> attributeGetterFunctions =
			new LinkedHashMap<String, Function<DEDataListView, Object>>();
		Map<String, BiConsumer<DEDataListView, ?>> attributeSetterBiConsumers =
			new LinkedHashMap<String, BiConsumer<DEDataListView, ?>>();

		attributeGetterFunctions.put("uuid", DEDataListView::getUuid);
		attributeSetterBiConsumers.put(
			"uuid",
			(BiConsumer<DEDataListView, String>)DEDataListView::setUuid);
		attributeGetterFunctions.put(
			"deDataListViewId", DEDataListView::getDeDataListViewId);
		attributeSetterBiConsumers.put(
			"deDataListViewId",
			(BiConsumer<DEDataListView, Long>)
				DEDataListView::setDeDataListViewId);
		attributeGetterFunctions.put("groupId", DEDataListView::getGroupId);
		attributeSetterBiConsumers.put(
			"groupId",
			(BiConsumer<DEDataListView, Long>)DEDataListView::setGroupId);
		attributeGetterFunctions.put("companyId", DEDataListView::getCompanyId);
		attributeSetterBiConsumers.put(
			"companyId",
			(BiConsumer<DEDataListView, Long>)DEDataListView::setCompanyId);
		attributeGetterFunctions.put("userId", DEDataListView::getUserId);
		attributeSetterBiConsumers.put(
			"userId",
			(BiConsumer<DEDataListView, Long>)DEDataListView::setUserId);
		attributeGetterFunctions.put("userName", DEDataListView::getUserName);
		attributeSetterBiConsumers.put(
			"userName",
			(BiConsumer<DEDataListView, String>)DEDataListView::setUserName);
		attributeGetterFunctions.put(
			"createDate", DEDataListView::getCreateDate);
		attributeSetterBiConsumers.put(
			"createDate",
			(BiConsumer<DEDataListView, Date>)DEDataListView::setCreateDate);
		attributeGetterFunctions.put(
			"modifiedDate", DEDataListView::getModifiedDate);
		attributeSetterBiConsumers.put(
			"modifiedDate",
			(BiConsumer<DEDataListView, Date>)DEDataListView::setModifiedDate);
		attributeGetterFunctions.put(
			"appliedFilters", DEDataListView::getAppliedFilters);
		attributeSetterBiConsumers.put(
			"appliedFilters",
			(BiConsumer<DEDataListView, String>)
				DEDataListView::setAppliedFilters);
		attributeGetterFunctions.put(
			"ddmStructureId", DEDataListView::getDdmStructureId);
		attributeSetterBiConsumers.put(
			"ddmStructureId",
			(BiConsumer<DEDataListView, Long>)
				DEDataListView::setDdmStructureId);
		attributeGetterFunctions.put(
			"fieldNames", DEDataListView::getFieldNames);
		attributeSetterBiConsumers.put(
			"fieldNames",
			(BiConsumer<DEDataListView, String>)DEDataListView::setFieldNames);
		attributeGetterFunctions.put("name", DEDataListView::getName);
		attributeSetterBiConsumers.put(
			"name",
			(BiConsumer<DEDataListView, String>)DEDataListView::setName);
		attributeGetterFunctions.put("sortField", DEDataListView::getSortField);
		attributeSetterBiConsumers.put(
			"sortField",
			(BiConsumer<DEDataListView, String>)DEDataListView::setSortField);

		_attributeGetterFunctions = Collections.unmodifiableMap(
			attributeGetterFunctions);
		_attributeSetterBiConsumers = Collections.unmodifiableMap(
			(Map)attributeSetterBiConsumers);
	}

	@Override
	public String getUuid() {
		if (_uuid == null) {
			return "";
		}
		else {
			return _uuid;
		}
	}

	@Override
	public void setUuid(String uuid) {
		_columnBitmask |= UUID_COLUMN_BITMASK;

		if (_originalUuid == null) {
			_originalUuid = _uuid;
		}

		_uuid = uuid;
	}

	public String getOriginalUuid() {
		return GetterUtil.getString(_originalUuid);
	}

	@Override
	public long getDeDataListViewId() {
		return _deDataListViewId;
	}

	@Override
	public void setDeDataListViewId(long deDataListViewId) {
		_deDataListViewId = deDataListViewId;
	}

	@Override
	public long getGroupId() {
		return _groupId;
	}

	@Override
	public void setGroupId(long groupId) {
		_columnBitmask |= GROUPID_COLUMN_BITMASK;

		if (!_setOriginalGroupId) {
			_setOriginalGroupId = true;

			_originalGroupId = _groupId;
		}

		_groupId = groupId;
	}

	public long getOriginalGroupId() {
		return _originalGroupId;
	}

	@Override
	public long getCompanyId() {
		return _companyId;
	}

	@Override
	public void setCompanyId(long companyId) {
		_columnBitmask |= COMPANYID_COLUMN_BITMASK;

		if (!_setOriginalCompanyId) {
			_setOriginalCompanyId = true;

			_originalCompanyId = _companyId;
		}

		_companyId = companyId;
	}

	public long getOriginalCompanyId() {
		return _originalCompanyId;
	}

	@Override
	public long getUserId() {
		return _userId;
	}

	@Override
	public void setUserId(long userId) {
		_userId = userId;
	}

	@Override
	public String getUserUuid() {
		try {
			User user = UserLocalServiceUtil.getUserById(getUserId());

			return user.getUuid();
		}
		catch (PortalException portalException) {
			return "";
		}
	}

	@Override
	public void setUserUuid(String userUuid) {
	}

	@Override
	public String getUserName() {
		if (_userName == null) {
			return "";
		}
		else {
			return _userName;
		}
	}

	@Override
	public void setUserName(String userName) {
		_userName = userName;
	}

	@Override
	public Date getCreateDate() {
		return _createDate;
	}

	@Override
	public void setCreateDate(Date createDate) {
		_createDate = createDate;
	}

	@Override
	public Date getModifiedDate() {
		return _modifiedDate;
	}

	public boolean hasSetModifiedDate() {
		return _setModifiedDate;
	}

	@Override
	public void setModifiedDate(Date modifiedDate) {
		_setModifiedDate = true;

		_modifiedDate = modifiedDate;
	}

	@Override
	public String getAppliedFilters() {
		if (_appliedFilters == null) {
			return "";
		}
		else {
			return _appliedFilters;
		}
	}

	@Override
	public void setAppliedFilters(String appliedFilters) {
		_appliedFilters = appliedFilters;
	}

	@Override
	public long getDdmStructureId() {
		return _ddmStructureId;
	}

	@Override
	public void setDdmStructureId(long ddmStructureId) {
		_columnBitmask |= DDMSTRUCTUREID_COLUMN_BITMASK;

		if (!_setOriginalDdmStructureId) {
			_setOriginalDdmStructureId = true;

			_originalDdmStructureId = _ddmStructureId;
		}

		_ddmStructureId = ddmStructureId;
	}

	public long getOriginalDdmStructureId() {
		return _originalDdmStructureId;
	}

	@Override
	public String getFieldNames() {
		if (_fieldNames == null) {
			return "";
		}
		else {
			return _fieldNames;
		}
	}

	@Override
	public void setFieldNames(String fieldNames) {
		_fieldNames = fieldNames;
	}

	@Override
	public String getName() {
		if (_name == null) {
			return "";
		}
		else {
			return _name;
		}
	}

	@Override
	public String getName(Locale locale) {
		String languageId = LocaleUtil.toLanguageId(locale);

		return getName(languageId);
	}

	@Override
	public String getName(Locale locale, boolean useDefault) {
		String languageId = LocaleUtil.toLanguageId(locale);

		return getName(languageId, useDefault);
	}

	@Override
	public String getName(String languageId) {
		return LocalizationUtil.getLocalization(getName(), languageId);
	}

	@Override
	public String getName(String languageId, boolean useDefault) {
		return LocalizationUtil.getLocalization(
			getName(), languageId, useDefault);
	}

	@Override
	public String getNameCurrentLanguageId() {
		return _nameCurrentLanguageId;
	}

	@JSON
	@Override
	public String getNameCurrentValue() {
		Locale locale = getLocale(_nameCurrentLanguageId);

		return getName(locale);
	}

	@Override
	public Map<Locale, String> getNameMap() {
		return LocalizationUtil.getLocalizationMap(getName());
	}

	@Override
	public void setName(String name) {
		_name = name;
	}

	@Override
	public void setName(String name, Locale locale) {
		setName(name, locale, LocaleUtil.getSiteDefault());
	}

	@Override
	public void setName(String name, Locale locale, Locale defaultLocale) {
		String languageId = LocaleUtil.toLanguageId(locale);
		String defaultLanguageId = LocaleUtil.toLanguageId(defaultLocale);

		if (Validator.isNotNull(name)) {
			setName(
				LocalizationUtil.updateLocalization(
					getName(), "Name", name, languageId, defaultLanguageId));
		}
		else {
			setName(
				LocalizationUtil.removeLocalization(
					getName(), "Name", languageId));
		}
	}

	@Override
	public void setNameCurrentLanguageId(String languageId) {
		_nameCurrentLanguageId = languageId;
	}

	@Override
	public void setNameMap(Map<Locale, String> nameMap) {
		setNameMap(nameMap, LocaleUtil.getSiteDefault());
	}

	@Override
	public void setNameMap(Map<Locale, String> nameMap, Locale defaultLocale) {
		if (nameMap == null) {
			return;
		}

		setName(
			LocalizationUtil.updateLocalization(
				nameMap, getName(), "Name",
				LocaleUtil.toLanguageId(defaultLocale)));
	}

	@Override
	public String getSortField() {
		if (_sortField == null) {
			return "";
		}
		else {
			return _sortField;
		}
	}

	@Override
	public void setSortField(String sortField) {
		_sortField = sortField;
	}

	@Override
	public StagedModelType getStagedModelType() {
		return new StagedModelType(
			PortalUtil.getClassNameId(DEDataListView.class.getName()));
	}

	public long getColumnBitmask() {
		return _columnBitmask;
	}

	@Override
	public ExpandoBridge getExpandoBridge() {
		return ExpandoBridgeFactoryUtil.getExpandoBridge(
			getCompanyId(), DEDataListView.class.getName(), getPrimaryKey());
	}

	@Override
	public void setExpandoBridgeAttributes(ServiceContext serviceContext) {
		ExpandoBridge expandoBridge = getExpandoBridge();

		expandoBridge.setAttributes(serviceContext);
	}

	@Override
	public String[] getAvailableLanguageIds() {
		Set<String> availableLanguageIds = new TreeSet<String>();

		Map<Locale, String> nameMap = getNameMap();

		for (Map.Entry<Locale, String> entry : nameMap.entrySet()) {
			Locale locale = entry.getKey();
			String value = entry.getValue();

			if (Validator.isNotNull(value)) {
				availableLanguageIds.add(LocaleUtil.toLanguageId(locale));
			}
		}

		return availableLanguageIds.toArray(
			new String[availableLanguageIds.size()]);
	}

	@Override
	public String getDefaultLanguageId() {
		String xml = getName();

		if (xml == null) {
			return "";
		}

		Locale defaultLocale = LocaleUtil.getSiteDefault();

		return LocalizationUtil.getDefaultLanguageId(xml, defaultLocale);
	}

	@Override
	public void prepareLocalizedFieldsForImport() throws LocaleException {
		Locale defaultLocale = LocaleUtil.fromLanguageId(
			getDefaultLanguageId());

		Locale[] availableLocales = LocaleUtil.fromLanguageIds(
			getAvailableLanguageIds());

		Locale defaultImportLocale = LocalizationUtil.getDefaultImportLocale(
			DEDataListView.class.getName(), getPrimaryKey(), defaultLocale,
			availableLocales);

		prepareLocalizedFieldsForImport(defaultImportLocale);
	}

	@Override
	@SuppressWarnings("unused")
	public void prepareLocalizedFieldsForImport(Locale defaultImportLocale)
		throws LocaleException {

		Locale defaultLocale = LocaleUtil.getSiteDefault();

		String modelDefaultLanguageId = getDefaultLanguageId();

		String name = getName(defaultLocale);

		if (Validator.isNull(name)) {
			setName(getName(modelDefaultLanguageId), defaultLocale);
		}
		else {
			setName(getName(defaultLocale), defaultLocale, defaultLocale);
		}
	}

	@Override
	public DEDataListView toEscapedModel() {
		if (_escapedModel == null) {
			Function<InvocationHandler, DEDataListView>
				escapedModelProxyProviderFunction =
					EscapedModelProxyProviderFunctionHolder.
						_escapedModelProxyProviderFunction;

			_escapedModel = escapedModelProxyProviderFunction.apply(
				new AutoEscapeBeanHandler(this));
		}

		return _escapedModel;
	}

	@Override
	public Object clone() {
		DEDataListViewImpl deDataListViewImpl = new DEDataListViewImpl();

		deDataListViewImpl.setUuid(getUuid());
		deDataListViewImpl.setDeDataListViewId(getDeDataListViewId());
		deDataListViewImpl.setGroupId(getGroupId());
		deDataListViewImpl.setCompanyId(getCompanyId());
		deDataListViewImpl.setUserId(getUserId());
		deDataListViewImpl.setUserName(getUserName());
		deDataListViewImpl.setCreateDate(getCreateDate());
		deDataListViewImpl.setModifiedDate(getModifiedDate());
		deDataListViewImpl.setAppliedFilters(getAppliedFilters());
		deDataListViewImpl.setDdmStructureId(getDdmStructureId());
		deDataListViewImpl.setFieldNames(getFieldNames());
		deDataListViewImpl.setName(getName());
		deDataListViewImpl.setSortField(getSortField());

		deDataListViewImpl.resetOriginalValues();

		return deDataListViewImpl;
	}

	@Override
	public int compareTo(DEDataListView deDataListView) {
		long primaryKey = deDataListView.getPrimaryKey();

		if (getPrimaryKey() < primaryKey) {
			return -1;
		}
		else if (getPrimaryKey() > primaryKey) {
			return 1;
		}
		else {
			return 0;
		}
	}

	@Override
	public boolean equals(Object obj) {
		if (this == obj) {
			return true;
		}

		if (!(obj instanceof DEDataListView)) {
			return false;
		}

		DEDataListView deDataListView = (DEDataListView)obj;

		long primaryKey = deDataListView.getPrimaryKey();

		if (getPrimaryKey() == primaryKey) {
			return true;
		}
		else {
			return false;
		}
	}

	@Override
	public int hashCode() {
		return (int)getPrimaryKey();
	}

	@Override
	public boolean isEntityCacheEnabled() {
		return _entityCacheEnabled;
	}

	@Override
	public boolean isFinderCacheEnabled() {
		return _finderCacheEnabled;
	}

	@Override
	public void resetOriginalValues() {
		DEDataListViewModelImpl deDataListViewModelImpl = this;

		deDataListViewModelImpl._originalUuid = deDataListViewModelImpl._uuid;

		deDataListViewModelImpl._originalGroupId =
			deDataListViewModelImpl._groupId;

		deDataListViewModelImpl._setOriginalGroupId = false;

		deDataListViewModelImpl._originalCompanyId =
			deDataListViewModelImpl._companyId;

		deDataListViewModelImpl._setOriginalCompanyId = false;

		deDataListViewModelImpl._setModifiedDate = false;

		deDataListViewModelImpl._originalDdmStructureId =
			deDataListViewModelImpl._ddmStructureId;

		deDataListViewModelImpl._setOriginalDdmStructureId = false;

		deDataListViewModelImpl._columnBitmask = 0;
	}

	@Override
	public CacheModel<DEDataListView> toCacheModel() {
		DEDataListViewCacheModel deDataListViewCacheModel =
			new DEDataListViewCacheModel();

		deDataListViewCacheModel.uuid = getUuid();

		String uuid = deDataListViewCacheModel.uuid;

		if ((uuid != null) && (uuid.length() == 0)) {
			deDataListViewCacheModel.uuid = null;
		}

		deDataListViewCacheModel.deDataListViewId = getDeDataListViewId();

		deDataListViewCacheModel.groupId = getGroupId();

		deDataListViewCacheModel.companyId = getCompanyId();

		deDataListViewCacheModel.userId = getUserId();

		deDataListViewCacheModel.userName = getUserName();

		String userName = deDataListViewCacheModel.userName;

		if ((userName != null) && (userName.length() == 0)) {
			deDataListViewCacheModel.userName = null;
		}

		Date createDate = getCreateDate();

		if (createDate != null) {
			deDataListViewCacheModel.createDate = createDate.getTime();
		}
		else {
			deDataListViewCacheModel.createDate = Long.MIN_VALUE;
		}

		Date modifiedDate = getModifiedDate();

		if (modifiedDate != null) {
			deDataListViewCacheModel.modifiedDate = modifiedDate.getTime();
		}
		else {
			deDataListViewCacheModel.modifiedDate = Long.MIN_VALUE;
		}

		deDataListViewCacheModel.appliedFilters = getAppliedFilters();

		String appliedFilters = deDataListViewCacheModel.appliedFilters;

		if ((appliedFilters != null) && (appliedFilters.length() == 0)) {
			deDataListViewCacheModel.appliedFilters = null;
		}

		deDataListViewCacheModel.ddmStructureId = getDdmStructureId();

		deDataListViewCacheModel.fieldNames = getFieldNames();

		String fieldNames = deDataListViewCacheModel.fieldNames;

		if ((fieldNames != null) && (fieldNames.length() == 0)) {
			deDataListViewCacheModel.fieldNames = null;
		}

		deDataListViewCacheModel.name = getName();

		String name = deDataListViewCacheModel.name;

		if ((name != null) && (name.length() == 0)) {
			deDataListViewCacheModel.name = null;
		}

		deDataListViewCacheModel.sortField = getSortField();

		String sortField = deDataListViewCacheModel.sortField;

		if ((sortField != null) && (sortField.length() == 0)) {
			deDataListViewCacheModel.sortField = null;
		}

		return deDataListViewCacheModel;
	}

	@Override
	public String toString() {
		Map<String, Function<DEDataListView, Object>> attributeGetterFunctions =
			getAttributeGetterFunctions();

		StringBundler sb = new StringBundler(
			4 * attributeGetterFunctions.size() + 2);

		sb.append("{");

		for (Map.Entry<String, Function<DEDataListView, Object>> entry :
				attributeGetterFunctions.entrySet()) {

			String attributeName = entry.getKey();
			Function<DEDataListView, Object> attributeGetterFunction =
				entry.getValue();

			sb.append(attributeName);
			sb.append("=");
			sb.append(attributeGetterFunction.apply((DEDataListView)this));
			sb.append(", ");
		}

		if (sb.index() > 1) {
			sb.setIndex(sb.index() - 1);
		}

		sb.append("}");

		return sb.toString();
	}

	@Override
	public String toXmlString() {
		Map<String, Function<DEDataListView, Object>> attributeGetterFunctions =
			getAttributeGetterFunctions();

		StringBundler sb = new StringBundler(
			5 * attributeGetterFunctions.size() + 4);

		sb.append("<model><model-name>");
		sb.append(getModelClassName());
		sb.append("</model-name>");

		for (Map.Entry<String, Function<DEDataListView, Object>> entry :
				attributeGetterFunctions.entrySet()) {

			String attributeName = entry.getKey();
			Function<DEDataListView, Object> attributeGetterFunction =
				entry.getValue();

			sb.append("<column><column-name>");
			sb.append(attributeName);
			sb.append("</column-name><column-value><![CDATA[");
			sb.append(attributeGetterFunction.apply((DEDataListView)this));
			sb.append("]]></column-value></column>");
		}

		sb.append("</model>");

		return sb.toString();
	}

	private static class EscapedModelProxyProviderFunctionHolder {

		private static final Function<InvocationHandler, DEDataListView>
			_escapedModelProxyProviderFunction = _getProxyProviderFunction();

	}

	private static boolean _entityCacheEnabled;
	private static boolean _finderCacheEnabled;

	private String _uuid;
	private String _originalUuid;
	private long _deDataListViewId;
	private long _groupId;
	private long _originalGroupId;
	private boolean _setOriginalGroupId;
	private long _companyId;
	private long _originalCompanyId;
	private boolean _setOriginalCompanyId;
	private long _userId;
	private String _userName;
	private Date _createDate;
	private Date _modifiedDate;
	private boolean _setModifiedDate;
	private String _appliedFilters;
	private long _ddmStructureId;
	private long _originalDdmStructureId;
	private boolean _setOriginalDdmStructureId;
	private String _fieldNames;
	private String _name;
	private String _nameCurrentLanguageId;
	private String _sortField;
	private long _columnBitmask;
	private DEDataListView _escapedModel;

}