/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.data.cleanup.internal.upgrade.executor;

import com.liferay.change.tracking.service.CTCollectionLocalService;
import com.liferay.change.tracking.service.CTEntryLocalService;
import com.liferay.change.tracking.store.service.CTSContentLocalService;
import com.liferay.data.cleanup.internal.configuration.DataRemovalConfiguration;
import com.liferay.data.cleanup.internal.upgrade.DLPreviewCTSContentDataUpgradeProcess;
import com.liferay.data.cleanup.internal.upgrade.ExpiredJournalArticleUpgradeProcess;
import com.liferay.data.cleanup.internal.upgrade.OutdatedPublishedCTCollectionUpgradeProcess;
import com.liferay.data.cleanup.internal.upgrade.PublishedCTSContentDataUpgradeProcess;
import com.liferay.data.cleanup.internal.upgrade.util.ConfigurationUtil;
import com.liferay.journal.service.JournalArticleLocalService;
import com.liferay.portal.configuration.metatype.bnd.util.ConfigurableUtil;
import com.liferay.portal.kernel.cache.CacheRegistryUtil;
import com.liferay.portal.kernel.model.Release;
import com.liferay.portal.kernel.service.ReleaseLocalService;
import com.liferay.portal.kernel.upgrade.UpgradeProcess;
import com.liferay.portal.kernel.util.Portal;
import java.util.Map;
import java.util.function.Supplier;
import org.apache.felix.cm.PersistenceManager;
import org.osgi.service.cm.ConfigurationAdmin;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.component.annotations.Reference;

@Component(configurationPid={"com.liferay.data.cleanup.internal.configuration.DataRemovalConfiguration"}, configurationPolicy=ConfigurationPolicy.REQUIRE, service={})
public class DataRemovalExecutor {
    @Reference
    private ConfigurationAdmin _configurationAdmin;
    @Reference
    private CTCollectionLocalService _ctCollectionLocalService;
    @Reference
    private CTEntryLocalService _ctEntryLocalService;
    @Reference
    private CTSContentLocalService _ctsContentLocalService;
    @Reference
    private JournalArticleLocalService _journalArticleLocalService;
    @Reference
    private PersistenceManager _persistenceManager;
    @Reference
    private Portal _portal;
    @Reference
    private ReleaseLocalService _releaseLocalService;

    @Activate
    protected void activate(Map<String, Object> properties) throws Exception {
        DataRemovalConfiguration dataRemovalConfiguration = (DataRemovalConfiguration)ConfigurableUtil.createConfigurable(DataRemovalConfiguration.class, properties);
        ConfigurationUtil.deleteConfiguration(this._configurationAdmin, this._persistenceManager, DataRemovalConfiguration.class.getName());
        this._removeModuleData(dataRemovalConfiguration::removeDLPreviewCTSContentData, "com.liferay.change.tracking.service", () -> new DLPreviewCTSContentDataUpgradeProcess(this._ctCollectionLocalService, this._ctEntryLocalService, this._portal));
        this._removeModuleData(dataRemovalConfiguration::removeOutdatedPublishedCTCollections, "com.liferay.change.tracking.service", () -> new OutdatedPublishedCTCollectionUpgradeProcess(this._ctCollectionLocalService));
        this._removeModuleData(dataRemovalConfiguration::removePublishedCTSContentData, "com.liferay.change.tracking.store.service", () -> new PublishedCTSContentDataUpgradeProcess(this._ctsContentLocalService, this._portal));
        this._removeModuleData(dataRemovalConfiguration::removeExpiredJournalArticles, "com.liferay.journal.service", () -> new ExpiredJournalArticleUpgradeProcess(this._journalArticleLocalService));
    }

    private void _removeModuleData(Supplier<Boolean> booleanSupplier, String servletContextName, Supplier<UpgradeProcess> upgradeProcessSupplier) throws Exception {
        Release release;
        if (booleanSupplier.get().booleanValue() && (release = this._releaseLocalService.fetchRelease(servletContextName)) != null) {
            UpgradeProcess upgradeProcess = upgradeProcessSupplier.get();
            upgradeProcess.upgrade();
            CacheRegistryUtil.clear();
        }
    }
}

