/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of the Liferay Enterprise
 * Subscription License ("License"). You may not use this file except in
 * compliance with the License. You can obtain a copy of the License by
 * contacting Liferay, Inc. See the License for the specific language governing
 * permissions and limitations under the License, including but not limited to
 * distribution rights of the Software.
 *
 *
 *
 */

package com.liferay.data.cleanup.internal.upgrade;

import com.liferay.change.tracking.model.CTEntryTable;
import com.liferay.change.tracking.store.model.CTSContent;
import com.liferay.change.tracking.store.model.CTSContentTable;
import com.liferay.change.tracking.store.service.CTSContentLocalService;
import com.liferay.petra.sql.dsl.DSLQueryFactoryUtil;
import com.liferay.portal.kernel.upgrade.UpgradeProcess;
import com.liferay.portal.kernel.util.Portal;

import java.util.List;

/**
 * @author David Truong
 */
public class PublishedCTSContentDataUpgradeProcess extends UpgradeProcess {

	public PublishedCTSContentDataUpgradeProcess(
		CTSContentLocalService ctsContentLocalService, Portal portal) {

		_ctsContentLocalService = ctsContentLocalService;
		_portal = portal;
	}

	@Override
	protected void doUpgrade() throws Exception {
		List<Long> ctsContentIds = _ctsContentLocalService.dslQuery(
			DSLQueryFactoryUtil.select(
				CTSContentTable.INSTANCE.ctsContentId
			).from(
				CTSContentTable.INSTANCE
			).where(
				CTSContentTable.INSTANCE.ctsContentId.notIn(
					DSLQueryFactoryUtil.select(
						CTEntryTable.INSTANCE.modelClassPK
					).from(
						CTEntryTable.INSTANCE
					).where(
						CTEntryTable.INSTANCE.modelClassNameId.eq(
							_portal.getClassNameId(CTSContent.class.getName()))
					))
			));

		for (long ctsContentId : ctsContentIds) {
			_ctsContentLocalService.deleteCTSContent(ctsContentId);
		}
	}

	private final CTSContentLocalService _ctsContentLocalService;
	private final Portal _portal;

}