/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of the Liferay Enterprise
 * Subscription License ("License"). You may not use this file except in
 * compliance with the License. You can obtain a copy of the License by
 * contacting Liferay, Inc. See the License for the specific language governing
 * permissions and limitations under the License, including but not limited to
 * distribution rights of the Software.
 *
 *
 *
 */

package com.liferay.data.cleanup.internal.upgrade;

import com.liferay.journal.model.JournalArticle;
import com.liferay.journal.service.JournalArticleLocalService;
import com.liferay.portal.kernel.dao.orm.DynamicQuery;
import com.liferay.portal.kernel.dao.orm.Property;
import com.liferay.portal.kernel.dao.orm.PropertyFactoryUtil;
import com.liferay.portal.kernel.upgrade.UpgradeProcess;
import com.liferay.portal.kernel.workflow.WorkflowConstants;

import java.util.List;

/**
 * @author Kevin Lee
 */
public class ExpiredJournalArticleUpgradeProcess extends UpgradeProcess {

	public ExpiredJournalArticleUpgradeProcess(
		JournalArticleLocalService journalArticleLocalService) {

		_journalArticleLocalService = journalArticleLocalService;
	}

	@Override
	protected void doUpgrade() throws Exception {
		DynamicQuery dynamicQuery = _journalArticleLocalService.dynamicQuery();

		Property property = PropertyFactoryUtil.forName("status");

		dynamicQuery.add(property.eq(WorkflowConstants.STATUS_EXPIRED));

		List<JournalArticle> journalArticles =
			_journalArticleLocalService.dynamicQuery(dynamicQuery);

		for (JournalArticle journalArticle : journalArticles) {
			_journalArticleLocalService.deleteArticle(journalArticle);
		}
	}

	private final JournalArticleLocalService _journalArticleLocalService;

}