/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of the Liferay Enterprise
 * Subscription License ("License"). You may not use this file except in
 * compliance with the License. You can obtain a copy of the License by
 * contacting Liferay, Inc. See the License for the specific language governing
 * permissions and limitations under the License, including but not limited to
 * distribution rights of the Software.
 *
 *
 *
 */

package com.liferay.data.cleanup.internal.upgrade;

/**
 * @author Kevin Lee
 */
public class OpenSocialUpgradeProcess extends BaseUpgradeProcess {

	@Override
	protected void doUpgrade() throws Exception {
		removeExpandoData("OPEN_SOCIAL_DATA_");

		removePortletData(
			new String[] {"opensocial-portlet"}, null,
			new String[] {
				"1_WAR_opensocialportlet", "2_WAR_opensocialportlet",
				"3_WAR_opensocialportlet", "4_WAR_opensocialportlet"
			});

		removeServiceData(
			"OpenSocial", new String[] {"opensocial-portlet"},
			new String[] {
				"com.liferay.opensocial", "com.liferay.opensocial.model.Gadget",
				"com.liferay.opensocial.model.OAuthConsumer",
				"com.liferay.opensocial.model.OAuthToken"
			},
			new String[] {
				"OpenSocial_Gadget", "OpenSocial_OAuthConsumer",
				"OpenSocial_OAuthToken"
			});
	}

}