/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of the Liferay Enterprise
 * Subscription License ("License"). You may not use this file except in
 * compliance with the License. You can obtain a copy of the License by
 * contacting Liferay, Inc. See the License for the specific language governing
 * permissions and limitations under the License, including but not limited to
 * distribution rights of the Software.
 *
 *
 *
 */

package com.liferay.data.cleanup.internal.upgrade.util;

import aQute.bnd.annotation.metatype.Meta;

import com.liferay.portal.kernel.util.HashMapDictionaryBuilder;

import java.io.IOException;

import java.lang.reflect.Method;

import java.util.Dictionary;
import java.util.Objects;

import org.apache.felix.cm.PersistenceManager;

/**
 * @author Kevin Lee
 */
public class ConfigurationUtil {

	public static void resetConfiguration(
			PersistenceManager persistenceManager, Class<?> clazz)
		throws IOException {

		Dictionary<String, Object> properties = persistenceManager.load(
			clazz.getName());

		if (properties == null) {
			return;
		}

		Dictionary<String, Object> newProperties =
			HashMapDictionaryBuilder.<String, Object>putAll(
				properties
			).build();

		for (Method method : clazz.getMethods()) {
			if (!method.isAnnotationPresent(Meta.AD.class) ||
				!Objects.equals(method.getReturnType(), Boolean.TYPE)) {

				continue;
			}

			if (properties.get(method.getName()) != null) {
				newProperties.put(method.getName(), false);
			}
		}

		persistenceManager.store(clazz.getName(), newProperties);
	}

}