/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of the Liferay Enterprise
 * Subscription License ("License"). You may not use this file except in
 * compliance with the License. You can obtain a copy of the License by
 * contacting Liferay, Inc. See the License for the specific language governing
 * permissions and limitations under the License, including but not limited to
 * distribution rights of the Software.
 *
 *
 *
 */

package com.liferay.data.cleanup.internal.upgrade;

import com.liferay.message.boards.service.MBThreadLocalService;
import com.liferay.portal.dao.orm.common.SQLTransformer;

import java.sql.PreparedStatement;
import java.sql.ResultSet;

/**
 * @author Alejandro Tardín
 */
public class PrivateMessagingUpgradeProcess extends BaseUpgradeProcess {

	public PrivateMessagingUpgradeProcess(
		MBThreadLocalService mbThreadLocalService) {

		_mbThreadLocalService = mbThreadLocalService;
	}

	@Override
	protected void doUpgrade() throws Exception {
		_deleteMBThreads();

		removePortletData(
			new String[] {"com.liferay.social.privatemessaging.web"}, null,
			new String[] {
				"com_liferay_social_privatemessaging_web_portlet_" +
					"PrivateMessagingPortlet"
			});

		removeServiceData(
			"PM", new String[] {"com.liferay.social.privatemessaging.service"},
			new String[] {
				"com.liferay.social.privatemessaging.model.UserThread"
			},
			new String[] {"PM_UserThread"});
	}

	private void _deleteMBThreads() throws Exception {
		try (PreparedStatement preparedStatement = connection.prepareStatement(
				SQLTransformer.transform(
					"select mbThreadId from PM_UserThread"));
			ResultSet resultSet = preparedStatement.executeQuery()) {

			while (resultSet.next()) {
				_mbThreadLocalService.deleteMBThread(resultSet.getLong(1));
			}
		}
	}

	private final MBThreadLocalService _mbThreadLocalService;

}