/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of the Liferay Enterprise
 * Subscription License ("License"). You may not use this file except in
 * compliance with the License. You can obtain a copy of the License by
 * contacting Liferay, Inc. See the License for the specific language governing
 * permissions and limitations under the License, including but not limited to
 * distribution rights of the Software.
 *
 *
 *
 */

package com.liferay.data.cleanup.internal.upgrade;

/**
 * @author Preston Crary
 */
public class ChatUpgradeProcess extends BaseUpgradeProcess {

	@Override
	protected void doUpgrade() throws Exception {
		removePortletData(
			new String[] {"com.liferay.chat.web"}, null,
			new String[] {"com_liferay_chat_web_portlet_ChatPortlet"});

		removeServiceData(
			"Chat", new String[] {"com.liferay.chat.service"},
			new String[] {
				"com.liferay.chat.model.Entry", "com.liferay.chat.model.Status"
			},
			new String[] {"Chat_Entry", "Chat_Status"});
	}

}