/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of the Liferay Enterprise
 * Subscription License ("License"). You may not use this file except in
 * compliance with the License. You can obtain a copy of the License by
 * contacting Liferay, Inc. See the License for the specific language governing
 * permissions and limitations under the License, including but not limited to
 * distribution rights of the Software.
 *
 *
 *
 */

package com.liferay.data.cleanup.internal.configuration;

import aQute.bnd.annotation.metatype.Meta;

import com.liferay.portal.configuration.metatype.annotations.ExtendedObjectClassDefinition;

/**
 * @author Preston Crary
 */
@ExtendedObjectClassDefinition(
	category = "upgrades", liferayLearnMessageKey = "general",
	liferayLearnMessageResource = "data-cleanup"
)
@Meta.OCD(
	id = "com.liferay.data.cleanup.internal.configuration.DataCleanupConfiguration",
	name = "data-cleanup-configuration-name"
)
public interface DataCleanupConfiguration {

	@Meta.AD(
		deflt = "false", name = "clean-up-chat-module-data", required = false
	)
	public boolean cleanUpChatModuleData();

	@Meta.AD(
		deflt = "false", name = "clean-up-dictionary-module-data",
		required = false
	)
	public boolean cleanUpDictionaryModuleData();

	@Meta.AD(
		deflt = "false", name = "clean-up-directory-module-data",
		required = false
	)
	public boolean cleanUpDirectoryModuleData();

	@Meta.AD(
		deflt = "false", name = "clean-up-hello-world-module-data",
		required = false
	)
	public boolean cleanUpHelloWorldModuleData();

	@Meta.AD(
		deflt = "false", name = "clean-up-image-editor-module-data",
		required = false
	)
	public boolean cleanUpImageEditorModuleData();

	@Meta.AD(
		deflt = "false", name = "clean-up-invitation-module-data",
		required = false
	)
	public boolean cleanUpInvitationModuleData();

	@Meta.AD(
		deflt = "false", name = "clean-up-mail-reader-module-data",
		required = false
	)
	public boolean cleanUpMailReaderModuleData();

	@Meta.AD(
		deflt = "false", name = "clean-up-open-social-module-data",
		required = false
	)
	public boolean cleanUpOpenSocialModuleData();

	@Meta.AD(
		deflt = "false", name = "clean-up-private-messaging-module-data",
		required = false
	)
	public boolean cleanUpPrivateMessagingModuleData();

	@Meta.AD(
		deflt = "false", name = "clean-up-software-catalog-module-data",
		required = false
	)
	public boolean cleanUpSoftwareCatalogModuleData();

	@Meta.AD(
		deflt = "false", name = "clean-up-shopping-module-data",
		required = false
	)
	public boolean cleanUpShoppingModuleData();

	@Meta.AD(
		deflt = "false", name = "clean-up-twitter-module-data", required = false
	)
	public boolean cleanUpTwitterModuleData();

}