/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.data.cleanup.internal.upgrade;

import com.liferay.data.cleanup.internal.configuration.DataRemovalConfiguration;
import com.liferay.data.cleanup.internal.upgrade.ExpiredJournalArticleUpgradeProcess;
import com.liferay.data.cleanup.internal.upgrade.util.ConfigurationUtil;
import com.liferay.journal.service.JournalArticleLocalService;
import com.liferay.petra.reflect.ReflectionUtil;
import com.liferay.portal.configuration.metatype.bnd.util.ConfigurableUtil;
import com.liferay.portal.kernel.cache.CacheRegistryUtil;
import com.liferay.portal.kernel.model.Release;
import com.liferay.portal.kernel.service.ReleaseLocalService;
import com.liferay.portal.kernel.upgrade.UpgradeException;
import com.liferay.portal.kernel.upgrade.UpgradeProcess;
import com.liferay.portal.upgrade.registry.UpgradeStepRegistrator;
import java.util.Map;
import java.util.function.Supplier;
import org.apache.felix.cm.PersistenceManager;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(configurationPid={"com.liferay.data.cleanup.internal.configuration.DataRemovalConfiguration"}, immediate=true, service={UpgradeStepRegistrator.class})
public class DataRemoval
implements UpgradeStepRegistrator {
    private DataRemovalConfiguration _dataRemovalConfiguration;
    @Reference
    private JournalArticleLocalService _journalArticleLocalService;
    @Reference
    private PersistenceManager _persistenceManager;
    @Reference
    private ReleaseLocalService _releaseLocalService;

    public void register(UpgradeStepRegistrator.Registry registry) {
        try {
            ConfigurationUtil.resetConfiguration(this._persistenceManager, DataRemovalConfiguration.class);
            this._removeModuleData(this._dataRemovalConfiguration::removeExpiredJournalArticles, "com.liferay.journal.service", () -> new ExpiredJournalArticleUpgradeProcess(this._journalArticleLocalService));
        }
        catch (Exception exception) {
            ReflectionUtil.throwException((Throwable)exception);
        }
    }

    @Activate
    protected void activate(Map<String, Object> properties) {
        this._dataRemovalConfiguration = (DataRemovalConfiguration)ConfigurableUtil.createConfigurable(DataRemovalConfiguration.class, properties);
    }

    private void _removeModuleData(Supplier<Boolean> booleanSupplier, String servletContextName, Supplier<UpgradeProcess> upgradeProcessSupplier) throws UpgradeException {
        Release release;
        if (booleanSupplier.get().booleanValue() && (release = this._releaseLocalService.fetchRelease(servletContextName)) != null) {
            UpgradeProcess upgradeProcess = upgradeProcessSupplier.get();
            upgradeProcess.upgrade();
            CacheRegistryUtil.clear();
        }
    }
}

