/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.data.cleanup.internal.upgrade;

import com.liferay.data.cleanup.internal.configuration.DataCleanupConfiguration;
import com.liferay.data.cleanup.internal.upgrade.ChatUpgradeProcess;
import com.liferay.data.cleanup.internal.upgrade.DictionaryUpgradeProcess;
import com.liferay.data.cleanup.internal.upgrade.DirectoryUpgradeProcess;
import com.liferay.data.cleanup.internal.upgrade.ImageEditorUpgradeProcess;
import com.liferay.data.cleanup.internal.upgrade.InvitationUpgradeProcess;
import com.liferay.data.cleanup.internal.upgrade.MailReaderUpgradeProcess;
import com.liferay.data.cleanup.internal.upgrade.OpenSocialUpgradeProcess;
import com.liferay.data.cleanup.internal.upgrade.PrivateMessagingUpgradeProcess;
import com.liferay.data.cleanup.internal.upgrade.ShoppingUpgradeProcess;
import com.liferay.data.cleanup.internal.upgrade.SoftwareCatalogUpgradeProcess;
import com.liferay.data.cleanup.internal.upgrade.TwitterUpgradeProcess;
import com.liferay.data.cleanup.internal.upgrade.UpgradeHelloWorld;
import com.liferay.data.cleanup.internal.upgrade.util.ConfigurationUtil;
import com.liferay.message.boards.service.MBMessageLocalService;
import com.liferay.message.boards.service.MBThreadLocalService;
import com.liferay.petra.reflect.ReflectionUtil;
import com.liferay.portal.configuration.metatype.bnd.util.ConfigurableUtil;
import com.liferay.portal.kernel.cache.CacheRegistryUtil;
import com.liferay.portal.kernel.model.Release;
import com.liferay.portal.kernel.service.ImageLocalService;
import com.liferay.portal.kernel.service.ReleaseLocalService;
import com.liferay.portal.kernel.upgrade.UpgradeException;
import com.liferay.portal.kernel.upgrade.UpgradeProcess;
import com.liferay.portal.upgrade.registry.UpgradeStepRegistrator;
import com.liferay.ratings.kernel.service.RatingsStatsLocalService;
import com.liferay.subscription.service.SubscriptionLocalService;
import java.util.Map;
import java.util.function.Supplier;
import org.apache.felix.cm.PersistenceManager;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(configurationPid={"com.liferay.data.cleanup.internal.configuration.DataCleanupConfiguration"}, immediate=true, service={UpgradeStepRegistrator.class})
public class DataCleanup
implements UpgradeStepRegistrator {
    private DataCleanupConfiguration _dataCleanupConfiguration;
    @Reference
    private ImageLocalService _imageLocalService;
    @Reference
    private MBMessageLocalService _mbMessageLocalService;
    @Reference
    private MBThreadLocalService _mbThreadLocalService;
    @Reference
    private PersistenceManager _persistenceManager;
    @Reference
    private RatingsStatsLocalService _ratingsStatsLocalService;
    @Reference
    private ReleaseLocalService _releaseLocalService;
    @Reference
    private SubscriptionLocalService _subscriptionLocalService;

    public void register(UpgradeStepRegistrator.Registry registry) {
        try {
            ConfigurationUtil.resetConfiguration(this._persistenceManager, DataCleanupConfiguration.class);
            this._cleanUpModuleData(this._dataCleanupConfiguration::cleanUpChatModuleData, "com.liferay.chat.service", ChatUpgradeProcess::new);
            this._cleanUpModuleData(this._dataCleanupConfiguration::cleanUpDictionaryModuleData, "com.liferay.dictionary.web", DictionaryUpgradeProcess::new);
            this._cleanUpModuleData(this._dataCleanupConfiguration::cleanUpDirectoryModuleData, "com.liferay.directory.web", DirectoryUpgradeProcess::new);
            this._cleanUpModuleData(this._dataCleanupConfiguration::cleanUpImageEditorModuleData, "com.liferay.frontend.image.editor.web", ImageEditorUpgradeProcess::new);
            this._cleanUpModuleData(this._dataCleanupConfiguration::cleanUpHelloWorldModuleData, "com.liferay.hello.world.web", UpgradeHelloWorld::new);
            this._cleanUpModuleData(this._dataCleanupConfiguration::cleanUpInvitationModuleData, "com.liferay.invitation.web", InvitationUpgradeProcess::new);
            this._cleanUpModuleData(this._dataCleanupConfiguration::cleanUpMailReaderModuleData, "com.liferay.mail.reader.service", MailReaderUpgradeProcess::new);
            this._cleanUpModuleData(this._dataCleanupConfiguration::cleanUpShoppingModuleData, "com.liferay.shopping.service", () -> new ShoppingUpgradeProcess(this._imageLocalService));
            this._cleanUpModuleData(this._dataCleanupConfiguration::cleanUpPrivateMessagingModuleData, "com.liferay.social.privatemessaging.service", () -> new PrivateMessagingUpgradeProcess(this._mbThreadLocalService));
            this._cleanUpModuleData(this._dataCleanupConfiguration::cleanUpSoftwareCatalogModuleData, "com.liferay.softwarecatalog.service", () -> new SoftwareCatalogUpgradeProcess(this._imageLocalService, this._mbMessageLocalService, this._ratingsStatsLocalService, this._subscriptionLocalService));
            this._cleanUpModuleData(this._dataCleanupConfiguration::cleanUpTwitterModuleData, "com.liferay.twitter.service", TwitterUpgradeProcess::new);
            this._cleanUpModuleData(this._dataCleanupConfiguration::cleanUpOpenSocialModuleData, "opensocial-portlet", OpenSocialUpgradeProcess::new);
        }
        catch (Exception exception) {
            ReflectionUtil.throwException((Throwable)exception);
        }
    }

    @Activate
    protected void activate(Map<String, Object> properties) {
        this._dataCleanupConfiguration = (DataCleanupConfiguration)ConfigurableUtil.createConfigurable(DataCleanupConfiguration.class, properties);
    }

    private void _cleanUpModuleData(Supplier<Boolean> booleanSupplier, String servletContextName, Supplier<UpgradeProcess> upgradeProcessSupplier) throws UpgradeException {
        Release release;
        if (booleanSupplier.get().booleanValue() && (release = this._releaseLocalService.fetchRelease(servletContextName)) != null) {
            UpgradeProcess upgradeProcess = upgradeProcessSupplier.get();
            upgradeProcess.upgrade();
            CacheRegistryUtil.clear();
        }
    }
}

