/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.data.cleanup.util;

import com.liferay.data.cleanup.DataCleanup;
import com.liferay.portal.kernel.util.StringUtil;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;

public class DataCleanupUtil {
    private static final List<DataCleanup> _moduleDataCleanups = new CopyOnWriteArrayList<DataCleanup>();
    private static final List<DataCleanup> _systemDataCleanups = new CopyOnWriteArrayList<DataCleanup>();

    public static List<DataCleanup> getModuleDataCleanups() {
        return Collections.unmodifiableList(_moduleDataCleanups);
    }

    public static List<DataCleanup> getSystemDataCleanups() {
        return Collections.unmodifiableList(_systemDataCleanups);
    }

    public static void registerDataCleanup(DataCleanup dataCleanup) {
        List<DataCleanup> dataCleanups = DataCleanupUtil._getDataCleanups(dataCleanup.getType());
        dataCleanups.add(dataCleanup);
    }

    public static void unregisterDataCleanup(DataCleanup dataCleanup) {
        List<DataCleanup> dataCleanups = DataCleanupUtil._getDataCleanups(dataCleanup.getType());
        dataCleanups.remove(dataCleanup);
    }

    private static List<DataCleanup> _getDataCleanups(String type) {
        if (StringUtil.equalsIgnoreCase((String)type, (String)"module")) {
            return _moduleDataCleanups;
        }
        if (StringUtil.equalsIgnoreCase((String)type, (String)"system")) {
            return _systemDataCleanups;
        }
        throw new IllegalArgumentException("Invalid type: " + type);
    }
}

