@if "%DEBUG%" == "" @echo off
@rem ##########################################################################
@rem
@rem  css-builder startup script for Windows
@rem
@rem ##########################################################################

@rem Set local scope for the variables with windows NT shell
if "%OS%"=="Windows_NT" setlocal

set DIRNAME=%~dp0
if "%DIRNAME%" == "" set DIRNAME=.
set APP_BASE_NAME=%~n0
set APP_HOME=%DIRNAME%..

@rem Add default JVM options here. You can also use JAVA_OPTS and CSS_BUILDER_OPTS to pass JVM options to this script.
set DEFAULT_JVM_OPTS=

@rem Find java.exe
if defined JAVA_HOME goto findJavaFromJavaHome

set JAVA_EXE=java.exe
%JAVA_EXE% -version >NUL 2>&1
if "%ERRORLEVEL%" == "0" goto init

echo.
echo ERROR: JAVA_HOME is not set and no 'java' command could be found in your PATH.
echo.
echo Please set the JAVA_HOME variable in your environment to match the
echo location of your Java installation.

goto fail

:findJavaFromJavaHome
set JAVA_HOME=%JAVA_HOME:"=%
set JAVA_EXE=%JAVA_HOME%/bin/java.exe

if exist "%JAVA_EXE%" goto init

echo.
echo ERROR: JAVA_HOME is set to an invalid directory: %JAVA_HOME%
echo.
echo Please set the JAVA_HOME variable in your environment to match the
echo location of your Java installation.

goto fail

:init
@rem Get command-line arguments, handling Windows variants

if not "%OS%" == "Windows_NT" goto win9xME_args

:win9xME_args
@rem Slurp the command line arguments.
set CMD_LINE_ARGS=
set _SKIP=2

:win9xME_args_slurp
if "x%~1" == "x" goto execute

set CMD_LINE_ARGS=%*

:execute
@rem Setup the command line

set CLASSPATH=%APP_HOME%\lib\com.liferay.css.builder-1.1.2.jar;%APP_HOME%\lib\com.liferay.rtl.css-1.0.5.jar;%APP_HOME%\lib\com.liferay.sass.compiler.jni-2.0.6.jar;%APP_HOME%\lib\com.liferay.sass.compiler.ruby-2.0.4.jar;%APP_HOME%\lib\ant-1.9.4.jar;%APP_HOME%\lib\slf4j-log4j12-1.7.2.jar;%APP_HOME%\lib\plexus-build-api-0.0.7.jar;%APP_HOME%\lib\com.liferay.portal.impl-2.0.0.jar;%APP_HOME%\lib\com.liferay.portal.kernel-2.0.0.jar;%APP_HOME%\lib\maven-artifact-3.2.5.jar;%APP_HOME%\lib\maven-core-3.2.5.jar;%APP_HOME%\lib\maven-plugin-api-3.2.5.jar;%APP_HOME%\lib\com.liferay.sass.compiler.api-2.0.1.jar;%APP_HOME%\lib\jruby-complete-1.7.20.jar;%APP_HOME%\lib\ant-launcher-1.9.4.jar;%APP_HOME%\lib\slf4j-api-1.7.2.jar;%APP_HOME%\lib\log4j-1.2.17.jar;%APP_HOME%\lib\maven-model-3.2.5.jar;%APP_HOME%\lib\maven-settings-3.2.5.jar;%APP_HOME%\lib\maven-settings-builder-3.2.5.jar;%APP_HOME%\lib\maven-repository-metadata-3.2.5.jar;%APP_HOME%\lib\maven-model-builder-3.2.5.jar;%APP_HOME%\lib\maven-aether-provider-3.2.5.jar;%APP_HOME%\lib\aether-impl-1.0.0.v20140518.jar;%APP_HOME%\lib\aether-api-1.0.0.v20140518.jar;%APP_HOME%\lib\aether-util-1.0.0.v20140518.jar;%APP_HOME%\lib\org.eclipse.sisu.plexus-0.3.0.M1.jar;%APP_HOME%\lib\sisu-guice-3.2.3-no_aop.jar;%APP_HOME%\lib\plexus-interpolation-1.21.jar;%APP_HOME%\lib\plexus-classworlds-2.5.2.jar;%APP_HOME%\lib\plexus-component-annotations-1.5.5.jar;%APP_HOME%\lib\plexus-sec-dispatcher-1.3.jar;%APP_HOME%\lib\aether-spi-1.0.0.v20140518.jar;%APP_HOME%\lib\cdi-api-1.0.jar;%APP_HOME%\lib\org.eclipse.sisu.inject-0.3.0.M1.jar;%APP_HOME%\lib\javax.inject-1.jar;%APP_HOME%\lib\aopalliance-1.0.jar;%APP_HOME%\lib\guava-16.0.1.jar;%APP_HOME%\lib\plexus-cipher-1.4.jar;%APP_HOME%\lib\jsr250-api-1.0.jar;%APP_HOME%\lib\plexus-utils-3.0.20.jar

@rem Execute css-builder
"%JAVA_EXE%" %DEFAULT_JVM_OPTS% %JAVA_OPTS% %CSS_BUILDER_OPTS%  -classpath "%CLASSPATH%" com.liferay.css.builder.CSSBuilder %CMD_LINE_ARGS%

:end
@rem End local scope for the variables with windows NT shell
if "%ERRORLEVEL%"=="0" goto mainEnd

:fail
rem Set variable CSS_BUILDER_EXIT_CONSOLE if you need the _script_ return code instead of
rem the _cmd.exe /c_ return code!
if  not "" == "%CSS_BUILDER_EXIT_CONSOLE%" exit 1
exit /b 1

:mainEnd
if "%OS%"=="Windows_NT" endlocal

:omega
