/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.xmlrpc;

import com.liferay.portal.kernel.io.unsync.UnsyncStringReader;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.Tuple;
import com.liferay.portal.kernel.xmlrpc.Response;
import com.liferay.portal.kernel.xmlrpc.Success;
import com.liferay.portal.kernel.xmlrpc.XmlRpcException;
import com.liferay.portal.kernel.xmlrpc.XmlRpcUtil;
import com.liferay.portal.xml.StAXReaderUtil;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamReader;

public class XmlRpcParser {
    public static String buildMethod(String methodName, Object[] arguments) throws XmlRpcException {
        StringBundler sb = new StringBundler(arguments.length * 3 + 8);
        sb.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        sb.append("<methodCall>");
        sb.append("<methodName>");
        sb.append(methodName);
        sb.append("</methodName>");
        sb.append("<params>");
        for (Object argument : arguments) {
            sb.append("<param>");
            sb.append(XmlRpcParser.wrapValue(argument));
            sb.append("</param>");
        }
        sb.append("</params>");
        sb.append("</methodCall>");
        return sb.toString();
    }

    public static Tuple parseMethod(String xml) throws IOException {
        XMLStreamReader xmlStreamReader = null;
        try {
            XMLInputFactory xmlInputFactory = StAXReaderUtil.getXMLInputFactory();
            xmlStreamReader = xmlInputFactory.createXMLStreamReader((Reader)new UnsyncStringReader(xml));
            xmlStreamReader.nextTag();
            xmlStreamReader.nextTag();
            xmlStreamReader.next();
            String methodName = xmlStreamReader.getText();
            ArrayList<Object> arguments = new ArrayList<Object>();
            xmlStreamReader.nextTag();
            String name = xmlStreamReader.getLocalName();
            while (!name.equals("methodCall")) {
                String text;
                xmlStreamReader.nextTag();
                name = xmlStreamReader.getLocalName();
                if (!name.equals("param")) continue;
                xmlStreamReader.nextTag();
                name = xmlStreamReader.getLocalName();
                int event = xmlStreamReader.next();
                if (event == 1) {
                    name = xmlStreamReader.getLocalName();
                    xmlStreamReader.next();
                    text = xmlStreamReader.getText();
                    if (name.equals("string")) {
                        arguments.add(text);
                    } else if (name.equals("int") || name.equals("i4")) {
                        arguments.add(GetterUtil.getInteger((String)text));
                    } else if (name.equals("double")) {
                        arguments.add(GetterUtil.getDouble((String)text));
                    } else if (name.equals("boolean")) {
                        arguments.add(GetterUtil.getBoolean((String)text));
                    } else {
                        throw new IOException("XML-RPC not implemented for " + name);
                    }
                    xmlStreamReader.nextTag();
                    xmlStreamReader.nextTag();
                    xmlStreamReader.nextTag();
                } else {
                    text = xmlStreamReader.getText();
                    arguments.add(text);
                    xmlStreamReader.nextTag();
                    xmlStreamReader.nextTag();
                }
                name = xmlStreamReader.getLocalName();
            }
            Tuple tuple = new Tuple(new Object[]{methodName, arguments.toArray()});
            return tuple;
        }
        catch (Exception e) {
            throw new IOException(e);
        }
        finally {
            if (xmlStreamReader != null) {
                try {
                    xmlStreamReader.close();
                }
                catch (Exception e) {}
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Response parseResponse(String xml) throws XmlRpcException {
        int i;
        String description;
        int code;
        String name;
        XMLStreamReader xmlStreamReader = null;
        try {
            XMLInputFactory xmlInputFactory = StAXReaderUtil.getXMLInputFactory();
            xmlStreamReader = xmlInputFactory.createXMLStreamReader((Reader)new UnsyncStringReader(xml));
            xmlStreamReader.nextTag();
            xmlStreamReader.nextTag();
            name = xmlStreamReader.getLocalName();
            if (name.equals("params")) {
                String description2 = null;
                xmlStreamReader.nextTag();
                xmlStreamReader.nextTag();
                int event = xmlStreamReader.next();
                if (event == 1) {
                    xmlStreamReader.next();
                    description2 = xmlStreamReader.getText();
                } else {
                    description2 = xmlStreamReader.getText();
                }
                Success success = XmlRpcUtil.createSuccess((String)description2);
                return success;
            }
            if (!name.equals("fault")) {
                Response response = null;
                return response;
            }
            code = 0;
            description = null;
            xmlStreamReader.nextTag();
            xmlStreamReader.nextTag();
            i = 0;
        }
        catch (Exception e) {
            throw new XmlRpcException(xml, (Throwable)e);
        }
        finally {
            if (xmlStreamReader != null) {
                try {
                    xmlStreamReader.close();
                }
                catch (Exception e) {}
            }
        }
        while (i < 2) {
            xmlStreamReader.nextTag();
            xmlStreamReader.nextTag();
            xmlStreamReader.next();
            String valueName = xmlStreamReader.getText();
            if (valueName.equals("faultCode")) {
                xmlStreamReader.nextTag();
                xmlStreamReader.nextTag();
                xmlStreamReader.nextTag();
                name = xmlStreamReader.getLocalName();
                if (name.equals("int") || name.equals("i4")) {
                    xmlStreamReader.next();
                    code = GetterUtil.getInteger((String)xmlStreamReader.getText());
                }
                xmlStreamReader.nextTag();
                xmlStreamReader.nextTag();
                xmlStreamReader.nextTag();
            } else if (valueName.equals("faultString")) {
                xmlStreamReader.nextTag();
                xmlStreamReader.nextTag();
                int event = xmlStreamReader.next();
                if (event == 1) {
                    xmlStreamReader.next();
                    description = xmlStreamReader.getText();
                    xmlStreamReader.nextTag();
                } else {
                    description = xmlStreamReader.getText();
                }
                xmlStreamReader.nextTag();
                xmlStreamReader.nextTag();
            }
            ++i;
        }
        return XmlRpcUtil.createFault((int)code, description);
    }

    public static String wrapValue(Object value) throws XmlRpcException {
        if (value == null) {
            return "";
        }
        StringBundler sb = new StringBundler(5);
        sb.append("<value>");
        if (value instanceof String) {
            sb.append("<string>");
            sb.append(value.toString());
            sb.append("</string>");
        } else if (value instanceof Integer || value instanceof Short) {
            sb.append("<i4>");
            sb.append(value.toString());
            sb.append("</i4>");
        } else if (value instanceof Double || value instanceof Float) {
            sb.append("<double>");
            sb.append(value.toString());
            sb.append("</double>");
        } else if (value instanceof Boolean) {
            sb.append("<boolean>");
            if (((Boolean)value).booleanValue()) {
                sb.append('1');
            } else {
                sb.append('0');
            }
            sb.append("</boolean>");
        } else {
            throw new XmlRpcException("Unsupported type " + value.getClass());
        }
        sb.append("</value>");
        return sb.toString();
    }
}

