/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.upload;

import com.liferay.portal.kernel.io.unsync.UnsyncByteArrayInputStream;
import com.liferay.portal.kernel.io.unsync.UnsyncByteArrayOutputStream;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.servlet.ServletInputStreamAdapter;
import com.liferay.portal.kernel.util.FileUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.ProgressTracker;
import com.liferay.portal.servlet.filters.uploadservletrequest.UploadServletRequestFilter;
import com.liferay.portal.util.PropsUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;

public class LiferayInputStream
extends ServletInputStreamAdapter {
    public static final long THRESHOLD_SIZE = GetterUtil.getLong((String)PropsUtil.get(LiferayInputStream.class.getName() + ".threshold.size"));
    private static final Log _log = LogFactoryUtil.getLog(LiferayInputStream.class);
    private final UnsyncByteArrayOutputStream _cachedBytes = new UnsyncByteArrayOutputStream();
    private final HttpSession _session;
    private final File _tempFile;
    private OutputStream _tempFileOutputStream;
    private long _totalRead;
    private final long _totalSize;

    public LiferayInputStream(HttpServletRequest request) throws IOException {
        super((InputStream)request.getInputStream());
        this._session = request.getSession();
        long totalSize = request.getContentLength();
        if (totalSize < 0L) {
            totalSize = GetterUtil.getLong((String)request.getHeader("Content-Length"), (long)totalSize);
        }
        this._totalSize = totalSize;
        boolean createTempFile = GetterUtil.getBoolean((Object)request.getAttribute(UploadServletRequestFilter.COPY_MULTIPART_STREAM_TO_FILE), (boolean)Boolean.TRUE);
        if (this._totalSize >= THRESHOLD_SIZE && createTempFile) {
            this._tempFile = FileUtil.createTempFile();
        } else {
            this._tempFile = null;
            request.removeAttribute(UploadServletRequestFilter.COPY_MULTIPART_STREAM_TO_FILE);
        }
    }

    public void cleanUp() {
        if (this._tempFile != null) {
            block4: {
                if (this._tempFileOutputStream != null) {
                    try {
                        this._tempFileOutputStream.close();
                    }
                    catch (IOException ioe) {
                        if (!_log.isWarnEnabled()) break block4;
                        _log.warn((Object)ioe, (Throwable)ioe);
                    }
                }
            }
            this._tempFile.delete();
        }
    }

    public void close() throws IOException {
        super.close();
        if (this._tempFileOutputStream != null) {
            this._tempFileOutputStream.close();
        }
    }

    public ServletInputStream getCachedInputStream() throws IOException {
        if (this._totalSize < THRESHOLD_SIZE) {
            return new ServletInputStreamAdapter((InputStream)new UnsyncByteArrayInputStream(this._cachedBytes.unsafeGetByteArray(), 0, this._cachedBytes.size()));
        }
        if (this._tempFile != null) {
            return new ServletInputStreamAdapter((InputStream)new FileInputStream(this._tempFile));
        }
        return this;
    }

    public int read(byte[] b, int off, int len) throws IOException {
        int bytesRead = super.read(b, off, len);
        if (bytesRead > 0) {
            this._totalRead += (long)bytesRead;
        } else {
            return bytesRead;
        }
        int percent = (int)(this._totalRead * 100L / this._totalSize);
        if (_log.isDebugEnabled()) {
            _log.debug((Object)(bytesRead + "/" + this._totalRead + "=" + percent));
        }
        if (this._totalSize > 0L) {
            if (this._totalSize < THRESHOLD_SIZE) {
                this._cachedBytes.write(b, off, bytesRead);
            } else {
                this._writeToTempFile(b, off, bytesRead);
            }
        }
        ProgressTracker progressTracker = (ProgressTracker)this._session.getAttribute(ProgressTracker.PERCENT);
        Integer curPercent = null;
        if (progressTracker != null) {
            curPercent = progressTracker.getPercent();
        }
        if (curPercent == null || percent - curPercent >= 1) {
            if (progressTracker == null) {
                progressTracker = new ProgressTracker("");
                progressTracker.initialize(this._session);
            }
            progressTracker.setPercent(percent);
        }
        return bytesRead;
    }

    private void _writeToTempFile(byte[] b, int off, int bytesRead) throws IOException {
        if (this._tempFile != null && bytesRead > 0) {
            if (this._tempFileOutputStream == null) {
                this._tempFileOutputStream = new FileOutputStream(this._tempFile, true);
            }
            this._tempFileOutputStream.write(b, off, bytesRead);
        }
    }
}

