/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.upgrade.v6_1_0;

import com.liferay.portal.kernel.upgrade.UpgradeProcess;
import com.liferay.portal.kernel.util.LoggingTimer;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.util.PortalInstances;
import com.liferay.portal.util.PropsValues;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Timestamp;

public class UpgradeSubscription
extends UpgradeProcess {
    protected void addSubscription(long subscriptionId, long companyId, long userId, String userName, Timestamp createDate, Timestamp modifiedDate, long classNameId, long classPK, String frequency) throws Exception {
        StringBundler sb = new StringBundler(4);
        sb.append("insert into Subscription (subscriptionId, companyId, ");
        sb.append("userId, userName, createDate, modifiedDate, ");
        sb.append("classNameId, classPK, frequency) values (?, ?, ?, ?, ");
        sb.append("?, ?, ?, ?, ?)");
        try (PreparedStatement ps = this.connection.prepareStatement(sb.toString());){
            ps.setLong(1, subscriptionId);
            ps.setLong(2, companyId);
            ps.setLong(3, userId);
            ps.setString(4, userName);
            ps.setTimestamp(5, createDate);
            ps.setTimestamp(6, modifiedDate);
            ps.setLong(7, classNameId);
            ps.setLong(8, classPK);
            ps.setString(9, frequency);
            ps.executeUpdate();
        }
    }

    protected void doUpgrade() throws Exception {
        long[] companyIds;
        if (!PropsValues.DISCUSSION_SUBSCRIBE_BY_DEFAULT) {
            return;
        }
        for (long companyId : companyIds = PortalInstances.getCompanyIdsBySQL()) {
            this.updateMBMessages(companyId);
        }
    }

    /*
     * Exception decompiling
     */
    protected boolean hasSubscription(long companyId, long userId, long classNameId, long classPK) throws Exception {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    protected void updateMBMessages(long companyId) throws Exception {
        try (LoggingTimer loggingTimer = new LoggingTimer(String.valueOf(companyId));){
            StringBundler sb = new StringBundler(8);
            sb.append("select userId, MIN(userName) as userName, ");
            sb.append("classNameId, classPK, MIN(createDate) as createDate, ");
            sb.append("MIN(modifiedDate) as modifiedDate from MBMessage ");
            sb.append("where (companyId = ");
            sb.append(companyId);
            sb.append(") and ");
            sb.append("(classNameId != 0) and (parentMessageId != 0) ");
            sb.append("group by userId, classNameId, classPK");
            try (PreparedStatement ps = this.connection.prepareStatement(sb.toString());
                 ResultSet rs = ps.executeQuery();){
                while (rs.next()) {
                    long classPK;
                    long userId = rs.getLong("userId");
                    String userName = rs.getString("userName");
                    Timestamp createDate = rs.getTimestamp("createDate");
                    Timestamp modifiedDate = rs.getTimestamp("modifiedDate");
                    long classNameId = rs.getLong("classNameId");
                    if (this.hasSubscription(companyId, userId, classNameId, classPK = rs.getLong("classPK"))) continue;
                    long subscriptionId = this.increment();
                    String frequency = "instant";
                    this.addSubscription(subscriptionId, companyId, userId, userName, createDate, modifiedDate, classNameId, classPK, frequency);
                }
            }
        }
    }
}

