/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.service.impl;

import com.liferay.portal.kernel.exception.NoSuchPasswordPolicyRelException;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.PasswordPolicyRel;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.service.base.PasswordPolicyRelLocalServiceBaseImpl;
import java.util.List;

public class PasswordPolicyRelLocalServiceImpl
extends PasswordPolicyRelLocalServiceBaseImpl {
    public PasswordPolicyRel addPasswordPolicyRel(long passwordPolicyId, String className, long classPK) {
        long classNameId = this.classNameLocalService.getClassNameId(className);
        PasswordPolicyRel passwordPolicyRel = this.passwordPolicyRelPersistence.fetchByC_C(classNameId, classPK);
        if (passwordPolicyRel != null) {
            if (passwordPolicyRel.getPasswordPolicyId() == passwordPolicyId) {
                return null;
            }
            this.passwordPolicyRelPersistence.remove((BaseModel)passwordPolicyRel);
        }
        long passwordPolicyRelId = this.counterLocalService.increment();
        passwordPolicyRel = this.passwordPolicyRelPersistence.create(passwordPolicyRelId);
        passwordPolicyRel.setPasswordPolicyId(passwordPolicyId);
        passwordPolicyRel.setClassNameId(classNameId);
        passwordPolicyRel.setClassPK(classPK);
        this.passwordPolicyRelPersistence.update((BaseModel)passwordPolicyRel);
        return passwordPolicyRel;
    }

    public void addPasswordPolicyRels(long passwordPolicyId, String className, long[] classPKs) {
        for (int i = 0; i < classPKs.length; ++i) {
            this.addPasswordPolicyRel(passwordPolicyId, className, classPKs[i]);
        }
    }

    public void deletePasswordPolicyRel(long passwordPolicyId, String className, long classPK) {
        long classNameId = this.classNameLocalService.getClassNameId(className);
        PasswordPolicyRel passwordPolicyRel = this.passwordPolicyRelPersistence.fetchByC_C(classNameId, classPK);
        if (passwordPolicyRel != null && passwordPolicyRel.getPasswordPolicyId() == passwordPolicyId) {
            this.passwordPolicyRelPersistence.remove((BaseModel)passwordPolicyRel);
        }
    }

    public void deletePasswordPolicyRel(String className, long classPK) {
        try {
            long classNameId = this.classNameLocalService.getClassNameId(className);
            PasswordPolicyRel passwordPolicyRel = this.passwordPolicyRelPersistence.findByC_C(classNameId, classPK);
            this.deletePasswordPolicyRel(passwordPolicyRel);
        }
        catch (NoSuchPasswordPolicyRelException nsppre) {
            // empty catch block
        }
    }

    public void deletePasswordPolicyRels(long passwordPolicyId) {
        List passwordPolicyRels = this.passwordPolicyRelPersistence.findByPasswordPolicyId(passwordPolicyId);
        for (PasswordPolicyRel passwordPolicyRel : passwordPolicyRels) {
            this.deletePasswordPolicyRel(passwordPolicyRel);
        }
    }

    public void deletePasswordPolicyRels(long passwordPolicyId, String className, long[] classPKs) {
        for (int i = 0; i < classPKs.length; ++i) {
            this.deletePasswordPolicyRel(passwordPolicyId, className, classPKs[i]);
        }
    }

    public PasswordPolicyRel fetchPasswordPolicyRel(String className, long classPK) {
        long classNameId = this.classNameLocalService.getClassNameId(className);
        return this.passwordPolicyRelPersistence.fetchByC_C(classNameId, classPK);
    }

    public PasswordPolicyRel getPasswordPolicyRel(long passwordPolicyId, String className, long classPK) throws PortalException {
        long classNameId = this.classNameLocalService.getClassNameId(className);
        PasswordPolicyRel passwordPolicyRel = this.passwordPolicyRelPersistence.fetchByC_C(classNameId, classPK);
        if (passwordPolicyRel != null && passwordPolicyRel.getPasswordPolicyId() == passwordPolicyId) {
            return passwordPolicyRel;
        }
        StringBundler sb = new StringBundler(8);
        sb.append("No PasswordPolicyRel exists with the key {");
        sb.append("passwordPolicyId=");
        sb.append(passwordPolicyId);
        sb.append(", classNameId=");
        sb.append(classNameId);
        sb.append(", classPK=");
        sb.append(classPK);
        sb.append("}");
        throw new NoSuchPasswordPolicyRelException(sb.toString());
    }

    public PasswordPolicyRel getPasswordPolicyRel(String className, long classPK) throws PortalException {
        long classNameId = this.classNameLocalService.getClassNameId(className);
        return this.passwordPolicyRelPersistence.findByC_C(classNameId, classPK);
    }

    public boolean hasPasswordPolicyRel(long passwordPolicyId, String className, long classPK) {
        long classNameId = this.classNameLocalService.getClassNameId(className);
        PasswordPolicyRel passwordPolicyRel = this.passwordPolicyRelPersistence.fetchByC_C(classNameId, classPK);
        return passwordPolicyRel != null && passwordPolicyRel.getPasswordPolicyId() == passwordPolicyId;
    }
}

