/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.service.impl;

import com.liferay.exportimport.kernel.staging.MergeLayoutPrototypesThreadLocal;
import com.liferay.portal.kernel.dao.orm.DynamicQuery;
import com.liferay.portal.kernel.dao.orm.DynamicQueryFactoryUtil;
import com.liferay.portal.kernel.dao.orm.Property;
import com.liferay.portal.kernel.dao.orm.PropertyFactoryUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.Layout;
import com.liferay.portal.kernel.model.LayoutSet;
import com.liferay.portal.kernel.model.UserGroup;
import com.liferay.portal.kernel.model.impl.VirtualLayout;
import com.liferay.portal.kernel.service.GroupLocalServiceUtil;
import com.liferay.portal.kernel.service.LayoutLocalServiceUtil;
import com.liferay.portal.kernel.service.LayoutSetLocalServiceUtil;
import com.liferay.portal.kernel.service.UserGroupLocalServiceUtil;
import com.liferay.portal.kernel.util.AutoResetThreadLocal;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.workflow.WorkflowThreadLocal;
import com.liferay.portal.util.PropsValues;
import com.liferay.sites.kernel.util.SitesUtil;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.springframework.core.annotation.Order;

@Order(value=2)
public class LayoutLocalServiceVirtualLayoutsAdvice
implements MethodInterceptor {
    private static final Class<?>[] _TYPES_L = new Class[]{Long.TYPE};
    private static final Class<?>[] _TYPES_L_B_L = new Class[]{Long.TYPE, Boolean.TYPE, Long.TYPE};
    private static final Class<?>[] _TYPES_L_B_L_B_I_I = new Class[]{Long.TYPE, Boolean.TYPE, Long.TYPE, Boolean.TYPE, Integer.TYPE, Integer.TYPE};
    private static final Log _log = LogFactoryUtil.getLog(LayoutLocalServiceVirtualLayoutsAdvice.class);
    private static final ThreadLocal<Long> _virtualLayoutTargetGroupId = new AutoResetThreadLocal(LayoutLocalServiceVirtualLayoutsAdvice.class + "._virtualLayoutTargetGroupId", (Object)0L);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Object invoke(MethodInvocation methodInvocation) throws Throwable {
        if (MergeLayoutPrototypesThreadLocal.isInProgress()) {
            return methodInvocation.proceed();
        }
        Method method = methodInvocation.getMethod();
        String methodName = method.getName();
        Object[] parameterTypes = method.getParameterTypes();
        Object[] arguments = methodInvocation.getArguments();
        boolean workflowEnabled = WorkflowThreadLocal.isEnabled();
        if (methodName.equals("getLayout") && (Arrays.equals(parameterTypes, _TYPES_L) || Arrays.equals(parameterTypes, _TYPES_L_B_L))) {
            Layout layout = (Layout)methodInvocation.proceed();
            Group group = layout.getGroup();
            if (this.isMergeComplete(method, arguments, group)) {
                return layout;
            }
            if (Validator.isNull((String)layout.getLayoutPrototypeUuid()) && Validator.isNull((String)layout.getSourcePrototypeLayoutUuid())) {
                return layout;
            }
            LayoutSet layoutSet = layout.getLayoutSet();
            try {
                WorkflowThreadLocal.setEnabled((boolean)false);
                SitesUtil.mergeLayoutPrototypeLayout((Group)group, (Layout)layout);
                if (!Validator.isNotNull((String)layout.getSourcePrototypeLayoutUuid())) return methodInvocation.proceed();
                SitesUtil.mergeLayoutSetPrototypeLayouts((Group)group, (LayoutSet)layoutSet);
                return methodInvocation.proceed();
            }
            finally {
                MergeLayoutPrototypesThreadLocal.setMergeComplete((Method)method, (Object[])arguments);
                WorkflowThreadLocal.setEnabled((boolean)workflowEnabled);
            }
        } else {
            if (!methodName.equals("getLayouts") || !Arrays.equals(parameterTypes, _TYPES_L_B_L) && !Arrays.equals(parameterTypes, _TYPES_L_B_L_B_I_I)) return methodInvocation.proceed();
            long groupId = (Long)arguments[0];
            Group group = GroupLocalServiceUtil.getGroup((long)groupId);
            if (this.isMergeComplete(method, arguments, group)) {
                return methodInvocation.proceed();
            }
            boolean privateLayout = (Boolean)arguments[1];
            long parentLayoutId = (Long)arguments[2];
            try {
                long targetGroupId;
                LayoutSet layoutSet = LayoutSetLocalServiceUtil.getLayoutSet((long)groupId, (boolean)privateLayout);
                this.mergeLayoutSetPrototypeLayouts(method, arguments, group, layoutSet, privateLayout, workflowEnabled);
                List layouts = (List)methodInvocation.proceed();
                if (PropsValues.USER_GROUPS_COPY_LAYOUTS_TO_USER_PERSONAL_SITE) {
                    return layouts;
                }
                if (group.isUser()) {
                    _virtualLayoutTargetGroupId.set(group.getGroupId());
                    if (parentLayoutId != 0L) return this.addChildUserGroupLayouts(group, layouts);
                    return this.addUserGroupLayouts(group, layoutSet, layouts, parentLayoutId);
                }
                if (!group.isUserGroup() || parentLayoutId == 0L || (targetGroupId = _virtualLayoutTargetGroupId.get().longValue()) == 0L) return layouts;
                Group targetGroup = GroupLocalServiceUtil.getGroup((long)targetGroupId);
                return this.addChildUserGroupLayouts(targetGroup, layouts);
            }
            catch (Exception e) {
                _log.error((Object)e, (Throwable)e);
                throw e;
            }
        }
    }

    protected List<Layout> addChildUserGroupLayouts(Group group, List<Layout> layouts) throws Exception {
        layouts = ListUtil.copy(layouts);
        ArrayList<Layout> childLayouts = new ArrayList<Layout>();
        Iterator i$ = layouts.iterator();
        while (i$.hasNext()) {
            Layout layout;
            Layout childLayout = layout = (Layout)i$.next();
            Group layoutGroup = layout.getGroup();
            if (layoutGroup.isUserGroup()) {
                childLayout = new VirtualLayout(layout, group);
            }
            childLayouts.add(childLayout);
        }
        return childLayouts;
    }

    protected List<Layout> addUserGroupLayouts(Group group, LayoutSet layoutSet, List<Layout> layouts, long parentLayoutId) throws Exception {
        layouts = ListUtil.copy(layouts);
        List userUserGroups = UserGroupLocalServiceUtil.getUserUserGroups((long)group.getClassPK());
        for (UserGroup userGroup : userUserGroups) {
            Group userGroupGroup = userGroup.getGroup();
            List userGroupLayouts = LayoutLocalServiceUtil.getLayouts((long)userGroupGroup.getGroupId(), (boolean)layoutSet.isPrivateLayout(), (long)parentLayoutId);
            for (Layout userGroupLayout : userGroupLayouts) {
                VirtualLayout virtualLayout = new VirtualLayout(userGroupLayout, group);
                layouts.add(virtualLayout);
            }
        }
        return layouts;
    }

    protected List<Layout> getPrototypeLinkedLayouts(long groupId, boolean privateLayout) {
        Class<?> clazz = this.getClass();
        DynamicQuery dynamicQuery = DynamicQueryFactoryUtil.forClass(Layout.class, (ClassLoader)clazz.getClassLoader());
        Property groupIdProperty = PropertyFactoryUtil.forName((String)"groupId");
        dynamicQuery.add(groupIdProperty.eq((Object)groupId));
        Property layoutPrototypeUuidProperty = PropertyFactoryUtil.forName((String)"layoutPrototypeUuid");
        dynamicQuery.add(layoutPrototypeUuidProperty.isNotNull());
        Property privateLayoutProperty = PropertyFactoryUtil.forName((String)"privateLayout");
        dynamicQuery.add(privateLayoutProperty.eq((Object)privateLayout));
        Property sourcePrototypeLayoutUuidProperty = PropertyFactoryUtil.forName((String)"sourcePrototypeLayoutUuid");
        dynamicQuery.add(sourcePrototypeLayoutUuidProperty.isNotNull());
        return LayoutLocalServiceUtil.dynamicQuery((DynamicQuery)dynamicQuery);
    }

    protected boolean isMergeComplete(Method method, Object[] arguments, Group group) {
        return MergeLayoutPrototypesThreadLocal.isMergeComplete((Method)method, (Object[])arguments) && (!group.isUser() || PropsValues.USER_GROUPS_COPY_LAYOUTS_TO_USER_PERSONAL_SITE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void mergeLayoutSetPrototypeLayouts(Method method, Object[] arguments, Group group, LayoutSet layoutSet, boolean privateLayout, boolean workflowEnabled) {
        try {
            if (!SitesUtil.isLayoutSetMergeable((Group)group, (LayoutSet)layoutSet)) {
                return;
            }
            WorkflowThreadLocal.setEnabled((boolean)false);
            SitesUtil.mergeLayoutSetPrototypeLayouts((Group)group, (LayoutSet)layoutSet);
        }
        catch (Exception e) {
            if (_log.isWarnEnabled()) {
                _log.warn((Object)"Unable to merge layouts for site template", (Throwable)e);
            }
        }
        finally {
            MergeLayoutPrototypesThreadLocal.setMergeComplete((Method)method, (Object[])arguments);
            WorkflowThreadLocal.setEnabled((boolean)workflowEnabled);
        }
    }
}

