/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.repository.liferayrepository;

import com.liferay.document.library.kernel.model.DLFileEntry;
import com.liferay.document.library.kernel.model.DLFileShortcut;
import com.liferay.document.library.kernel.model.DLFileVersion;
import com.liferay.document.library.kernel.model.DLFolder;
import com.liferay.document.library.kernel.service.DLAppHelperLocalService;
import com.liferay.document.library.kernel.service.DLFileEntryLocalService;
import com.liferay.document.library.kernel.service.DLFileEntryService;
import com.liferay.document.library.kernel.service.DLFileEntryTypeLocalService;
import com.liferay.document.library.kernel.service.DLFileShortcutLocalService;
import com.liferay.document.library.kernel.service.DLFileShortcutService;
import com.liferay.document.library.kernel.service.DLFileVersionLocalService;
import com.liferay.document.library.kernel.service.DLFileVersionService;
import com.liferay.document.library.kernel.service.DLFolderLocalService;
import com.liferay.document.library.kernel.service.DLFolderService;
import com.liferay.dynamic.data.mapping.kernel.DDMFormValues;
import com.liferay.portal.kernel.dao.orm.QueryDefinition;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.repository.LocalRepository;
import com.liferay.portal.kernel.repository.model.FileEntry;
import com.liferay.portal.kernel.repository.model.FileShortcut;
import com.liferay.portal.kernel.repository.model.FileVersion;
import com.liferay.portal.kernel.repository.model.Folder;
import com.liferay.portal.kernel.repository.model.RepositoryEntry;
import com.liferay.portal.kernel.service.RepositoryLocalService;
import com.liferay.portal.kernel.service.RepositoryService;
import com.liferay.portal.kernel.service.ResourceLocalService;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.SortedArrayList;
import com.liferay.portal.kernel.util.UnicodeProperties;
import com.liferay.portal.repository.liferayrepository.LiferayRepositoryBase;
import com.liferay.portal.repository.liferayrepository.model.LiferayFileEntry;
import com.liferay.portal.repository.liferayrepository.model.LiferayFileShortcut;
import com.liferay.portal.repository.liferayrepository.model.LiferayFileVersion;
import com.liferay.portal.repository.liferayrepository.model.LiferayFolder;
import com.liferay.portlet.documentlibrary.util.RepositoryModelUtil;
import com.liferay.portlet.documentlibrary.util.comparator.DLFileEntryOrderByComparator;
import com.liferay.portlet.documentlibrary.util.comparator.DLFolderOrderByComparator;
import java.io.File;
import java.io.InputStream;
import java.util.HashMap;
import java.util.List;

public class LiferayLocalRepository
extends LiferayRepositoryBase
implements LocalRepository {
    public LiferayLocalRepository(RepositoryLocalService repositoryLocalService, RepositoryService repositoryService, DLAppHelperLocalService dlAppHelperLocalService, DLFileEntryLocalService dlFileEntryLocalService, DLFileEntryService dlFileEntryService, DLFileEntryTypeLocalService dlFileEntryTypeLocalService, DLFileShortcutLocalService dlFileShortcutLocalService, DLFileShortcutService dlFileShortcutService, DLFileVersionLocalService dlFileVersionLocalService, DLFileVersionService dlFileVersionService, DLFolderLocalService dlFolderLocalService, DLFolderService dlFolderService, ResourceLocalService resourceLocalService, long groupId, long repositoryId, long dlFolderId) {
        super(repositoryLocalService, repositoryService, dlAppHelperLocalService, dlFileEntryLocalService, dlFileEntryService, dlFileEntryTypeLocalService, dlFileShortcutLocalService, dlFileShortcutService, dlFileVersionLocalService, dlFileVersionService, dlFolderLocalService, dlFolderService, resourceLocalService, groupId, repositoryId, dlFolderId);
    }

    public FileEntry addFileEntry(long userId, long folderId, String sourceFileName, String mimeType, String title, String description, String changeLog, File file, ServiceContext serviceContext) throws PortalException {
        long fileEntryTypeId = ParamUtil.getLong((ServiceContext)serviceContext, (String)"fileEntryTypeId", (long)this.getDefaultFileEntryTypeId(serviceContext, folderId));
        HashMap<String, DDMFormValues> ddmFormValuesMap = this.getDDMFormValuesMap(serviceContext, fileEntryTypeId);
        long size = 0L;
        if (file != null) {
            size = file.length();
        }
        DLFileEntry dlFileEntry = this.dlFileEntryLocalService.addFileEntry(userId, this.getGroupId(), this.getRepositoryId(), this.toFolderId(folderId), sourceFileName, mimeType, title, description, changeLog, fileEntryTypeId, ddmFormValuesMap, file, null, size, serviceContext);
        return new LiferayFileEntry(dlFileEntry);
    }

    public FileEntry addFileEntry(long userId, long folderId, String sourceFileName, String mimeType, String title, String description, String changeLog, InputStream is, long size, ServiceContext serviceContext) throws PortalException {
        long fileEntryTypeId = ParamUtil.getLong((ServiceContext)serviceContext, (String)"fileEntryTypeId", (long)this.getDefaultFileEntryTypeId(serviceContext, folderId));
        HashMap<String, DDMFormValues> ddmFormValuesMap = this.getDDMFormValuesMap(serviceContext, fileEntryTypeId);
        DLFileEntry dlFileEntry = this.dlFileEntryLocalService.addFileEntry(userId, this.getGroupId(), this.getRepositoryId(), this.toFolderId(folderId), sourceFileName, mimeType, title, description, changeLog, fileEntryTypeId, ddmFormValuesMap, null, is, size, serviceContext);
        return new LiferayFileEntry(dlFileEntry);
    }

    public FileShortcut addFileShortcut(long userId, long folderId, long toFileEntryId, ServiceContext serviceContext) throws PortalException {
        DLFileShortcut dlFileShortcut = this.dlFileShortcutLocalService.addFileShortcut(userId, this.getGroupId(), this.getRepositoryId(), this.toFolderId(folderId), toFileEntryId, serviceContext);
        return new LiferayFileShortcut(dlFileShortcut);
    }

    public Folder addFolder(long userId, long parentFolderId, String name, String description, ServiceContext serviceContext) throws PortalException {
        boolean mountPoint = ParamUtil.getBoolean((ServiceContext)serviceContext, (String)"mountPoint");
        DLFolder dlFolder = this.dlFolderLocalService.addFolder(userId, this.getGroupId(), this.getRepositoryId(), mountPoint, this.toFolderId(parentFolderId), name, description, false, serviceContext);
        return new LiferayFolder(dlFolder);
    }

    public void checkInFileEntry(long userId, long fileEntryId, boolean majorVersion, String changeLog, ServiceContext serviceContext) throws PortalException {
        this.dlFileEntryLocalService.checkInFileEntry(userId, fileEntryId, majorVersion, changeLog, serviceContext);
    }

    public void checkInFileEntry(long userId, long fileEntryId, String lockUuid, ServiceContext serviceContext) throws PortalException {
        this.dlFileEntryLocalService.checkInFileEntry(userId, fileEntryId, lockUuid, serviceContext);
    }

    public FileEntry copyFileEntry(long userId, long groupId, long fileEntryId, long destFolderId, ServiceContext serviceContext) throws PortalException {
        DLFileEntry dlFileEntry = this.dlFileEntryLocalService.copyFileEntry(userId, groupId, this.getRepositoryId(), fileEntryId, this.toFolderId(destFolderId), serviceContext);
        return new LiferayFileEntry(dlFileEntry);
    }

    public void deleteAll() throws PortalException {
        this.dlFolderLocalService.deleteAllByRepository(this.getRepositoryId());
    }

    public void deleteFileEntry(long fileEntryId) throws PortalException {
        this.dlFileEntryLocalService.deleteFileEntry(fileEntryId);
    }

    public void deleteFileShortcut(long fileShortcutId) throws PortalException {
        this.dlFileShortcutLocalService.deleteFileShortcut(fileShortcutId);
    }

    public void deleteFileShortcuts(long toFileEntryId) throws PortalException {
        this.dlFileShortcutLocalService.deleteFileShortcuts(toFileEntryId);
    }

    public void deleteFolder(long folderId) throws PortalException {
        DLFolder dlFolder = this.dlFolderLocalService.fetchFolder(folderId);
        if (dlFolder != null) {
            this.dlFolderLocalService.deleteFolder(folderId);
        }
    }

    public List<FileEntry> getFileEntries(long folderId, int status, int start, int end, OrderByComparator<FileEntry> obc) {
        List dlFileEntries = this.dlFileEntryLocalService.getFileEntries(this.getGroupId(), this.toFolderId(folderId), status, start, end, DLFileEntryOrderByComparator.getOrderByComparator(obc));
        return RepositoryModelUtil.toFileEntries(dlFileEntries);
    }

    public List<FileEntry> getFileEntries(long folderId, int start, int end, OrderByComparator<FileEntry> obc) {
        List dlFileEntries = this.dlFileEntryLocalService.getFileEntries(this.getGroupId(), this.toFolderId(folderId), start, end, DLFileEntryOrderByComparator.getOrderByComparator(obc));
        return RepositoryModelUtil.toFileEntries(dlFileEntries);
    }

    public List<RepositoryEntry> getFileEntriesAndFileShortcuts(long folderId, int status, int start, int end) {
        QueryDefinition queryDefinition = new QueryDefinition(status, start, end, null);
        List dlFileEntriesAndFileShortcuts = this.dlFolderLocalService.getFileEntriesAndFileShortcuts(this.getGroupId(), this.toFolderId(folderId), queryDefinition);
        return RepositoryModelUtil.toRepositoryEntries(dlFileEntriesAndFileShortcuts);
    }

    public int getFileEntriesAndFileShortcutsCount(long folderId, int status) {
        QueryDefinition queryDefinition = new QueryDefinition(status);
        return this.dlFolderLocalService.getFileEntriesAndFileShortcutsCount(this.getGroupId(), this.toFolderId(folderId), queryDefinition);
    }

    public int getFileEntriesCount(long folderId) {
        return this.dlFileEntryLocalService.getFileEntriesCount(this.getGroupId(), this.toFolderId(folderId));
    }

    public int getFileEntriesCount(long folderId, int status) {
        return this.dlFileEntryLocalService.getFileEntriesCount(this.getGroupId(), this.toFolderId(folderId), status);
    }

    public FileEntry getFileEntry(long fileEntryId) throws PortalException {
        DLFileEntry dlFileEntry = this.dlFileEntryLocalService.getFileEntry(fileEntryId);
        return new LiferayFileEntry(dlFileEntry);
    }

    public FileEntry getFileEntry(long folderId, String title) throws PortalException {
        DLFileEntry dlFileEntry = this.dlFileEntryLocalService.getFileEntry(this.getGroupId(), this.toFolderId(folderId), title);
        return new LiferayFileEntry(dlFileEntry);
    }

    public FileEntry getFileEntryByUuid(String uuid) throws PortalException {
        DLFileEntry dlFileEntry = this.dlFileEntryLocalService.getFileEntryByUuidAndGroupId(uuid, this.getGroupId());
        return new LiferayFileEntry(dlFileEntry);
    }

    public FileShortcut getFileShortcut(long fileShortcutId) throws PortalException {
        DLFileShortcut dlFileShortcut = this.dlFileShortcutLocalService.getDLFileShortcut(fileShortcutId);
        return new LiferayFileShortcut(dlFileShortcut);
    }

    public FileVersion getFileVersion(long fileVersionId) throws PortalException {
        DLFileVersion dlFileVersion = this.dlFileVersionLocalService.getFileVersion(fileVersionId);
        return new LiferayFileVersion(dlFileVersion);
    }

    public Folder getFolder(long folderId) throws PortalException {
        DLFolder dlFolder = this.dlFolderLocalService.getFolder(this.toFolderId(folderId));
        return new LiferayFolder(dlFolder);
    }

    public Folder getFolder(long parentFolderId, String name) throws PortalException {
        DLFolder dlFolder = this.dlFolderLocalService.getFolder(this.getGroupId(), this.toFolderId(parentFolderId), name);
        return new LiferayFolder(dlFolder);
    }

    public List<Folder> getFolders(long parentFolderId, boolean includeMountfolders, int start, int end, OrderByComparator<Folder> obc) {
        return this.getFolders(parentFolderId, 0, includeMountfolders, start, end, obc);
    }

    public List<Folder> getFolders(long parentFolderId, int status, boolean includeMountfolders, int start, int end, OrderByComparator<Folder> obc) {
        List dlFolders = this.dlFolderLocalService.getFolders(this.getGroupId(), this.toFolderId(parentFolderId), status, includeMountfolders, start, end, DLFolderOrderByComparator.getOrderByComparator(obc));
        return RepositoryModelUtil.toFolders(dlFolders);
    }

    public List<RepositoryEntry> getFoldersAndFileEntriesAndFileShortcuts(long folderId, int status, boolean includeMountFolders, int start, int end, OrderByComparator<?> obc) {
        QueryDefinition queryDefinition = new QueryDefinition(status, start, end, obc);
        List dlFoldersAndDLFileEntriesAndDLFileShortcuts = this.dlFolderLocalService.getFoldersAndFileEntriesAndFileShortcuts(this.getGroupId(), this.toFolderId(folderId), null, includeMountFolders, queryDefinition);
        return RepositoryModelUtil.toRepositoryEntries(dlFoldersAndDLFileEntriesAndDLFileShortcuts);
    }

    public int getFoldersAndFileEntriesAndFileShortcutsCount(long folderId, int status, boolean includeMountFolders) {
        QueryDefinition queryDefinition = new QueryDefinition(status);
        return this.dlFolderLocalService.getFoldersAndFileEntriesAndFileShortcutsCount(this.getGroupId(), this.toFolderId(folderId), null, includeMountFolders, queryDefinition);
    }

    public int getFoldersCount(long parentFolderId, boolean includeMountfolders) {
        return this.getFoldersCount(parentFolderId, 0, includeMountfolders);
    }

    public int getFoldersCount(long parentFolderId, int status, boolean includeMountfolders) {
        return this.dlFolderLocalService.getFoldersCount(this.getGroupId(), this.toFolderId(parentFolderId), status, includeMountfolders);
    }

    public List<FileEntry> getRepositoryFileEntries(long userId, long rootFolderId, int start, int end, OrderByComparator<FileEntry> obc) {
        List dlFileEntries = this.dlFileEntryLocalService.getGroupFileEntries(this.getGroupId(), 0L, this.getRepositoryId(), this.toFolderId(rootFolderId), start, end, DLFileEntryOrderByComparator.getOrderByComparator(obc));
        return RepositoryModelUtil.toFileEntries(dlFileEntries);
    }

    public FileEntry moveFileEntry(long userId, long fileEntryId, long newFolderId, ServiceContext serviceContext) throws PortalException {
        DLFileEntry dlFileEntry = this.dlFileEntryLocalService.moveFileEntry(userId, fileEntryId, this.toFolderId(newFolderId), serviceContext);
        return new LiferayFileEntry(dlFileEntry);
    }

    public Folder moveFolder(long userId, long folderId, long parentFolderId, ServiceContext serviceContext) throws PortalException {
        DLFolder dlFolder = this.dlFolderLocalService.moveFolder(userId, this.toFolderId(folderId), this.toFolderId(parentFolderId), serviceContext);
        return new LiferayFolder(dlFolder);
    }

    public void revertFileEntry(long userId, long fileEntryId, String version, ServiceContext serviceContext) throws PortalException {
        this.dlFileEntryLocalService.revertFileEntry(userId, fileEntryId, version, serviceContext);
    }

    @Deprecated
    public void updateAsset(long userId, FileEntry fileEntry, FileVersion fileVersion, long[] assetCategoryIds, String[] assetTagNames, long[] assetLinkEntryIds) throws PortalException {
        this.dlAppHelperLocalService.updateAsset(userId, fileEntry, fileVersion, assetCategoryIds, assetTagNames, assetLinkEntryIds);
    }

    public FileEntry updateFileEntry(long userId, long fileEntryId, String sourceFileName, String mimeType, String title, String description, String changeLog, boolean majorVersion, File file, ServiceContext serviceContext) throws PortalException {
        long fileEntryTypeId = ParamUtil.getLong((ServiceContext)serviceContext, (String)"fileEntryTypeId", (long)-1L);
        HashMap<String, DDMFormValues> ddmFormValuesMap = this.getDDMFormValuesMap(serviceContext, fileEntryTypeId);
        long size = 0L;
        if (file != null) {
            size = file.length();
        }
        DLFileEntry dlFileEntry = this.dlFileEntryLocalService.updateFileEntry(userId, fileEntryId, sourceFileName, mimeType, title, description, changeLog, majorVersion, fileEntryTypeId, ddmFormValuesMap, file, null, size, serviceContext);
        return new LiferayFileEntry(dlFileEntry);
    }

    public FileEntry updateFileEntry(long userId, long fileEntryId, String sourceFileName, String mimeType, String title, String description, String changeLog, boolean majorVersion, InputStream is, long size, ServiceContext serviceContext) throws PortalException {
        long fileEntryTypeId = ParamUtil.getLong((ServiceContext)serviceContext, (String)"fileEntryTypeId", (long)-1L);
        HashMap<String, DDMFormValues> ddmFormValuesMap = this.getDDMFormValuesMap(serviceContext, fileEntryTypeId);
        DLFileEntry dlFileEntry = this.dlFileEntryLocalService.updateFileEntry(userId, fileEntryId, sourceFileName, mimeType, title, description, changeLog, majorVersion, fileEntryTypeId, ddmFormValuesMap, null, is, size, serviceContext);
        return new LiferayFileEntry(dlFileEntry);
    }

    public FileShortcut updateFileShortcut(long userId, long fileShortcutId, long folderId, long toFileEntryId, ServiceContext serviceContext) throws PortalException {
        DLFileShortcut dlFileShortcut = this.dlFileShortcutLocalService.updateFileShortcut(userId, fileShortcutId, this.getRepositoryId(), this.toFolderId(folderId), toFileEntryId, serviceContext);
        return new LiferayFileShortcut(dlFileShortcut);
    }

    public void updateFileShortcuts(long oldToFileEntryId, long newToFileEntryId) {
        this.dlFileShortcutLocalService.updateFileShortcuts(oldToFileEntryId, newToFileEntryId);
    }

    public Folder updateFolder(long folderId, long parentFolderId, String name, String description, ServiceContext serviceContext) throws PortalException {
        long defaultFileEntryTypeId = ParamUtil.getLong((ServiceContext)serviceContext, (String)"defaultFileEntryTypeId");
        SortedArrayList<Long> fileEntryTypeIds = this.getLongList(serviceContext, "dlFileEntryTypesSearchContainerPrimaryKeys");
        int restrictionType = ParamUtil.getInteger((ServiceContext)serviceContext, (String)"restrictionType");
        DLFolder dlFolder = this.dlFolderLocalService.updateFolder(this.toFolderId(folderId), this.toFolderId(parentFolderId), name, description, defaultFileEntryTypeId, fileEntryTypeIds, restrictionType, serviceContext);
        return new LiferayFolder(dlFolder);
    }

    public UnicodeProperties updateRepository(UnicodeProperties typeSettingsProperties) {
        return typeSettingsProperties;
    }
}

