/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.repository.capabilities;

import com.liferay.document.library.kernel.util.DLProcessorRegistryUtil;
import com.liferay.portal.kernel.repository.LocalRepository;
import com.liferay.portal.kernel.repository.Repository;
import com.liferay.portal.kernel.repository.capabilities.ProcessorCapability;
import com.liferay.portal.kernel.repository.event.RepositoryEventAware;
import com.liferay.portal.kernel.repository.event.RepositoryEventListener;
import com.liferay.portal.kernel.repository.event.RepositoryEventType;
import com.liferay.portal.kernel.repository.model.FileEntry;
import com.liferay.portal.kernel.repository.model.FileVersion;
import com.liferay.portal.kernel.repository.registry.RepositoryEventRegistry;
import com.liferay.portal.kernel.transaction.TransactionCommitCallbackUtil;
import com.liferay.portal.repository.liferayrepository.LiferayProcessorLocalRepositoryWrapper;
import com.liferay.portal.repository.liferayrepository.LiferayProcessorRepositoryWrapper;
import com.liferay.portal.repository.util.RepositoryWrapperAware;
import java.util.concurrent.Callable;

public class LiferayProcessorCapability
implements ProcessorCapability,
RepositoryEventAware,
RepositoryWrapperAware {
    public void cleanUp(FileEntry fileEntry) {
        DLProcessorRegistryUtil.cleanUp((FileEntry)fileEntry);
    }

    public void cleanUp(FileVersion fileVersion) {
        DLProcessorRegistryUtil.cleanUp((FileVersion)fileVersion);
    }

    public void copy(FileEntry fileEntry, FileVersion fileVersion) {
        this.registerDLProcessorCallback(fileEntry, fileVersion);
    }

    public void generateNew(FileEntry fileEntry) {
        this.registerDLProcessorCallback(fileEntry, null);
    }

    public void registerRepositoryEventListeners(RepositoryEventRegistry repositoryEventRegistry) {
        repositoryEventRegistry.registerRepositoryEventListener(RepositoryEventType.Delete.class, FileEntry.class, (RepositoryEventListener)new RepositoryEventListener<RepositoryEventType.Delete, FileEntry>(){

            public void execute(FileEntry fileEntry) {
                LiferayProcessorCapability.this.cleanUp(fileEntry);
            }
        });
    }

    @Override
    public LocalRepository wrapLocalRepository(LocalRepository localRepository) {
        return new LiferayProcessorLocalRepositoryWrapper(localRepository, this);
    }

    @Override
    public Repository wrapRepository(Repository repository) {
        return new LiferayProcessorRepositoryWrapper(repository, this);
    }

    protected void registerDLProcessorCallback(final FileEntry fileEntry, final FileVersion fileVersion) {
        TransactionCommitCallbackUtil.registerCallback((Callable)new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                DLProcessorRegistryUtil.trigger((FileEntry)fileEntry, (FileVersion)fileVersion, (boolean)true);
                return null;
            }
        });
    }
}

