/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.util;

import com.liferay.portal.kernel.util.ResourceBundleLoader;
import com.liferay.registry.ServiceReference;
import com.liferay.registry.collections.ServiceReferenceMapper;
import com.liferay.registry.collections.ServiceTrackerCollections;
import com.liferay.registry.collections.ServiceTrackerMap;

public class ResourceBundleLoaderUtil {
    private static final ResourceBundleLoaderUtil _instance = new ResourceBundleLoaderUtil();
    private static ResourceBundleLoader _portalResourceBundleLoader;
    private final ServiceTrackerMap<String, ResourceBundleLoader> _bundleSymbolicNameServiceTrackerMap = ServiceTrackerCollections.openSingleValueMap(ResourceBundleLoader.class, (String)"bundle.symbolic.name");
    private final ServiceTrackerMap<String, ResourceBundleLoader> _servletContextNameAndBaseNameServiceTrackerMap = ServiceTrackerCollections.openSingleValueMap(ResourceBundleLoader.class, (String)"(&(resource.bundle.base.name=*)(servlet.context.name=*))", (ServiceReferenceMapper)new ServiceReferenceMapper<String, ResourceBundleLoader>(){

        public void map(ServiceReference<ResourceBundleLoader> serviceReference, ServiceReferenceMapper.Emitter<String> emitter) {
            Object baseName = serviceReference.getProperty("resource.bundle.base.name");
            Object servletContextName = serviceReference.getProperty("servlet.context.name");
            emitter.emit((Object)(baseName + "#" + servletContextName));
        }
    });
    private final ServiceTrackerMap<String, ResourceBundleLoader> _servletContextNameServiceTrackerMap = ServiceTrackerCollections.openSingleValueMap(ResourceBundleLoader.class, (String)"servlet.context.name");

    public static ResourceBundleLoader getPortalResourceBundleLoader() {
        return _portalResourceBundleLoader;
    }

    public static ResourceBundleLoader getResourceBundleLoaderByBundleSymbolicName(String bundleSymbolicName) {
        return (ResourceBundleLoader)ResourceBundleLoaderUtil._instance._bundleSymbolicNameServiceTrackerMap.getService((Object)bundleSymbolicName);
    }

    public static ResourceBundleLoader getResourceBundleLoaderByServletContextName(String servletContextName) {
        return (ResourceBundleLoader)ResourceBundleLoaderUtil._instance._servletContextNameServiceTrackerMap.getService((Object)servletContextName);
    }

    public static ResourceBundleLoader getResourceBundleLoaderByServletContextNameAndBaseName(String servletContextName, String baseName) {
        return (ResourceBundleLoader)ResourceBundleLoaderUtil._instance._servletContextNameAndBaseNameServiceTrackerMap.getService((Object)(baseName + "#" + servletContextName));
    }

    public static void setPortalResourceBundleLoader(ResourceBundleLoader resourceBundleLoader) {
        _portalResourceBundleLoader = resourceBundleLoader;
    }

    private ResourceBundleLoaderUtil() {
    }
}

