/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.process.local;

import com.liferay.portal.kernel.concurrent.AbortPolicy;
import com.liferay.portal.kernel.concurrent.AsyncBroker;
import com.liferay.portal.kernel.concurrent.FutureListener;
import com.liferay.portal.kernel.concurrent.NoticeableFuture;
import com.liferay.portal.kernel.concurrent.NoticeableFutureConverter;
import com.liferay.portal.kernel.concurrent.ThreadPoolExecutor;
import com.liferay.portal.kernel.concurrent.ThreadPoolHandlerAdapter;
import com.liferay.portal.kernel.io.unsync.UnsyncBufferedInputStream;
import com.liferay.portal.kernel.io.unsync.UnsyncByteArrayOutputStream;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.process.ProcessCallable;
import com.liferay.portal.kernel.process.ProcessChannel;
import com.liferay.portal.kernel.process.ProcessConfig;
import com.liferay.portal.kernel.process.ProcessException;
import com.liferay.portal.kernel.process.ProcessExecutor;
import com.liferay.portal.kernel.process.TerminationProcessException;
import com.liferay.portal.kernel.process.local.AsyncBrokerThreadLocal;
import com.liferay.portal.kernel.process.local.ExceptionProcessCallable;
import com.liferay.portal.kernel.process.local.LocalProcessChannel;
import com.liferay.portal.kernel.process.local.LocalProcessLauncher;
import com.liferay.portal.kernel.process.local.ReturnProcessCallable;
import com.liferay.portal.kernel.util.ClassLoaderObjectInputStream;
import com.liferay.portal.kernel.util.NamedThreadFactory;
import com.liferay.portal.kernel.util.PortalClassLoaderUtil;
import com.liferay.portal.kernel.util.StreamUtil;
import java.io.EOFException;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.io.StreamCorruptedException;
import java.io.WriteAbortedException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Future;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.TimeUnit;

public class LocalProcessExecutor
implements ProcessExecutor {
    private static final Log _log = LogFactoryUtil.getLog(LocalProcessExecutor.class);
    private final Map<Process, NoticeableFuture<?>> _managedProcesses = new ConcurrentHashMap();
    private volatile ThreadPoolExecutor _threadPoolExecutor;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<Process> destroy() {
        if (this._threadPoolExecutor == null) {
            return Collections.emptySet();
        }
        Set<Process> processes = Collections.emptySet();
        LocalProcessExecutor localProcessExecutor = this;
        synchronized (localProcessExecutor) {
            if (this._threadPoolExecutor != null) {
                processes = new HashSet();
                this._threadPoolExecutor.shutdownNow();
                Set<Map.Entry<Process, NoticeableFuture<?>>> set = this._managedProcesses.entrySet();
                Iterator<Map.Entry<Process, NoticeableFuture<?>>> iterator = set.iterator();
                while (iterator.hasNext()) {
                    Map.Entry<Process, NoticeableFuture<?>> entry = iterator.next();
                    processes.add(entry.getKey());
                    NoticeableFuture<?> noticeableFuture = entry.getValue();
                    noticeableFuture.cancel(true);
                    iterator.remove();
                }
                this._managedProcesses.clear();
                this._threadPoolExecutor = null;
            }
        }
        return processes;
    }

    @Override
    public <T extends Serializable> ProcessChannel<T> execute(ProcessConfig processConfig, ProcessCallable<T> processCallable) throws ProcessException {
        try {
            List<String> arguments = processConfig.getArguments();
            ArrayList<String> commands = new ArrayList<String>(arguments.size() + 4);
            commands.add(processConfig.getJavaExecutable());
            commands.add("-cp");
            commands.add(processConfig.getBootstrapClassPath());
            commands.addAll(arguments);
            commands.add(LocalProcessLauncher.class.getName());
            ProcessBuilder processBuilder = new ProcessBuilder(commands);
            final Process process = processBuilder.start();
            ObjectOutputStream bootstrapObjectOutputStream = new ObjectOutputStream(process.getOutputStream());
            bootstrapObjectOutputStream.writeObject(processCallable.toString());
            bootstrapObjectOutputStream.writeObject(processConfig.getRuntimeClassPath());
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(bootstrapObjectOutputStream);
            objectOutputStream.writeObject(processCallable);
            objectOutputStream.flush();
            ThreadPoolExecutor threadPoolExecutor = this._getThreadPoolExecutor();
            AsyncBroker<Long, Serializable> asyncBroker = new AsyncBroker<Long, Serializable>();
            SubprocessReactor subprocessReactor = new SubprocessReactor(process, processConfig.getReactClassLoader(), asyncBroker);
            try {
                Future processCallableNoticeableFuture = threadPoolExecutor.submit((Callable)subprocessReactor);
                processCallableNoticeableFuture.addFutureListener(new FutureListener<ProcessCallable<? extends Serializable>>(){

                    @Override
                    public void complete(Future<ProcessCallable<? extends Serializable>> future) {
                        if (future.isCancelled()) {
                            process.destroy();
                        }
                    }
                });
                this._managedProcesses.put(process, (NoticeableFuture<?>)processCallableNoticeableFuture);
                NoticeableFutureConverter noticeableFuture = new NoticeableFutureConverter<T, ProcessCallable<? extends Serializable>>((NoticeableFuture)processCallableNoticeableFuture){

                    @Override
                    protected T convert(ProcessCallable<? extends Serializable> processCallable) throws ProcessException {
                        if (processCallable instanceof ReturnProcessCallable) {
                            return processCallable.call();
                        }
                        ExceptionProcessCallable exceptionProcessCallable = (ExceptionProcessCallable)processCallable;
                        throw exceptionProcessCallable.call();
                    }
                };
                return new LocalProcessChannel(noticeableFuture, objectOutputStream, asyncBroker);
            }
            catch (RejectedExecutionException ree) {
                process.destroy();
                throw new ProcessException("Cancelled execution because of a concurrent destroy", ree);
            }
        }
        catch (IOException ioe) {
            throw new ProcessException(ioe);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ThreadPoolExecutor _getThreadPoolExecutor() {
        if (this._threadPoolExecutor != null) {
            return this._threadPoolExecutor;
        }
        LocalProcessExecutor localProcessExecutor = this;
        synchronized (localProcessExecutor) {
            if (this._threadPoolExecutor == null) {
                this._threadPoolExecutor = new ThreadPoolExecutor(0, Integer.MAX_VALUE, 60L, TimeUnit.SECONDS, true, Integer.MAX_VALUE, new AbortPolicy(), new NamedThreadFactory(LocalProcessExecutor.class.getName(), 1, PortalClassLoaderUtil.getClassLoader()), new ThreadPoolHandlerAdapter());
            }
        }
        return this._threadPoolExecutor;
    }

    private class SubprocessReactor
    implements Callable<ProcessCallable<? extends Serializable>> {
        private final AsyncBroker<Long, Serializable> _asyncBroker;
        private final Process _process;
        private final ClassLoader _reactClassLoader;

        public SubprocessReactor(Process process, ClassLoader reactClassLoader, AsyncBroker<Long, Serializable> asyncBroker) {
            this._process = process;
            this._reactClassLoader = reactClassLoader;
            this._asyncBroker = asyncBroker;
        }

        @Override
        public ProcessCallable<? extends Serializable> call() throws Exception {
            ProcessCallable resultProcessCallable = null;
            AsyncBrokerThreadLocal.setAsyncBroker(this._asyncBroker);
            UnsyncBufferedInputStream unsyncBufferedInputStream = new UnsyncBufferedInputStream(this._process.getInputStream());
            try {
                try {
                    ClassLoaderObjectInputStream objectInputStream = null;
                    UnsyncByteArrayOutputStream unsyncByteArrayOutputStream = new UnsyncByteArrayOutputStream();
                    while (true) {
                        try {
                            unsyncBufferedInputStream.mark(4);
                            objectInputStream = new ClassLoaderObjectInputStream(unsyncBufferedInputStream, this._reactClassLoader);
                            if (unsyncByteArrayOutputStream.size() > 0 && _log.isWarnEnabled()) {
                                _log.warn("Found corrupt leading log " + unsyncByteArrayOutputStream.toString());
                            }
                            unsyncByteArrayOutputStream = null;
                        }
                        catch (StreamCorruptedException sce) {
                            unsyncBufferedInputStream.reset();
                            unsyncByteArrayOutputStream.write(unsyncBufferedInputStream.read());
                            continue;
                        }
                        break;
                    }
                    while (true) {
                        Object obj = null;
                        try {
                            obj = objectInputStream.readObject();
                        }
                        catch (WriteAbortedException wae) {
                            if (!_log.isWarnEnabled()) continue;
                            _log.warn("Caught a write aborted exception", wae);
                            continue;
                        }
                        if (!(obj instanceof ProcessCallable)) {
                            if (!_log.isInfoEnabled()) continue;
                            _log.info("Received a nonprocess callable piping back " + obj);
                            continue;
                        }
                        ProcessCallable processCallable = (ProcessCallable)obj;
                        if (processCallable instanceof ExceptionProcessCallable || processCallable instanceof ReturnProcessCallable) {
                            resultProcessCallable = processCallable;
                            continue;
                        }
                        try {
                            Object returnValue = processCallable.call();
                            if (!_log.isDebugEnabled()) continue;
                            _log.debug("Invoked generic process callable " + processCallable + " with return value " + returnValue);
                        }
                        catch (Throwable t) {
                            _log.error("Unable to invoke generic process callable", t);
                        }
                    }
                }
                catch (StreamCorruptedException sce) {
                    File file = File.createTempFile("corrupted-stream-dump-" + System.currentTimeMillis(), ".log");
                    _log.error("Dumping content of corrupted object input stream to " + file.getAbsolutePath(), sce);
                    FileOutputStream fileOutputStream = new FileOutputStream(file);
                    StreamUtil.transfer(unsyncBufferedInputStream, fileOutputStream);
                    throw new ProcessException("Corrupted object input stream", sce);
                }
                catch (EOFException eofe) {
                    throw new ProcessException("Subprocess piping back ended prematurely", eofe);
                }
                catch (Throwable t) {
                    _log.error("Abort subprocess piping", t);
                    throw t;
                }
            }
            catch (Throwable throwable) {
                try {
                    int exitCode = this._process.waitFor();
                    if (exitCode != 0) {
                        throw new TerminationProcessException(exitCode);
                    }
                }
                catch (InterruptedException ie) {
                    this._process.destroy();
                    throw new ProcessException("Forcibly killed subprocess on interruption", ie);
                }
                LocalProcessExecutor.this._managedProcesses.remove(this._process);
                if (resultProcessCallable != null) {
                    return resultProcessCallable;
                }
                AsyncBrokerThreadLocal.removeAsyncBroker();
                throw throwable;
            }
        }
    }
}

