/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.users.admin.kernel.util;

import aQute.bnd.annotation.ProviderType;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.model.Address;
import com.liferay.portal.kernel.model.Country;
import com.liferay.portal.kernel.model.EmailAddress;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.OrgLabor;
import com.liferay.portal.kernel.model.Organization;
import com.liferay.portal.kernel.model.Phone;
import com.liferay.portal.kernel.model.Region;
import com.liferay.portal.kernel.model.Role;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.model.UserGroup;
import com.liferay.portal.kernel.model.UserGroupGroupRole;
import com.liferay.portal.kernel.model.UserGroupRole;
import com.liferay.portal.kernel.model.Website;
import com.liferay.portal.kernel.search.Hits;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.service.CountryServiceUtil;
import com.liferay.portal.kernel.service.RegionServiceUtil;
import com.liferay.portal.kernel.service.RoleLocalServiceUtil;
import com.liferay.portal.kernel.util.Accessor;
import com.liferay.portal.kernel.util.LocaleThreadLocal;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.Validator;
import java.util.List;
import java.util.Locale;
import javax.portlet.ActionRequest;
import javax.portlet.PortletRequest;
import javax.portlet.RenderResponse;
import javax.servlet.http.HttpServletRequest;

@ProviderType
public interface UsersAdmin {
    public static final String CUSTOM_QUESTION = "write-my-own-question";
    public static final Accessor<Organization, String> ORGANIZATION_COUNTRY_NAME_ACCESSOR = new Accessor<Organization, String>(){

        @Override
        public String get(Organization organization) {
            Address address = organization.getAddress();
            Country country = address.getCountry();
            String countryName = country.getName(LocaleThreadLocal.getThemeDisplayLocale());
            if (Validator.isNull(countryName) && (country = CountryServiceUtil.fetchCountry(organization.getCountryId())) != null) {
                countryName = country.getName(LocaleThreadLocal.getThemeDisplayLocale());
            }
            return countryName;
        }

        @Override
        public Class<String> getAttributeClass() {
            return String.class;
        }

        @Override
        public Class<Organization> getTypeClass() {
            return Organization.class;
        }
    };
    public static final Accessor<Organization, String> ORGANIZATION_REGION_NAME_ACCESSOR = new Accessor<Organization, String>(){

        @Override
        public String get(Organization organization) {
            Address address = organization.getAddress();
            Region region = address.getRegion();
            String regionName = region.getName();
            if (Validator.isNull(regionName) && (region = RegionServiceUtil.fetchRegion(organization.getRegionId())) != null) {
                regionName = LanguageUtil.get(LocaleThreadLocal.getThemeDisplayLocale(), region.getName());
            }
            return regionName;
        }

        @Override
        public Class<String> getAttributeClass() {
            return String.class;
        }

        @Override
        public Class<Organization> getTypeClass() {
            return Organization.class;
        }
    };
    public static final Accessor<UserGroupGroupRole, Long> USER_GROUP_GROUP_ROLE_ID_ACCESSOR = new Accessor<UserGroupGroupRole, Long>(){

        @Override
        public Long get(UserGroupGroupRole userGroupGroupRole) {
            Role role = RoleLocalServiceUtil.fetchRole(userGroupGroupRole.getRoleId());
            if (role == null) {
                return 0L;
            }
            return role.getRoleId();
        }

        @Override
        public Class<Long> getAttributeClass() {
            return Long.class;
        }

        @Override
        public Class<UserGroupGroupRole> getTypeClass() {
            return UserGroupGroupRole.class;
        }
    };
    public static final Accessor<UserGroupGroupRole, String> USER_GROUP_GROUP_ROLE_TITLE_ACCESSOR = new Accessor<UserGroupGroupRole, String>(){

        @Override
        public String get(UserGroupGroupRole userGroupGroupRole) {
            Role role = RoleLocalServiceUtil.fetchRole(userGroupGroupRole.getRoleId());
            if (role == null) {
                return "";
            }
            return role.getTitle(LocaleThreadLocal.getThemeDisplayLocale());
        }

        @Override
        public Class<String> getAttributeClass() {
            return String.class;
        }

        @Override
        public Class<UserGroupGroupRole> getTypeClass() {
            return UserGroupGroupRole.class;
        }
    };
    public static final Accessor<UserGroupRole, Long> USER_GROUP_ROLE_ID_ACCESSOR = new Accessor<UserGroupRole, Long>(){

        @Override
        public Long get(UserGroupRole userGroupRole) {
            Role role = RoleLocalServiceUtil.fetchRole(userGroupRole.getRoleId());
            if (role == null) {
                return 0L;
            }
            return role.getRoleId();
        }

        @Override
        public Class<Long> getAttributeClass() {
            return Long.class;
        }

        @Override
        public Class<UserGroupRole> getTypeClass() {
            return UserGroupRole.class;
        }
    };
    public static final Accessor<UserGroupRole, String> USER_GROUP_ROLE_TITLE_ACCESSOR = new Accessor<UserGroupRole, String>(){

        @Override
        public String get(UserGroupRole userGroupRole) {
            Role role = RoleLocalServiceUtil.fetchRole(userGroupRole.getRoleId());
            if (role == null) {
                return "";
            }
            return role.getTitle(LocaleThreadLocal.getThemeDisplayLocale());
        }

        @Override
        public Class<String> getAttributeClass() {
            return String.class;
        }

        @Override
        public Class<UserGroupRole> getTypeClass() {
            return UserGroupRole.class;
        }
    };

    public void addPortletBreadcrumbEntries(Organization var1, HttpServletRequest var2, RenderResponse var3) throws Exception;

    public long[] addRequiredRoles(long var1, long[] var3) throws PortalException;

    public long[] addRequiredRoles(User var1, long[] var2) throws PortalException;

    public List<Role> filterGroupRoles(PermissionChecker var1, long var2, List<Role> var4) throws PortalException;

    public List<Group> filterGroups(PermissionChecker var1, List<Group> var2) throws PortalException;

    public List<Organization> filterOrganizations(PermissionChecker var1, List<Organization> var2) throws PortalException;

    public List<Role> filterRoles(PermissionChecker var1, List<Role> var2);

    public long[] filterUnsetGroupUserIds(PermissionChecker var1, long var2, long[] var4) throws PortalException;

    public long[] filterUnsetOrganizationUserIds(PermissionChecker var1, long var2, long[] var4) throws PortalException;

    public List<UserGroupRole> filterUserGroupRoles(PermissionChecker var1, List<UserGroupRole> var2) throws PortalException;

    public List<UserGroup> filterUserGroups(PermissionChecker var1, List<UserGroup> var2);

    public List<Address> getAddresses(ActionRequest var1);

    public List<Address> getAddresses(ActionRequest var1, List<Address> var2);

    public List<EmailAddress> getEmailAddresses(ActionRequest var1);

    public List<EmailAddress> getEmailAddresses(ActionRequest var1, List<EmailAddress> var2);

    public long[] getGroupIds(PortletRequest var1) throws PortalException;

    public OrderByComparator<Group> getGroupOrderByComparator(String var1, String var2);

    public Long[] getOrganizationIds(List<Organization> var1);

    public long[] getOrganizationIds(PortletRequest var1) throws PortalException;

    public OrderByComparator<Organization> getOrganizationOrderByComparator(String var1, String var2);

    public List<Organization> getOrganizations(Hits var1) throws PortalException;

    public List<OrgLabor> getOrgLabors(ActionRequest var1);

    public List<Phone> getPhones(ActionRequest var1);

    public List<Phone> getPhones(ActionRequest var1, List<Phone> var2);

    public long[] getRoleIds(PortletRequest var1) throws PortalException;

    public OrderByComparator<Role> getRoleOrderByComparator(String var1, String var2);

    public <T> String getUserColumnText(Locale var1, List<? extends T> var2, Accessor<T, String> var3, int var4);

    public long[] getUserGroupIds(PortletRequest var1) throws PortalException;

    public OrderByComparator<UserGroup> getUserGroupOrderByComparator(String var1, String var2);

    public List<UserGroupRole> getUserGroupRoles(PortletRequest var1) throws PortalException;

    public List<UserGroup> getUserGroups(Hits var1) throws PortalException;

    public OrderByComparator<User> getUserOrderByComparator(String var1, String var2);

    public List<User> getUsers(Hits var1) throws PortalException;

    public List<Website> getWebsites(ActionRequest var1);

    public List<Website> getWebsites(ActionRequest var1, List<Website> var2);

    public boolean hasUpdateFieldPermission(PermissionChecker var1, User var2, User var3, String var4) throws PortalException;

    public long[] removeRequiredRoles(long var1, long[] var3) throws PortalException;

    public long[] removeRequiredRoles(User var1, long[] var2) throws PortalException;

    public void updateAddresses(String var1, long var2, List<Address> var4) throws PortalException;

    public void updateEmailAddresses(String var1, long var2, List<EmailAddress> var4) throws PortalException;

    public void updateOrgLabors(long var1, List<OrgLabor> var3) throws PortalException;

    public void updatePhones(String var1, long var2, List<Phone> var4) throws PortalException;

    public void updateWebsites(String var1, long var2, List<Website> var4) throws PortalException;
}

