/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.util;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.ResourceAction;
import com.liferay.portal.kernel.model.Subscription;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.security.permission.ResourcePermissionCheckerUtil;
import com.liferay.portal.kernel.service.GroupLocalServiceUtil;
import com.liferay.portal.kernel.service.ResourceActionLocalServiceUtil;
import com.liferay.portal.kernel.util.SubscriptionSender;

public class GroupSubscriptionCheckSubscriptionSender
extends SubscriptionSender {
    private final String _resourceName;

    public GroupSubscriptionCheckSubscriptionSender(String resourceName) {
        this._resourceName = resourceName;
    }

    @Override
    protected Boolean hasSubscribePermission(PermissionChecker permissionChecker, Subscription subscription) throws PortalException {
        Group group = GroupLocalServiceUtil.fetchGroup(subscription.getClassPK());
        if (group != null) {
            ResourceAction resourceAction = ResourceActionLocalServiceUtil.fetchResourceAction(subscription.getClassName(), "SUBSCRIBE");
            if (resourceAction == null) {
                return true;
            }
            return ResourcePermissionCheckerUtil.containsResourcePermission(permissionChecker, this._resourceName, subscription.getClassPK(), "SUBSCRIBE");
        }
        return super.hasSubscribePermission(permissionChecker, subscription);
    }
}

