/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.servlet;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.servlet.NonSerializableObjectHandler;
import com.liferay.portal.kernel.servlet.PersistentHttpServletRequestWrapper;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.PropsUtil;
import java.io.NotSerializableException;
import javax.servlet.http.HttpServletRequest;

public class NonSerializableObjectRequestWrapper
extends PersistentHttpServletRequestWrapper {
    private static final boolean _WEBLOGIC_REQUEST_WRAP_NON_SERIALIZABLE = GetterUtil.getBoolean(PropsUtil.get("weblogic.request.wrap.non.serializable"));
    private static final Log _log = LogFactoryUtil.getLog(NonSerializableObjectRequestWrapper.class);

    public static boolean isWrapped(HttpServletRequest request) {
        if (!_WEBLOGIC_REQUEST_WRAP_NON_SERIALIZABLE) {
            return false;
        }
        Class<?> clazz = request.getClass();
        String className = clazz.getName();
        if (className.startsWith("weblogic.")) {
            request.removeAttribute(NonSerializableObjectRequestWrapper.class.getName());
            return false;
        }
        Boolean wrapped = (Boolean)request.getAttribute(NonSerializableObjectRequestWrapper.class.getName());
        if (wrapped == null) {
            return false;
        }
        return wrapped;
    }

    public NonSerializableObjectRequestWrapper(HttpServletRequest request) {
        super(request);
        request.setAttribute(NonSerializableObjectRequestWrapper.class.getName(), (Object)Boolean.TRUE);
    }

    public Object getAttribute(String name) {
        Object object = null;
        try {
            object = super.getAttribute(name);
        }
        catch (Exception e) {
            String message;
            if (e instanceof NotSerializableException && ((message = e.getMessage()) == null || !message.contains("BEA-101362"))) {
                _log.error(e, e);
            }
            return null;
        }
        object = NonSerializableObjectHandler.getValue(object);
        return object;
    }

    public void setAttribute(String name, Object object) {
        if (_WEBLOGIC_REQUEST_WRAP_NON_SERIALIZABLE) {
            object = new NonSerializableObjectHandler(object);
        }
        super.setAttribute(name, object);
    }
}

