/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.search;

import com.liferay.asset.kernel.AssetRendererFactoryRegistryUtil;
import com.liferay.asset.kernel.model.AssetCategory;
import com.liferay.asset.kernel.model.AssetEntry;
import com.liferay.asset.kernel.model.AssetRendererFactory;
import com.liferay.asset.kernel.model.AssetTag;
import com.liferay.asset.kernel.service.AssetCategoryLocalServiceUtil;
import com.liferay.asset.kernel.service.AssetEntryLocalServiceUtil;
import com.liferay.asset.kernel.service.AssetTagLocalServiceUtil;
import com.liferay.expando.kernel.model.ExpandoBridge;
import com.liferay.expando.kernel.model.ExpandoColumn;
import com.liferay.expando.kernel.service.ExpandoColumnLocalServiceUtil;
import com.liferay.expando.kernel.util.ExpandoBridgeFactoryUtil;
import com.liferay.expando.kernel.util.ExpandoBridgeIndexerUtil;
import com.liferay.portal.kernel.exception.NoSuchCountryException;
import com.liferay.portal.kernel.exception.NoSuchModelException;
import com.liferay.portal.kernel.exception.NoSuchRegionException;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Address;
import com.liferay.portal.kernel.model.AttachedModel;
import com.liferay.portal.kernel.model.AuditedModel;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.Country;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.GroupedModel;
import com.liferay.portal.kernel.model.Region;
import com.liferay.portal.kernel.model.ResourcedModel;
import com.liferay.portal.kernel.model.TrashedModel;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.model.WorkflowedModel;
import com.liferay.portal.kernel.search.BooleanClause;
import com.liferay.portal.kernel.search.BooleanClauseOccur;
import com.liferay.portal.kernel.search.BooleanQuery;
import com.liferay.portal.kernel.search.DefaultSearchResultPermissionFilter;
import com.liferay.portal.kernel.search.Document;
import com.liferay.portal.kernel.search.DocumentHelper;
import com.liferay.portal.kernel.search.DocumentImpl;
import com.liferay.portal.kernel.search.Field;
import com.liferay.portal.kernel.search.Hits;
import com.liferay.portal.kernel.search.IndexSearcherHelperUtil;
import com.liferay.portal.kernel.search.IndexWriterHelperUtil;
import com.liferay.portal.kernel.search.Indexer;
import com.liferay.portal.kernel.search.IndexerPostProcessor;
import com.liferay.portal.kernel.search.IndexerRegistryUtil;
import com.liferay.portal.kernel.search.ParseException;
import com.liferay.portal.kernel.search.Query;
import com.liferay.portal.kernel.search.QueryConfig;
import com.liferay.portal.kernel.search.RelatedEntryIndexer;
import com.liferay.portal.kernel.search.SearchContext;
import com.liferay.portal.kernel.search.SearchEngine;
import com.liferay.portal.kernel.search.SearchEngineHelperUtil;
import com.liferay.portal.kernel.search.SearchException;
import com.liferay.portal.kernel.search.SearchPermissionChecker;
import com.liferay.portal.kernel.search.Summary;
import com.liferay.portal.kernel.search.facet.AssetEntriesFacet;
import com.liferay.portal.kernel.search.facet.Facet;
import com.liferay.portal.kernel.search.facet.MultiValueFacet;
import com.liferay.portal.kernel.search.facet.ScopeFacet;
import com.liferay.portal.kernel.search.filter.BooleanFilter;
import com.liferay.portal.kernel.search.filter.Filter;
import com.liferay.portal.kernel.search.filter.QueryFilter;
import com.liferay.portal.kernel.search.filter.TermsFilter;
import com.liferay.portal.kernel.search.generic.BooleanQueryImpl;
import com.liferay.portal.kernel.search.generic.MatchAllQuery;
import com.liferay.portal.kernel.search.hits.HitsProcessorRegistryUtil;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.security.permission.PermissionThreadLocal;
import com.liferay.portal.kernel.service.CountryServiceUtil;
import com.liferay.portal.kernel.service.GroupLocalServiceUtil;
import com.liferay.portal.kernel.service.RegionServiceUtil;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.ServiceContextThreadLocal;
import com.liferay.portal.kernel.service.UserLocalServiceUtil;
import com.liferay.portal.kernel.trash.TrashHandler;
import com.liferay.portal.kernel.trash.TrashRenderer;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.HashUtil;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.LocalizationUtil;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.PropsUtil;
import com.liferay.portal.kernel.util.SetUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.UnicodeProperties;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.ratings.kernel.model.RatingsStats;
import com.liferay.ratings.kernel.service.RatingsStatsLocalServiceUtil;
import com.liferay.trash.kernel.model.TrashEntry;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;

public abstract class BaseIndexer<T>
implements Indexer<T> {
    private static final long _DEFAULT_FOLDER_ID = 0L;
    private static final Log _log = LogFactoryUtil.getLog(BaseIndexer.class);
    private boolean _commitImmediately;
    private String[] _defaultSelectedFieldNames;
    private String[] _defaultSelectedLocalizedFieldNames;
    private final Document _document = new DocumentImpl();
    private boolean _filterSearch;
    private Boolean _indexerEnabled;
    private IndexerPostProcessor[] _indexerPostProcessors = new IndexerPostProcessor[0];
    private boolean _permissionAware;
    private String _searchEngineId;
    private boolean _selectAllLocales;
    private boolean _stagingAware = true;

    @Override
    public void delete(long companyId, String uid) throws SearchException {
        try {
            IndexWriterHelperUtil.deleteDocument(this.getSearchEngineId(), companyId, uid, this._commitImmediately);
        }
        catch (SearchException se) {
            throw se;
        }
        catch (Exception e) {
            throw new SearchException(e);
        }
    }

    @Override
    public void delete(T object) throws SearchException {
        if (object == null) {
            return;
        }
        try {
            this.doDelete(object);
        }
        catch (SearchException se) {
            throw se;
        }
        catch (Exception e) {
            throw new SearchException(e);
        }
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof Indexer)) {
            return false;
        }
        Indexer indexer = (Indexer)object;
        return Validator.equals(this.getClassName(), indexer.getClassName());
    }

    @Override
    @Deprecated
    public String[] getClassNames() {
        return this.getSearchClassNames();
    }

    @Override
    public Document getDocument(T object) throws SearchException {
        try {
            Document document = this.doGetDocument(object);
            for (IndexerPostProcessor indexerPostProcessor : this._indexerPostProcessors) {
                indexerPostProcessor.postProcessDocument(document, object);
            }
            if (document == null) {
                return null;
            }
            Map<String, Field> fields = document.getFields();
            Field groupIdField = fields.get("groupId");
            if (groupIdField != null) {
                long groupId = GetterUtil.getLong(groupIdField.getValue());
                this.addStagingGroupKeyword(document, groupId);
            }
            return document;
        }
        catch (SearchException se) {
            throw se;
        }
        catch (Exception e) {
            throw new SearchException(e);
        }
    }

    @Override
    public BooleanFilter getFacetBooleanFilter(String className, SearchContext searchContext) throws Exception {
        BooleanFilter facetBooleanFilter = new BooleanFilter();
        facetBooleanFilter.addTerm("entryClassName", className);
        if (searchContext.getUserId() > 0L) {
            SearchPermissionChecker searchPermissionChecker = SearchEngineHelperUtil.getSearchPermissionChecker();
            long[] groupIds = searchContext.getGroupIds();
            long groupId = GetterUtil.getLong(searchContext.getAttribute("groupId"));
            if (groupId > 0L) {
                groupIds = new long[]{groupId};
            }
            facetBooleanFilter = searchPermissionChecker.getPermissionBooleanFilter(searchContext.getCompanyId(), groupIds, searchContext.getUserId(), className, facetBooleanFilter, searchContext);
        }
        return facetBooleanFilter;
    }

    @Override
    public BooleanQuery getFullQuery(SearchContext searchContext) throws SearchException {
        try {
            searchContext.setSearchEngineId(this.getSearchEngineId());
            this.resetFullQuery(searchContext);
            Object[] fullQueryEntryClassNames = searchContext.getFullQueryEntryClassNames();
            if (ArrayUtil.isNotEmpty(fullQueryEntryClassNames)) {
                searchContext.setAttribute("relatedEntryClassNames", (Serializable)this.getSearchClassNames());
            }
            String[] entryClassNames = (String[])ArrayUtil.append(this.getSearchClassNames(), fullQueryEntryClassNames);
            searchContext.setEntryClassNames(entryClassNames);
            BooleanFilter fullQueryBooleanFilter = new BooleanFilter();
            this.addSearchAssetCategoryIds(fullQueryBooleanFilter, searchContext);
            this.addSearchAssetTagNames(fullQueryBooleanFilter, searchContext);
            this.addSearchEntryClassNames(fullQueryBooleanFilter, searchContext);
            this.addSearchFolderId(fullQueryBooleanFilter, searchContext);
            this.addSearchGroupId(fullQueryBooleanFilter, searchContext);
            this.addSearchLayout(fullQueryBooleanFilter, searchContext);
            this.addSearchUserId(fullQueryBooleanFilter, searchContext);
            BooleanQuery fullQuery = this.createFullQuery(fullQueryBooleanFilter, searchContext);
            fullQuery.setQueryConfig(searchContext.getQueryConfig());
            return fullQuery;
        }
        catch (SearchException se) {
            throw se;
        }
        catch (Exception e) {
            throw new SearchException(e);
        }
    }

    @Override
    public IndexerPostProcessor[] getIndexerPostProcessors() {
        return this._indexerPostProcessors;
    }

    @Override
    @Deprecated
    public String getPortletId() {
        return "";
    }

    @Override
    public String[] getSearchClassNames() {
        return new String[]{this.getClassName()};
    }

    @Override
    public String getSearchEngineId() {
        SearchEngine searchEngine;
        if (this._searchEngineId != null) {
            return this._searchEngineId;
        }
        Class<?> clazz = this.getClass();
        String searchEngineId = GetterUtil.getString(PropsUtil.get("index.search.engine.id", new com.liferay.portal.kernel.configuration.Filter(clazz.getName())));
        if (Validator.isNotNull(searchEngineId) && (searchEngine = SearchEngineHelperUtil.getSearchEngine(searchEngineId)) != null) {
            this._searchEngineId = searchEngineId;
        }
        if (this._searchEngineId == null) {
            this._searchEngineId = SearchEngineHelperUtil.getDefaultSearchEngineId();
        }
        if (_log.isDebugEnabled()) {
            _log.debug("Search engine ID for " + clazz.getName() + " is " + searchEngineId);
        }
        return this._searchEngineId;
    }

    @Override
    public String getSortField(String orderByCol) {
        String sortField = this.doGetSortField(orderByCol);
        if (this._document.isDocumentSortableTextField(sortField)) {
            return DocumentImpl.getSortableFieldName(sortField);
        }
        return sortField;
    }

    @Override
    public String getSortField(String orderByCol, int sortType) {
        if (sortType == 7 || sortType == 5 || sortType == 4 || sortType == 6) {
            return DocumentImpl.getSortableFieldName(orderByCol);
        }
        return this.getSortField(orderByCol);
    }

    @Override
    @Deprecated
    public Summary getSummary(Document document, Locale locale, String snippet) throws SearchException {
        return this.getSummary(document, snippet, null, null);
    }

    @Override
    public Summary getSummary(Document document, String snippet, PortletRequest portletRequest, PortletResponse portletResponse) throws SearchException {
        try {
            Locale locale = this.getLocale(portletRequest);
            Summary summary = this.doGetSummary(document, locale, snippet, portletRequest, portletResponse);
            for (IndexerPostProcessor indexerPostProcessor : this._indexerPostProcessors) {
                indexerPostProcessor.postProcessSummary(summary, document, locale, snippet);
            }
            return summary;
        }
        catch (SearchException se) {
            throw se;
        }
        catch (Exception e) {
            throw new SearchException(e);
        }
    }

    public int hashCode() {
        return HashUtil.hash(0, this.getClassName());
    }

    @Override
    public boolean hasPermission(PermissionChecker permissionChecker, String entryClassName, long entryClassPK, String actionId) throws Exception {
        return true;
    }

    @Override
    public boolean isCommitImmediately() {
        return this._commitImmediately;
    }

    @Override
    public boolean isFilterSearch() {
        return this._filterSearch;
    }

    @Override
    public boolean isIndexerEnabled() {
        String className = this.getClassName();
        if (this._indexerEnabled == null) {
            String indexerEnabled = PropsUtil.get("indexer.enabled", new com.liferay.portal.kernel.configuration.Filter(className));
            this._indexerEnabled = GetterUtil.getBoolean(indexerEnabled, true);
            return this._indexerEnabled;
        }
        return this._indexerEnabled;
    }

    @Override
    public boolean isPermissionAware() {
        return this._permissionAware;
    }

    public boolean isSelectAllLocales() {
        return this._selectAllLocales;
    }

    @Override
    public boolean isStagingAware() {
        return this._stagingAware;
    }

    @Override
    public boolean isVisible(long classPK, int status) throws Exception {
        return true;
    }

    @Override
    public boolean isVisibleRelatedEntry(long classPK, int status) throws Exception {
        return true;
    }

    @Override
    public void postProcessContextBooleanFilter(BooleanFilter contextBooleanFilter, SearchContext searchContext) throws Exception {
    }

    @Override
    @Deprecated
    public void postProcessContextQuery(BooleanQuery contextQuery, SearchContext searchContext) throws Exception {
    }

    @Override
    public void postProcessSearchQuery(BooleanQuery searchQuery, BooleanFilter fullQueryBooleanFilter, SearchContext searchContext) throws Exception {
        String keywords = searchContext.getKeywords();
        if (Validator.isNull(keywords)) {
            this.addSearchTerm(searchQuery, searchContext, "description", false);
            this.addSearchTerm(searchQuery, searchContext, "title", false);
            this.addSearchTerm(searchQuery, searchContext, "userName", false);
        }
    }

    @Override
    @Deprecated
    public void postProcessSearchQuery(BooleanQuery searchQuery, SearchContext searchContext) throws Exception {
    }

    @Override
    public void registerIndexerPostProcessor(IndexerPostProcessor indexerPostProcessor) {
        List<IndexerPostProcessor> indexerPostProcessorsList = ListUtil.fromArray(this._indexerPostProcessors);
        indexerPostProcessorsList.add(indexerPostProcessor);
        this._indexerPostProcessors = indexerPostProcessorsList.toArray(new IndexerPostProcessor[indexerPostProcessorsList.size()]);
    }

    @Override
    public void reindex(Collection<T> collection) {
        if (IndexWriterHelperUtil.isIndexReadOnly() || !this.isIndexerEnabled() || collection.isEmpty()) {
            return;
        }
        for (T element : collection) {
            try {
                this.reindex(element);
            }
            catch (SearchException se) {
                _log.error("Unable to index object: " + element);
            }
        }
    }

    @Override
    public void reindex(String className, long classPK) throws SearchException {
        try {
            if (IndexWriterHelperUtil.isIndexReadOnly() || !this.isIndexerEnabled() || classPK <= 0L) {
                return;
            }
            this.doReindex(className, classPK);
        }
        catch (NoSuchModelException nsme) {
            if (_log.isWarnEnabled()) {
                _log.warn("Unable to index " + className + " " + classPK, nsme);
            }
        }
        catch (SearchException se) {
            throw se;
        }
        catch (Exception e) {
            throw new SearchException(e);
        }
    }

    @Override
    public void reindex(String[] ids) throws SearchException {
        try {
            if (IndexWriterHelperUtil.isIndexReadOnly() || !this.isIndexerEnabled()) {
                return;
            }
            this.doReindex(ids);
        }
        catch (SearchException se) {
            throw se;
        }
        catch (Exception e) {
            throw new SearchException(e);
        }
    }

    @Override
    public void reindex(T object) throws SearchException {
        try {
            if (IndexWriterHelperUtil.isIndexReadOnly() || !this.isIndexerEnabled()) {
                return;
            }
            if (object == null) {
                return;
            }
            this.doReindex(object);
        }
        catch (SearchException se) {
            throw se;
        }
        catch (Exception e) {
            throw new SearchException(e);
        }
    }

    @Override
    public Hits search(SearchContext searchContext) throws SearchException {
        try {
            Hits hits = null;
            QueryConfig queryConfig = searchContext.getQueryConfig();
            this.addDefaultHighlightFieldNames(queryConfig);
            if (ArrayUtil.isEmpty(queryConfig.getSelectedFieldNames())) {
                this.addDefaultSelectedFieldNames(searchContext);
            }
            this.addFacetSelectedFieldNames(searchContext, queryConfig);
            PermissionChecker permissionChecker = PermissionThreadLocal.getPermissionChecker();
            if (permissionChecker != null && this.isUseSearchResultPermissionFilter(searchContext)) {
                if (searchContext.getUserId() == 0L) {
                    searchContext.setUserId(permissionChecker.getUserId());
                }
                DefaultSearchResultPermissionFilter searchResultPermissionFilter = new DefaultSearchResultPermissionFilter(this, permissionChecker);
                hits = searchResultPermissionFilter.search(searchContext);
            } else {
                hits = this.doSearch(searchContext);
            }
            this.processHits(searchContext, hits);
            return hits;
        }
        catch (SearchException se) {
            throw se;
        }
        catch (Exception e) {
            throw new SearchException(e);
        }
    }

    @Override
    public Hits search(SearchContext searchContext, String ... selectedFieldNames) throws SearchException {
        QueryConfig queryConfig = searchContext.getQueryConfig();
        queryConfig.setSelectedFieldNames(selectedFieldNames);
        return this.search(searchContext);
    }

    @Override
    public long searchCount(SearchContext searchContext) throws SearchException {
        PermissionChecker permissionChecker = PermissionThreadLocal.getPermissionChecker();
        if (permissionChecker != null && this.isUseSearchResultPermissionFilter(searchContext)) {
            Hits hits = this.search(searchContext);
            return hits.getLength();
        }
        QueryConfig queryConfig = searchContext.getQueryConfig();
        queryConfig.setHighlightEnabled(false);
        queryConfig.setHitsProcessingEnabled(false);
        queryConfig.setScoreEnabled(false);
        queryConfig.setQueryIndexingEnabled(false);
        queryConfig.setQuerySuggestionEnabled(false);
        searchContext.setSearchEngineId(this.getSearchEngineId());
        BooleanQuery fullQuery = this.getFullQuery(searchContext);
        fullQuery.setQueryConfig(queryConfig);
        return IndexSearcherHelperUtil.searchCount(searchContext, fullQuery);
    }

    public void setCommitImmediately(boolean commitImmediately) {
        this._commitImmediately = commitImmediately;
    }

    @Override
    public void setIndexerEnabled(boolean indexerEnabled) {
        this._indexerEnabled = indexerEnabled;
    }

    public void setSelectAllLocales(boolean selectAllLocales) {
        this._selectAllLocales = selectAllLocales;
    }

    @Override
    public void unregisterIndexerPostProcessor(IndexerPostProcessor indexerPostProcessor) {
        List<IndexerPostProcessor> indexerPostProcessorsList = ListUtil.fromArray(this._indexerPostProcessors);
        indexerPostProcessorsList.remove(indexerPostProcessor);
        this._indexerPostProcessors = indexerPostProcessorsList.toArray(new IndexerPostProcessor[indexerPostProcessorsList.size()]);
    }

    protected void addAssetFields(Document document, String className, long classPK) {
        AssetRendererFactory<?> assetRendererFactory = AssetRendererFactoryRegistryUtil.getAssetRendererFactoryByClassName(className);
        if (assetRendererFactory == null || !assetRendererFactory.isSelectable()) {
            return;
        }
        AssetEntry assetEntry = AssetEntryLocalServiceUtil.fetchEntry(className, classPK);
        if (assetEntry == null) {
            return;
        }
        if (!document.hasField("createDate")) {
            document.addDate("createDate", assetEntry.getCreateDate());
        }
        if (assetEntry.getExpirationDate() != null) {
            document.addDate("expirationDate", assetEntry.getExpirationDate());
        } else {
            document.addDate("expirationDate", new Date(Long.MAX_VALUE));
        }
        if (!document.hasField("modified")) {
            document.addDate("modified", assetEntry.getModifiedDate());
        }
        document.addNumber("priority", assetEntry.getPriority());
        if (assetEntry.getPublishDate() != null) {
            document.addDate("publishDate", assetEntry.getPublishDate());
        } else {
            document.addDate("publishDate", new Date(0L));
        }
        RatingsStats ratingsStats = RatingsStatsLocalServiceUtil.fetchStats(className, classPK);
        if (ratingsStats != null) {
            document.addNumber("ratings", ratingsStats.getAverageScore());
        } else {
            document.addNumber("ratings", 0.0f);
        }
        document.addNumber("viewCount", assetEntry.getViewCount());
        document.addLocalizedKeyword("localized_title", this.populateMap(assetEntry, assetEntry.getTitleMap()), true, true);
        document.addKeyword("visible", assetEntry.isVisible());
    }

    protected void addDefaultHighlightFieldNames(QueryConfig queryConfig) {
        queryConfig.addHighlightFieldNames("assetCategoryTitles");
        if (queryConfig.isHighlightEnabled()) {
            queryConfig.addHighlightFieldNames("content", "description", "title");
        }
    }

    protected void addDefaultSelectedFieldNames(SearchContext searchContext) {
        QueryConfig queryConfig = searchContext.getQueryConfig();
        Set<String> selectedFieldNames = null;
        if (!ArrayUtil.isEmpty(this.getDefaultSelectedFieldNames())) {
            selectedFieldNames = SetUtil.fromArray(this.getDefaultSelectedFieldNames());
            if (searchContext.isIncludeAttachments() || searchContext.isIncludeDiscussions()) {
                selectedFieldNames.add("classNameId");
                selectedFieldNames.add("classPK");
            }
        }
        if (!ArrayUtil.isEmpty(this.getDefaultSelectedLocalizedFieldNames())) {
            if (selectedFieldNames == null) {
                selectedFieldNames = new HashSet<String>();
            }
            if (this.isSelectAllLocales()) {
                this.addSelectedLocalizedFieldNames(selectedFieldNames, LocaleUtil.toLanguageIds(LanguageUtil.getSupportedLocales()));
            } else {
                this.addSelectedLocalizedFieldNames(selectedFieldNames, LocaleUtil.toLanguageId(queryConfig.getLocale()));
            }
        }
        if (selectedFieldNames != null && !selectedFieldNames.isEmpty()) {
            queryConfig.setSelectedFieldNames(selectedFieldNames.toArray(new String[selectedFieldNames.size()]));
        }
    }

    @Deprecated
    protected void addFacetClause(SearchContext searchContext, BooleanFilter facetBooleanFilter, Collection<Facet> facets) throws ParseException {
        BooleanQueryImpl facetBooleanQuery = new BooleanQueryImpl();
        for (Facet facet : facets) {
            BooleanClause<Query> facetBooleanClause = facet.getFacetClause();
            if (facetBooleanClause == null) continue;
            facetBooleanQuery.add(facetBooleanClause.getClause(), facetBooleanClause.getBooleanClauseOccur());
        }
        if (!facetBooleanQuery.hasClauses()) {
            return;
        }
        QueryFilter queryFilter = new QueryFilter(facetBooleanQuery);
        facetBooleanFilter.add(queryFilter, BooleanClauseOccur.MUST);
    }

    protected void addFacetSelectedFieldNames(SearchContext searchContext, QueryConfig queryConfig) {
        Object[] selectedFieldNames = queryConfig.getSelectedFieldNames();
        if (ArrayUtil.isEmpty(selectedFieldNames) || selectedFieldNames.length == 1 && ((String)selectedFieldNames[0]).equals("*")) {
            return;
        }
        Set<Object> selectedFieldNameSet = SetUtil.fromArray(selectedFieldNames);
        Map<String, Facet> facets = searchContext.getFacets();
        selectedFieldNameSet.addAll(facets.keySet());
        selectedFieldNames = selectedFieldNameSet.toArray(new String[selectedFieldNameSet.size()]);
        queryConfig.setSelectedFieldNames((String[])selectedFieldNames);
    }

    protected void addSearchAssetCategoryIds(BooleanFilter queryBooleanFilter, SearchContext searchContext) throws Exception {
        MultiValueFacet multiValueFacet = new MultiValueFacet(searchContext);
        multiValueFacet.setFieldName("assetCategoryIds");
        multiValueFacet.setStatic(true);
        multiValueFacet.setValues(searchContext.getAssetCategoryIds());
        searchContext.addFacet(multiValueFacet);
    }

    protected void addSearchAssetCategoryTitles(Document document, String field, List<AssetCategory> assetCategories) {
        HashMap<Locale, ArrayList<String>> assetCategoryTitles = new HashMap<Locale, ArrayList<String>>();
        Locale defaultLocale = LocaleUtil.getDefault();
        for (AssetCategory assetCategory : assetCategories) {
            Map<Locale, String> titleMap = assetCategory.getTitleMap();
            for (Map.Entry<Locale, String> entry : titleMap.entrySet()) {
                Locale locale = entry.getKey();
                String title = entry.getValue();
                if (Validator.isNull(title)) continue;
                ArrayList<String> titles = (ArrayList<String>)assetCategoryTitles.get(locale);
                if (titles == null) {
                    titles = new ArrayList<String>();
                    assetCategoryTitles.put(locale, titles);
                }
                titles.add(StringUtil.toLowerCase(title));
            }
        }
        for (Map.Entry entry : assetCategoryTitles.entrySet()) {
            Locale locale = (Locale)entry.getKey();
            List titles = (List)entry.getValue();
            String[] titlesArray = titles.toArray(new String[titles.size()]);
            if (locale.equals(defaultLocale)) {
                document.addText(field, titlesArray);
            }
            document.addText(field.concat("_").concat(locale.toString()), titlesArray);
        }
    }

    protected void addSearchAssetTagNames(BooleanFilter queryBooleanFilter, SearchContext searchContext) throws Exception {
        MultiValueFacet multiValueFacet = new MultiValueFacet(searchContext);
        multiValueFacet.setFieldName("assetTagNames");
        multiValueFacet.setStatic(true);
        multiValueFacet.setValues(searchContext.getAssetTagNames());
        searchContext.addFacet(multiValueFacet);
    }

    protected Filter addSearchClassTypeIds(BooleanFilter contextBooleanFilter, SearchContext searchContext) throws Exception {
        long[] classTypeIds = searchContext.getClassTypeIds();
        if (ArrayUtil.isEmpty(classTypeIds)) {
            return null;
        }
        TermsFilter classTypeIdsTermsFilter = new TermsFilter("classTypeId");
        classTypeIdsTermsFilter.addValues(ArrayUtil.toStringArray(classTypeIds));
        return contextBooleanFilter.add(classTypeIdsTermsFilter, BooleanClauseOccur.MUST);
    }

    protected void addSearchEntryClassNames(BooleanFilter queryBooleanFilter, SearchContext searchContext) throws Exception {
        AssetEntriesFacet facet = new AssetEntriesFacet(searchContext);
        facet.setStatic(true);
        searchContext.addFacet(facet);
    }

    protected Map<String, Query> addSearchExpando(BooleanQuery searchQuery, SearchContext searchContext, String keywords) throws Exception {
        HashMap<String, Query> expandoQueries = new HashMap<String, Query>();
        ExpandoBridge expandoBridge = ExpandoBridgeFactoryUtil.getExpandoBridge(searchContext.getCompanyId(), this.getClassName(searchContext));
        Set<String> attributeNames = SetUtil.fromEnumeration(expandoBridge.getAttributeNames());
        for (String attributeName : attributeNames) {
            Query query;
            UnicodeProperties properties = expandoBridge.getAttributeProperties(attributeName);
            int indexType = GetterUtil.getInteger(properties.getProperty("index-type"));
            if (indexType == 0) continue;
            String fieldName = this.getExpandoFieldName(searchContext, expandoBridge, attributeName);
            if (!Validator.isNotNull(keywords)) continue;
            if (searchContext.isAndSearch()) {
                query = searchQuery.addRequiredTerm(fieldName, keywords);
                expandoQueries.put(attributeName, query);
                continue;
            }
            query = searchQuery.addTerm(fieldName, keywords);
            expandoQueries.put(attributeName, query);
        }
        return expandoQueries;
    }

    protected void addSearchFolderId(BooleanFilter queryBooleanFilter, SearchContext searchContext) throws Exception {
        MultiValueFacet multiValueFacet = new MultiValueFacet(searchContext);
        multiValueFacet.setFieldName("treePath");
        multiValueFacet.setStatic(true);
        long[] folderIds = searchContext.getFolderIds();
        if (ArrayUtil.isNotEmpty(folderIds)) {
            folderIds = ArrayUtil.remove(folderIds, 0L);
            multiValueFacet.setValues(folderIds);
        }
        searchContext.addFacet(multiValueFacet);
    }

    protected void addSearchGroupId(BooleanFilter queryBooleanFilter, SearchContext searchContext) throws Exception {
        ScopeFacet facet = new ScopeFacet(searchContext);
        facet.setStatic(true);
        searchContext.addFacet(facet);
    }

    protected Map<String, Query> addSearchKeywords(BooleanQuery searchQuery, SearchContext searchContext) throws Exception {
        String keywords = searchContext.getKeywords();
        if (Validator.isNull(keywords)) {
            return Collections.emptyMap();
        }
        this.addSearchExpando(searchQuery, searchContext, keywords);
        this.addSearchLocalizedTerm(searchQuery, searchContext, "assetCategoryTitles", searchContext.isLike());
        return searchQuery.addTerms(Field.KEYWORDS, keywords, searchContext.isLike());
    }

    protected void addSearchLayout(BooleanFilter queryBooleanFilter, SearchContext searchContext) throws Exception {
        MultiValueFacet multiValueFacet = new MultiValueFacet(searchContext);
        multiValueFacet.setFieldName("layoutUuid");
        multiValueFacet.setStatic(true);
        searchContext.addFacet(multiValueFacet);
    }

    protected Map<String, Query> addSearchLocalizedTerm(BooleanQuery searchQuery, SearchContext searchContext, String field, boolean like) throws Exception {
        HashMap<String, Query> queries = new HashMap<String, Query>();
        Query query = this.addSearchTerm(searchQuery, searchContext, field, like);
        queries.put(field, query);
        String localizedFieldName = DocumentImpl.getLocalizedName(searchContext.getLocale(), field);
        Query localizedQuery = this.addSearchTerm(searchQuery, searchContext, localizedFieldName, like);
        queries.put(localizedFieldName, localizedQuery);
        return queries;
    }

    protected Query addSearchTerm(BooleanQuery searchQuery, SearchContext searchContext, String field, boolean like) throws Exception {
        Class<?> clazz;
        if (Validator.isNull(field)) {
            return null;
        }
        String value = null;
        Serializable serializable = searchContext.getAttribute(field);
        value = serializable != null ? ((clazz = serializable.getClass()).isArray() ? StringUtil.merge((Object[])serializable) : GetterUtil.getString(serializable)) : GetterUtil.getString(serializable);
        if (Validator.isNotNull(value) && searchContext.getFacet(field) != null) {
            return null;
        }
        if (Validator.isNull(value)) {
            value = searchContext.getKeywords();
        }
        if (Validator.isNull(value)) {
            return null;
        }
        Query query = null;
        query = searchContext.isAndSearch() ? searchQuery.addRequiredTerm(field, value, like) : searchQuery.addTerm(field, value, like);
        return query;
    }

    protected void addSearchUserId(BooleanFilter queryBooleanFilter, SearchContext searchContext) throws Exception {
        MultiValueFacet multiValueFacet = new MultiValueFacet(searchContext);
        multiValueFacet.setFieldName("userId");
        multiValueFacet.setStatic(true);
        long userId = GetterUtil.getLong(searchContext.getAttribute("userId"));
        if (userId > 0L) {
            multiValueFacet.setValues(new long[]{userId});
        }
        searchContext.addFacet(multiValueFacet);
    }

    protected void addSelectedLocalizedFieldNames(Set<String> selectedFieldNames, String ... languageIds) {
        for (String defaultLocalizedSelectedFieldName : this.getDefaultSelectedLocalizedFieldNames()) {
            selectedFieldNames.add(defaultLocalizedSelectedFieldName);
            for (String languageId : languageIds) {
                String localizedFieldName = LocalizationUtil.getLocalizedName(defaultLocalizedSelectedFieldName, languageId);
                selectedFieldNames.add(localizedFieldName);
            }
        }
    }

    protected void addStagingGroupKeyword(Document document, long groupId) {
        if (!this.isStagingAware()) {
            return;
        }
        document.addKeyword("stagingGroup", this.isStagingGroup(groupId));
    }

    protected void addStatus(BooleanFilter contextBooleanFilter, SearchContext searchContext) throws Exception {
        int[] statuses = GetterUtil.getIntegerValues(searchContext.getAttribute("status"), null);
        if (ArrayUtil.isEmpty(statuses)) {
            int status = GetterUtil.getInteger(searchContext.getAttribute("status"), 0);
            statuses = new int[]{status};
        }
        if (!ArrayUtil.contains(statuses, -1)) {
            TermsFilter statusesTermsFilter = new TermsFilter("status");
            statusesTermsFilter.addValues(ArrayUtil.toStringArray(statuses));
            contextBooleanFilter.add(statusesTermsFilter, BooleanClauseOccur.MUST);
        } else {
            contextBooleanFilter.addTerm("status", String.valueOf(8), BooleanClauseOccur.MUST_NOT);
        }
    }

    protected void addTrashFields(Document document, TrashedModel trashedModel) {
        block15: {
            TrashEntry trashEntry;
            block13: {
                trashEntry = null;
                try {
                    trashEntry = trashedModel.getTrashEntry();
                }
                catch (PortalException pe) {
                    if (!_log.isDebugEnabled()) break block13;
                    _log.debug("Unable to get trash entry for " + trashedModel);
                }
            }
            if (trashEntry == null) {
                document.addDate("removedDate", new Date());
                ServiceContext serviceContext = ServiceContextThreadLocal.getServiceContext();
                if (serviceContext != null) {
                    try {
                        User user = UserLocalServiceUtil.getUser(serviceContext.getUserId());
                        document.addKeyword("removedByUserName", user.getFullName(), true);
                    }
                    catch (PortalException pe) {
                        if (_log.isDebugEnabled()) {
                            _log.debug("Unable to locate user: " + serviceContext.getUserId(), pe);
                        }
                    }
                }
            } else {
                document.addDate("removedDate", trashEntry.getCreateDate());
                document.addKeyword("removedByUserName", trashEntry.getUserName(), true);
                if (trashedModel.isInTrash() && !trashedModel.isInTrashExplicitly()) {
                    document.addKeyword("rootEntryClassName", trashEntry.getClassName());
                    document.addKeyword("rootEntryClassPK", trashEntry.getClassPK());
                }
            }
            TrashHandler trashHandler = trashedModel.getTrashHandler();
            try {
                TrashRenderer trashRenderer = null;
                if (trashHandler != null && trashEntry != null) {
                    trashRenderer = trashHandler.getTrashRenderer(trashEntry.getClassPK());
                }
                if (trashRenderer != null) {
                    document.addKeyword("type", trashRenderer.getType(), true);
                }
            }
            catch (PortalException pe) {
                if (!_log.isDebugEnabled()) break block15;
                _log.debug("Unable to get trash renderer for " + trashEntry.getClassName());
            }
        }
    }

    protected BooleanQuery createFullQuery(BooleanFilter fullQueryBooleanFilter, SearchContext searchContext) throws Exception {
        BooleanClause<Query>[] booleanClauses;
        BooleanQueryImpl searchQuery = new BooleanQueryImpl();
        this.addSearchKeywords(searchQuery, searchContext);
        this.postProcessSearchQuery(searchQuery, fullQueryBooleanFilter, searchContext);
        for (IndexerPostProcessor indexerPostProcessor : this._indexerPostProcessors) {
            indexerPostProcessor.postProcessSearchQuery(searchQuery, fullQueryBooleanFilter, searchContext);
        }
        this.doPostProcessSearchQuery(this, searchQuery, searchContext);
        Map<String, Facet> facets = searchContext.getFacets();
        BooleanFilter facetBooleanFilter = new BooleanFilter();
        for (Facet facet : facets.values()) {
            BooleanClause<Filter> filterBooleanClause = facet.getFacetFilterBooleanClause();
            if (filterBooleanClause == null) continue;
            facetBooleanFilter.add(filterBooleanClause.getClause(), filterBooleanClause.getBooleanClauseOccur());
        }
        this.addFacetClause(searchContext, facetBooleanFilter, facets.values());
        if (facetBooleanFilter.hasClauses()) {
            fullQueryBooleanFilter.add(facetBooleanFilter, BooleanClauseOccur.MUST);
        }
        BooleanQueryImpl fullBooleanQuery = new BooleanQueryImpl();
        if (fullQueryBooleanFilter.hasClauses()) {
            fullBooleanQuery.setPreBooleanFilter(fullQueryBooleanFilter);
        }
        if (searchQuery.hasClauses()) {
            fullBooleanQuery.add((Query)searchQuery, BooleanClauseOccur.MUST);
        }
        if ((booleanClauses = searchContext.getBooleanClauses()) != null) {
            for (BooleanClause<Query> booleanClause : booleanClauses) {
                fullBooleanQuery.add((Query)booleanClause.getClause(), booleanClause.getBooleanClauseOccur());
            }
        }
        this.postProcessFullQuery(fullBooleanQuery, searchContext);
        for (IndexerPostProcessor indexerPostProcessor : this._indexerPostProcessors) {
            indexerPostProcessor.postProcessFullQuery(fullBooleanQuery, searchContext);
        }
        return fullBooleanQuery;
    }

    protected Summary createSummary(Document document) {
        return this.createSummary(document, "title", "content");
    }

    protected Summary createSummary(Document document, String titleField, String contentField) {
        String prefix = "snippet_";
        String title = document.get(prefix + titleField, titleField);
        String content = document.get(prefix + contentField, contentField);
        return new Summary(title, content);
    }

    protected void deleteDocument(long companyId, long field1) throws Exception {
        this.deleteDocument(companyId, String.valueOf(field1));
    }

    protected void deleteDocument(long companyId, long field1, String field2) throws Exception {
        this.deleteDocument(companyId, String.valueOf(field1), field2);
    }

    protected void deleteDocument(long companyId, String field1) throws Exception {
        DocumentImpl document = new DocumentImpl();
        document.addUID(this.getClassName(), field1);
        IndexWriterHelperUtil.deleteDocument(this.getSearchEngineId(), companyId, document.get("uid"), this._commitImmediately);
    }

    protected void deleteDocument(long companyId, String field1, String field2) throws Exception {
        DocumentImpl document = new DocumentImpl();
        document.addUID(this.getClassName(), field1, field2);
        IndexWriterHelperUtil.deleteDocument(this.getSearchEngineId(), companyId, document.get("uid"), this._commitImmediately);
    }

    protected abstract void doDelete(T var1) throws Exception;

    protected abstract Document doGetDocument(T var1) throws Exception;

    protected String doGetSortField(String orderByCol) {
        return orderByCol;
    }

    protected abstract Summary doGetSummary(Document var1, Locale var2, String var3, PortletRequest var4, PortletResponse var5) throws Exception;

    @Deprecated
    protected void doPostProcessSearchQuery(Indexer<?> indexer, BooleanQuery searchQuery, SearchContext searchContext) throws Exception {
        indexer.postProcessSearchQuery(searchQuery, searchContext);
        for (IndexerPostProcessor indexerPostProcessor : indexer.getIndexerPostProcessors()) {
            indexerPostProcessor.postProcessSearchQuery(searchQuery, searchContext);
        }
    }

    protected abstract void doReindex(String var1, long var2) throws Exception;

    protected abstract void doReindex(String[] var1) throws Exception;

    protected abstract void doReindex(T var1) throws Exception;

    protected Hits doSearch(SearchContext searchContext) throws SearchException {
        searchContext.setSearchEngineId(this.getSearchEngineId());
        Query fullQuery = this.getFullQuery(searchContext);
        if (!fullQuery.hasChildren()) {
            BooleanFilter preBooleanFilter = fullQuery.getPreBooleanFilter();
            fullQuery = new MatchAllQuery();
            fullQuery.setPreBooleanFilter(preBooleanFilter);
        }
        QueryConfig queryConfig = searchContext.getQueryConfig();
        fullQuery.setQueryConfig(queryConfig);
        return IndexSearcherHelperUtil.search(searchContext, fullQuery);
    }

    protected Document getBaseModelDocument(String portletId, BaseModel<?> baseModel) {
        return this.getBaseModelDocument(portletId, baseModel, baseModel);
    }

    protected Document getBaseModelDocument(String portletId, BaseModel<?> baseModel, BaseModel<?> workflowedBaseModel) {
        TrashedModel trashedModel;
        Document document = this.newDocument();
        String className = baseModel.getModelClassName();
        long classPK = 0L;
        long resourcePrimKey = 0L;
        if (baseModel instanceof ResourcedModel) {
            ResourcedModel resourcedModel = (ResourcedModel)((Object)baseModel);
            classPK = resourcedModel.getResourcePrimKey();
            resourcePrimKey = resourcedModel.getResourcePrimKey();
        } else {
            classPK = (Long)baseModel.getPrimaryKeyObj();
        }
        DocumentHelper documentHelper = new DocumentHelper(document);
        documentHelper.setEntryKey(className, classPK);
        document.addUID(className, classPK);
        List<AssetCategory> assetCategories = AssetCategoryLocalServiceUtil.getCategories(className, classPK);
        long[] assetCategoryIds = ListUtil.toLongArray(assetCategories, AssetCategory.CATEGORY_ID_ACCESSOR);
        document.addKeyword("assetCategoryIds", assetCategoryIds);
        this.addSearchAssetCategoryTitles(document, "assetCategoryTitles", assetCategories);
        long classNameId = PortalUtil.getClassNameId(className);
        List<AssetTag> assetTags = AssetTagLocalServiceUtil.getTags(classNameId, classPK);
        String[] assetTagNames = ListUtil.toArray(assetTags, AssetTag.NAME_ACCESSOR);
        document.addText("assetTagNames", assetTagNames);
        long[] assetTagsIds = ListUtil.toLongArray(assetTags, AssetTag.TAG_ID_ACCESSOR);
        document.addKeyword("assetTagIds", assetTagsIds);
        if (resourcePrimKey > 0L) {
            document.addKeyword("rootEntryClassPK", resourcePrimKey);
        }
        if (baseModel instanceof AttachedModel) {
            AttachedModel attachedModel = (AttachedModel)((Object)baseModel);
            documentHelper.setAttachmentOwnerKey(attachedModel.getClassNameId(), attachedModel.getClassPK());
        }
        if (baseModel instanceof AuditedModel) {
            AuditedModel auditedModel = (AuditedModel)((Object)baseModel);
            document.addKeyword("companyId", auditedModel.getCompanyId());
            document.addDate("createDate", auditedModel.getCreateDate());
            document.addDate("modified", auditedModel.getModifiedDate());
            document.addKeyword("userId", auditedModel.getUserId());
            String userName = PortalUtil.getUserName(auditedModel.getUserId(), auditedModel.getUserName());
            document.addKeyword("userName", userName, true);
        }
        GroupedModel groupedModel = null;
        if (baseModel instanceof GroupedModel) {
            groupedModel = (GroupedModel)((Object)baseModel);
            document.addKeyword("groupId", this.getSiteGroupId(groupedModel.getGroupId()));
            document.addKeyword("scopeGroupId", groupedModel.getGroupId());
        }
        if (workflowedBaseModel instanceof WorkflowedModel) {
            WorkflowedModel workflowedModel = (WorkflowedModel)((Object)workflowedBaseModel);
            document.addKeyword("status", workflowedModel.getStatus());
        }
        if (groupedModel != null && baseModel instanceof TrashedModel && (trashedModel = (TrashedModel)((Object)baseModel)).isInTrash()) {
            this.addTrashFields(document, trashedModel);
        }
        this.addAssetFields(document, className, classPK);
        ExpandoBridgeIndexerUtil.addAttributes(document, baseModel.getExpandoBridge());
        return document;
    }

    protected String getClassName(SearchContext searchContext) {
        return this.getClassName();
    }

    protected String[] getDefaultSelectedFieldNames() {
        return this._defaultSelectedFieldNames;
    }

    protected String[] getDefaultSelectedLocalizedFieldNames() {
        return this._defaultSelectedLocalizedFieldNames;
    }

    protected String getExpandoFieldName(SearchContext searchContext, ExpandoBridge expandoBridge, String attributeName) {
        ExpandoColumn expandoColumn = ExpandoColumnLocalServiceUtil.getDefaultTableColumn(expandoBridge.getCompanyId(), expandoBridge.getClassName(), attributeName);
        String fieldName = ExpandoBridgeIndexerUtil.encodeFieldName(attributeName);
        if (expandoColumn.getType() == 20) {
            fieldName = DocumentImpl.getLocalizedName(searchContext.getLocale(), fieldName);
        }
        return fieldName;
    }

    protected Locale getLocale(PortletRequest portletRequest) {
        if (portletRequest != null) {
            return portletRequest.getLocale();
        }
        return LocaleUtil.getMostRelevantLocale();
    }

    protected Set<String> getLocalizedCountryNames(Country country) {
        HashSet<String> countryNames = new HashSet<String>();
        for (Locale locale : LanguageUtil.getAvailableLocales()) {
            String countryName = country.getName(locale);
            countryName = StringUtil.toLowerCase(countryName);
            countryNames.add(countryName);
        }
        return countryNames;
    }

    @Deprecated
    protected String getPortletId(SearchContext searchContext) {
        return "";
    }

    protected Group getSiteGroup(long groupId) {
        Group group;
        block3: {
            group = null;
            try {
                group = GroupLocalServiceUtil.getGroup(groupId);
                if (group.isLayout()) {
                    group = group.getParentGroup();
                }
            }
            catch (PortalException pe) {
                if (!_log.isDebugEnabled()) break block3;
                _log.debug("Unable to get site group", pe);
            }
        }
        return group;
    }

    protected long getSiteGroupId(long groupId) {
        Group group = this.getSiteGroup(groupId);
        if (group == null) {
            return groupId;
        }
        return group.getGroupId();
    }

    protected Locale getSnippetLocale(Document document, Locale locale) {
        String prefix = "snippet_";
        String localizedAssetCategoryTitlesName = prefix + DocumentImpl.getLocalizedName(locale, "assetCategoryTitles");
        String localizedContentName = prefix + DocumentImpl.getLocalizedName(locale, "content");
        String localizedDescriptionName = prefix + DocumentImpl.getLocalizedName(locale, "description");
        String localizedTitleName = prefix + DocumentImpl.getLocalizedName(locale, "title");
        if (document.getField(localizedAssetCategoryTitlesName) != null || document.getField(localizedContentName) != null || document.getField(localizedDescriptionName) != null || document.getField(localizedTitleName) != null) {
            return locale;
        }
        return null;
    }

    protected boolean isStagingGroup(long groupId) {
        Group group = this.getSiteGroup(groupId);
        if (group == null) {
            return false;
        }
        return group.isStagingGroup();
    }

    protected boolean isUseSearchResultPermissionFilter(SearchContext searchContext) {
        return this.isFilterSearch();
    }

    protected boolean isVisible(int entryStatus, int queryStatus) {
        return queryStatus != -1 && entryStatus == queryStatus || entryStatus != 8;
    }

    protected Document newDocument() {
        return (Document)this._document.clone();
    }

    protected void populateAddresses(Document document, List<Address> addresses, long regionId, long countryId) throws PortalException {
        ArrayList<String> regions;
        ArrayList<String> countries;
        ArrayList<String> cities;
        block8: {
            block7: {
                cities = new ArrayList<String>();
                countries = new ArrayList<String>();
                if (countryId > 0L) {
                    try {
                        Country country = CountryServiceUtil.getCountry(countryId);
                        countries.addAll(this.getLocalizedCountryNames(country));
                    }
                    catch (NoSuchCountryException nsce) {
                        if (!_log.isWarnEnabled()) break block7;
                        _log.warn(nsce.getMessage());
                    }
                }
            }
            regions = new ArrayList<String>();
            if (regionId > 0L) {
                try {
                    Region region = RegionServiceUtil.getRegion(regionId);
                    regions.add(StringUtil.toLowerCase(region.getName()));
                }
                catch (NoSuchRegionException nsre) {
                    if (!_log.isWarnEnabled()) break block8;
                    _log.warn(nsre.getMessage());
                }
            }
        }
        ArrayList<String> streets = new ArrayList<String>();
        ArrayList<String> zips = new ArrayList<String>();
        for (Address address : addresses) {
            cities.add(StringUtil.toLowerCase(address.getCity()));
            countries.addAll(this.getLocalizedCountryNames(address.getCountry()));
            regions.add(StringUtil.toLowerCase(address.getRegion().getName()));
            streets.add(StringUtil.toLowerCase(address.getStreet1()));
            streets.add(StringUtil.toLowerCase(address.getStreet2()));
            streets.add(StringUtil.toLowerCase(address.getStreet3()));
            zips.add(StringUtil.toLowerCase(address.getZip()));
        }
        document.addText("city", cities.toArray(new String[cities.size()]));
        document.addText("country", countries.toArray(new String[countries.size()]));
        document.addText("region", regions.toArray(new String[regions.size()]));
        document.addText("street", streets.toArray(new String[streets.size()]));
        document.addText("zip", zips.toArray(new String[zips.size()]));
    }

    protected Map<Locale, String> populateMap(AssetEntry assetEntry, Map<Locale, String> map) {
        String defaultValue = map.get(LocaleUtil.fromLanguageId(assetEntry.getDefaultLanguageId()));
        for (Locale availableLocale : LanguageUtil.getAvailableLocales(assetEntry.getGroupId())) {
            if (map.containsKey(availableLocale) && !Validator.isNull(map.get(availableLocale))) continue;
            map.put(availableLocale, defaultValue);
        }
        return map;
    }

    protected void postProcessFullQuery(BooleanQuery fullQuery, SearchContext searchContext) throws Exception {
    }

    protected void processHits(SearchContext searchContext, Hits hits) throws SearchException {
        HitsProcessorRegistryUtil.process(searchContext, hits);
    }

    protected void resetFullQuery(SearchContext searchContext) {
        searchContext.clearFullQueryEntryClassNames();
        for (Indexer<?> indexer : IndexerRegistryUtil.getIndexers()) {
            if (!(indexer instanceof RelatedEntryIndexer)) continue;
            RelatedEntryIndexer relatedEntryIndexer = (RelatedEntryIndexer)((Object)indexer);
            relatedEntryIndexer.updateFullQuery(searchContext);
        }
    }

    protected void setDefaultSelectedFieldNames(String ... defaultLocalizedFieldNames) {
        this._defaultSelectedFieldNames = defaultLocalizedFieldNames;
    }

    protected void setDefaultSelectedLocalizedFieldNames(String ... defaultLocalizedFieldNames) {
        this._defaultSelectedLocalizedFieldNames = defaultLocalizedFieldNames;
    }

    protected void setFilterSearch(boolean filterSearch) {
        this._filterSearch = filterSearch;
    }

    protected void setPermissionAware(boolean permissionAware) {
        this._permissionAware = permissionAware;
    }

    protected void setStagingAware(boolean stagingAware) {
        this._stagingAware = stagingAware;
    }
}

