/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.process;

import com.liferay.portal.kernel.concurrent.AbortPolicy;
import com.liferay.portal.kernel.concurrent.BaseFutureListener;
import com.liferay.portal.kernel.concurrent.DefaultNoticeableFuture;
import com.liferay.portal.kernel.concurrent.FutureListener;
import com.liferay.portal.kernel.concurrent.NoticeableFuture;
import com.liferay.portal.kernel.concurrent.ThreadPoolExecutor;
import com.liferay.portal.kernel.concurrent.ThreadPoolHandlerAdapter;
import com.liferay.portal.kernel.process.CollectorOutputProcessor;
import com.liferay.portal.kernel.process.ConsumerOutputProcessor;
import com.liferay.portal.kernel.process.EchoOutputProcessor;
import com.liferay.portal.kernel.process.LoggingOutputProcessor;
import com.liferay.portal.kernel.process.OutputProcessor;
import com.liferay.portal.kernel.process.ProcessException;
import com.liferay.portal.kernel.process.TerminationProcessException;
import com.liferay.portal.kernel.util.NamedThreadFactory;
import com.liferay.portal.kernel.util.ObjectValuePair;
import com.liferay.portal.kernel.util.PortalClassLoaderUtil;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicMarkableReference;

public class ProcessUtil {
    public static final CollectorOutputProcessor COLLECTOR_OUTPUT_PROCESSOR = new CollectorOutputProcessor();
    public static final ConsumerOutputProcessor CONSUMER_OUTPUT_PROCESSOR = new ConsumerOutputProcessor();
    public static final EchoOutputProcessor ECHO_OUTPUT_PROCESSOR = new EchoOutputProcessor();
    public static final LoggingOutputProcessor LOGGING_OUTPUT_PROCESSOR = new LoggingOutputProcessor();
    private static volatile ThreadPoolExecutor _threadPoolExecutor;

    public static <O, E> NoticeableFuture<ObjectValuePair<O, E>> execute(OutputProcessor<O, E> outputProcessor, List<String> arguments) throws ProcessException {
        if (outputProcessor == null) {
            throw new NullPointerException("Output processor is null");
        }
        if (arguments == null) {
            throw new NullPointerException("Arguments is null");
        }
        ProcessBuilder processBuilder = new ProcessBuilder(arguments);
        try {
            Process process = processBuilder.start();
            ThreadPoolExecutor threadPoolExecutor = ProcessUtil._getThreadPoolExecutor();
            try {
                Future stdOutNoticeableFuture = threadPoolExecutor.submit((Callable)new ProcessStdOutCallable<O>(outputProcessor, process));
                Future stdErrNoticeableFuture = threadPoolExecutor.submit((Callable)new ProcessStdErrCallable<E>(outputProcessor, process));
                return ProcessUtil._wrapNoticeableFuture(stdOutNoticeableFuture, stdErrNoticeableFuture, process);
            }
            catch (RejectedExecutionException ree) {
                process.destroy();
                throw new ProcessException("Cancelled execution because of a concurrent destroy", ree);
            }
        }
        catch (IOException ioe) {
            throw new ProcessException(ioe);
        }
    }

    public static <O, E> NoticeableFuture<ObjectValuePair<O, E>> execute(OutputProcessor<O, E> outputProcessor, String ... arguments) throws ProcessException {
        return ProcessUtil.execute(outputProcessor, Arrays.asList(arguments));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() {
        if (_threadPoolExecutor == null) {
            return;
        }
        Class<ProcessUtil> clazz = ProcessUtil.class;
        synchronized (ProcessUtil.class) {
            if (_threadPoolExecutor != null) {
                _threadPoolExecutor.shutdownNow();
                _threadPoolExecutor = null;
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ThreadPoolExecutor _getThreadPoolExecutor() {
        if (_threadPoolExecutor != null) {
            return _threadPoolExecutor;
        }
        Class<ProcessUtil> clazz = ProcessUtil.class;
        synchronized (ProcessUtil.class) {
            if (_threadPoolExecutor == null) {
                _threadPoolExecutor = new ThreadPoolExecutor(0, Integer.MAX_VALUE, 60L, TimeUnit.SECONDS, true, Integer.MAX_VALUE, new AbortPolicy(), new NamedThreadFactory(ProcessUtil.class.getName(), 1, PortalClassLoaderUtil.getClassLoader()), new ThreadPoolHandlerAdapter());
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return _threadPoolExecutor;
        }
    }

    private static <O, E> NoticeableFuture<ObjectValuePair<O, E>> _wrapNoticeableFuture(final NoticeableFuture<O> stdOutNoticeableFuture, final NoticeableFuture<E> stdErrNoticeableFuture, final Process process) {
        final DefaultNoticeableFuture<ObjectValuePair<O, E>> defaultNoticeableFuture = new DefaultNoticeableFuture<ObjectValuePair<O, E>>();
        defaultNoticeableFuture.addFutureListener(new FutureListener<ObjectValuePair<O, E>>(){

            @Override
            public void complete(Future<ObjectValuePair<O, E>> future) {
                if (!future.isCancelled()) {
                    return;
                }
                stdOutNoticeableFuture.cancel(true);
                stdErrNoticeableFuture.cancel(true);
                process.destroy();
            }
        });
        final AtomicMarkableReference<Object> stdOutReference = new AtomicMarkableReference<Object>(null, false);
        final AtomicMarkableReference<Object> stdErrReference = new AtomicMarkableReference<Object>(null, false);
        stdOutNoticeableFuture.addFutureListener(new BaseFutureListener<O>(){

            @Override
            public void completeWithCancel(Future<O> future) {
                defaultNoticeableFuture.cancel(true);
            }

            @Override
            public void completeWithException(Future<O> future, Throwable throwable) {
                defaultNoticeableFuture.setException(throwable);
            }

            @Override
            public void completeWithResult(Future<O> future, O stdOut) {
                stdOutReference.set(stdOut, true);
                boolean[] markHolder = new boolean[1];
                Object stdErr = stdErrReference.get(markHolder);
                if (markHolder[0]) {
                    defaultNoticeableFuture.set(new ObjectValuePair(stdOut, stdErr));
                }
            }
        });
        stdErrNoticeableFuture.addFutureListener(new BaseFutureListener<E>(){

            @Override
            public void completeWithCancel(Future<E> future) {
                defaultNoticeableFuture.cancel(true);
            }

            @Override
            public void completeWithException(Future<E> future, Throwable throwable) {
                defaultNoticeableFuture.setException(throwable);
            }

            @Override
            public void completeWithResult(Future<E> future, E stdErr) {
                stdErrReference.set(stdErr, true);
                boolean[] markHolder = new boolean[1];
                Object stdOut = stdOutReference.get(markHolder);
                if (markHolder[0]) {
                    defaultNoticeableFuture.set(new ObjectValuePair(stdOut, stdErr));
                }
            }
        });
        return defaultNoticeableFuture;
    }

    private static class ProcessStdOutCallable<T>
    implements Callable<T> {
        private final OutputProcessor<T, ?> _outputProcessor;
        private final Process _process;

        public ProcessStdOutCallable(OutputProcessor<T, ?> outputProcessor, Process process) {
            this._outputProcessor = outputProcessor;
            this._process = process;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public T call() throws Exception {
            try {
                T t = this._outputProcessor.processStdOut(this._process.getInputStream());
                return t;
            }
            finally {
                try {
                    int exitCode = this._process.waitFor();
                    if (exitCode != 0) {
                        throw new TerminationProcessException(exitCode);
                    }
                }
                catch (InterruptedException ie) {
                    this._process.destroy();
                    throw new ProcessException("Forcibly killed subprocess on interruption", ie);
                }
            }
        }
    }

    private static class ProcessStdErrCallable<T>
    implements Callable<T> {
        private final OutputProcessor<?, T> _outputProcessor;
        private final Process _process;

        public ProcessStdErrCallable(OutputProcessor<?, T> outputProcessor, Process process) {
            this._outputProcessor = outputProcessor;
            this._process = process;
        }

        @Override
        public T call() throws Exception {
            return this._outputProcessor.processStdErr(this._process.getErrorStream());
        }
    }
}

