/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.portlet;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.PortletConstants;
import com.liferay.portal.kernel.portlet.ConfigurationAction;
import com.liferay.portal.kernel.portlet.PortletBag;
import com.liferay.portal.kernel.portlet.PortletBagPool;
import com.liferay.portal.kernel.portlet.ResourceServingConfigurationAction;
import com.liferay.portal.kernel.portlet.SettingsConfigurationAction;
import com.liferay.portal.kernel.settings.LocalizedValuesMap;
import com.liferay.portal.kernel.settings.ModifiableSettings;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import java.io.IOException;
import java.util.Locale;
import java.util.Map;
import javax.portlet.PortletConfig;
import javax.portlet.PortletRequest;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class BaseJSPSettingsConfigurationAction
extends SettingsConfigurationAction
implements ConfigurationAction,
ResourceServingConfigurationAction {
    private static final Log _log = LogFactoryUtil.getLog(BaseJSPSettingsConfigurationAction.class);
    private ServletContext _servletContext;

    public String getJspPath(HttpServletRequest request) {
        PortletConfig selPortletConfig = this.getSelPortletConfig(request);
        String configTemplate = selPortletConfig.getInitParameter("config-template");
        if (Validator.isNotNull(configTemplate)) {
            return configTemplate;
        }
        String configJSP = selPortletConfig.getInitParameter("config-jsp");
        if (Validator.isNotNull(configJSP)) {
            return configJSP;
        }
        return "/configuration.jsp";
    }

    @Override
    public void include(PortletConfig portletConfig, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ServletContext servletContext = this.getServletContext(request);
        RequestDispatcher requestDispatcher = servletContext.getRequestDispatcher(this.getJspPath(request));
        try {
            requestDispatcher.include((ServletRequest)request, (ServletResponse)response);
        }
        catch (ServletException se) {
            _log.error("Unable to include JSP " + this.getJspPath(request), se);
            throw new IOException("Unable to include " + this.getJspPath(request), se);
        }
    }

    public void setServletContext(ServletContext servletContext) {
        this._servletContext = servletContext;
    }

    protected ServletContext getServletContext(HttpServletRequest request) {
        if (this._servletContext != null) {
            return this._servletContext;
        }
        String portletResource = ParamUtil.getString(request, "portletResource");
        if (Validator.isNotNull(portletResource)) {
            String rootPortletId = PortletConstants.getRootPortletId(portletResource);
            PortletBag portletBag = PortletBagPool.get(rootPortletId);
            return portletBag.getServletContext();
        }
        return (ServletContext)request.getAttribute("CTX");
    }

    protected void removeDefaultValue(PortletRequest portletRequest, ModifiableSettings modifiableSettings, String key, LocalizedValuesMap localizedMap) {
        String defaultValue = localizedMap.getDefaultValue();
        Map<Locale, String> localizedMapValues = localizedMap.getValues();
        for (Locale locale : localizedMapValues.keySet()) {
            String languageKeyId = key + "_" + LocaleUtil.toLanguageId(locale);
            String value = this.getParameter(portletRequest, languageKeyId);
            if (!defaultValue.equals(value) && !StringUtil.equalsIgnoreBreakLine(defaultValue, value)) continue;
            modifiableSettings.reset(languageKeyId);
        }
    }
}

