/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.model.impl;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.Layout;
import com.liferay.portal.kernel.model.LayoutTypeAccessPolicy;
import com.liferay.portal.kernel.model.LayoutTypePortlet;
import com.liferay.portal.kernel.model.Portlet;
import com.liferay.portal.kernel.portlet.PortletModeFactory;
import com.liferay.portal.kernel.security.auth.AuthTokenUtil;
import com.liferay.portal.kernel.security.auth.PrincipalException;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.security.permission.PermissionThreadLocal;
import com.liferay.portal.kernel.service.permission.LayoutPermissionUtil;
import com.liferay.portal.kernel.service.permission.PortletPermissionUtil;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.PropsUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import javax.portlet.PortletMode;
import javax.servlet.http.HttpServletRequest;

public class DefaultLayoutTypeAccessPolicyImpl
implements LayoutTypeAccessPolicy {
    private static final boolean _PORTLET_ADD_DEFAULT_RESOURCE_CHECK_ENABLED = GetterUtil.getBoolean(PropsUtil.get("portlet.add.default.resource.check.enabled"));
    private static final LayoutTypeAccessPolicy _instance = new DefaultLayoutTypeAccessPolicyImpl();

    public static LayoutTypeAccessPolicy create() {
        return _instance;
    }

    @Override
    public void checkAccessAllowedToPortlet(HttpServletRequest request, Layout layout, Portlet portlet) throws PortalException {
        if (this.isAccessAllowedToLayoutPortlet(request, layout, portlet)) {
            PortalUtil.addPortletDefaultResource(request, portlet);
            if (this.hasAccessPermission(request, layout, portlet)) {
                return;
            }
        }
        throw new PrincipalException.MustHavePermission(PortalUtil.getUserId(request), portlet.getDisplayName(), portlet.getPortletId(), "ACCESS");
    }

    @Override
    public boolean isAddLayoutAllowed(PermissionChecker permissionChecker, Layout layout) throws PortalException {
        return LayoutPermissionUtil.contains(permissionChecker, layout, "ADD_LAYOUT");
    }

    @Override
    public boolean isCustomizeLayoutAllowed(PermissionChecker permissionChecker, Layout layout) throws PortalException {
        return LayoutPermissionUtil.contains(permissionChecker, layout, "CUSTOMIZE");
    }

    @Override
    public boolean isDeleteLayoutAllowed(PermissionChecker permissionChecker, Layout layout) throws PortalException {
        return LayoutPermissionUtil.contains(permissionChecker, layout, "DELETE");
    }

    @Override
    public boolean isUpdateLayoutAllowed(PermissionChecker permissionChecker, Layout layout) throws PortalException {
        return LayoutPermissionUtil.contains(permissionChecker, layout, "UPDATE");
    }

    @Override
    public boolean isViewLayoutAllowed(PermissionChecker permissionChecker, Layout layout) throws PortalException {
        return LayoutPermissionUtil.contains(permissionChecker, layout, "VIEW");
    }

    protected boolean hasAccessPermission(HttpServletRequest request, Layout layout, Portlet portlet) throws PortalException {
        PermissionChecker permissionChecker = PermissionThreadLocal.getPermissionChecker();
        ThemeDisplay themeDisplay = (ThemeDisplay)request.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        PortletMode portletMode = PortletMode.VIEW;
        String portletId = portlet.getPortletId();
        String ppid = request.getParameter("p_p_id");
        String ppmode = request.getParameter("p_p_mode");
        if (portletId.equals(ppid) && ppmode != null) {
            portletMode = PortletModeFactory.getPortletMode(ppmode);
        }
        return PortletPermissionUtil.hasAccessPermission(permissionChecker, themeDisplay.getScopeGroupId(), layout, portlet, portletMode);
    }

    protected boolean isAccessAllowedToLayoutPortlet(HttpServletRequest request, Layout layout, Portlet portlet) {
        if (this.isAccessGrantedByRuntimePortlet(request)) {
            return true;
        }
        if (this.isAccessGrantedByPortletOnPage(layout, portlet)) {
            return true;
        }
        return this.isAccessGrantedByPortletAuthenticationToken(request, layout, portlet);
    }

    protected boolean isAccessGrantedByPortletAuthenticationToken(HttpServletRequest request, Layout layout, Portlet portlet) {
        if (!portlet.isAddDefaultResource()) {
            return false;
        }
        if (!_PORTLET_ADD_DEFAULT_RESOURCE_CHECK_ENABLED) {
            return true;
        }
        return AuthTokenUtil.isValidPortletInvocationToken(request, layout, portlet);
    }

    protected boolean isAccessGrantedByPortletOnPage(Layout layout, Portlet portlet) {
        String portletId = portlet.getPortletId();
        if (layout.isTypePanel() && this.isPanelSelectedPortlet(layout, portletId)) {
            return true;
        }
        LayoutTypePortlet layoutTypePortlet = (LayoutTypePortlet)layout.getLayoutType();
        return layoutTypePortlet != null && layoutTypePortlet.hasPortletId(portletId);
    }

    protected boolean isAccessGrantedByRuntimePortlet(HttpServletRequest request) {
        Boolean renderPortletResource = (Boolean)request.getAttribute("RENDER_PORTLET_RESOURCE");
        if (renderPortletResource != null) {
            return renderPortletResource;
        }
        return false;
    }

    protected boolean isPanelSelectedPortlet(Layout layout, String portletId) {
        String panelSelectedPortlets = layout.getTypeSettingsProperty("panelSelectedPortlets");
        if (Validator.isNotNull(panelSelectedPortlets)) {
            Object[] panelSelectedPortletsArray = StringUtil.split(panelSelectedPortlets);
            return ArrayUtil.contains(panelSelectedPortletsArray, portletId);
        }
        return false;
    }
}

