/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.language;

import com.liferay.portal.kernel.concurrent.ConcurrentReferenceValueHashMap;
import com.liferay.portal.kernel.memory.FinalizeManager;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.net.URLConnection;
import java.util.Locale;
import java.util.Map;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;

public class UTF8Control
extends ResourceBundle.Control {
    public static final UTF8Control INSTANCE = new UTF8Control();
    private static final Map<URL, ResourceBundle> _resourceBundles = new ConcurrentReferenceValueHashMap<URL, ResourceBundle>(FinalizeManager.SOFT_REFERENCE_FACTORY);

    @Override
    public ResourceBundle newBundle(String baseName, Locale locale, String format, ClassLoader classLoader, boolean reload) throws IOException {
        ResourceBundle resourceBundle;
        URL url = classLoader.getResource(this.toResourceName(this.toBundleName(baseName, locale), "properties"));
        if (url == null) {
            return null;
        }
        if (!reload && (resourceBundle = _resourceBundles.get(url)) != null) {
            return resourceBundle;
        }
        URLConnection urlConnection = url.openConnection();
        urlConnection.setUseCaches(!reload);
        try (InputStream inputStream = urlConnection.getInputStream();){
            PropertyResourceBundle resourceBundle2 = new PropertyResourceBundle(new InputStreamReader(inputStream, "UTF-8"));
            _resourceBundles.put(url, resourceBundle2);
            PropertyResourceBundle propertyResourceBundle = resourceBundle2;
            return propertyResourceBundle;
        }
    }
}

