/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.io;

import com.liferay.portal.kernel.nio.charset.CharsetEncoderUtil;
import com.liferay.portal.kernel.util.StringPool;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CoderResult;

public class OutputStreamWriter
extends Writer {
    private static final int _DEFAULT_OUTPUT_BUFFER_SIZE = 8192;
    private final boolean _autoFlush;
    private final CharsetEncoder _charsetEncoder;
    private final String _charsetName;
    private final char[] _inputArray = new char[1];
    private final CharBuffer _inputCharBuffer = CharBuffer.wrap(this._inputArray);
    private final ByteBuffer _outputByteBuffer;
    private final OutputStream _outputStream;

    public OutputStreamWriter(OutputStream outputStream) {
        this(outputStream, StringPool.DEFAULT_CHARSET_NAME, 8192, false);
    }

    public OutputStreamWriter(OutputStream outputStream, String charsetName) {
        this(outputStream, charsetName, 8192, false);
    }

    public OutputStreamWriter(OutputStream outputStream, String charsetName, boolean autoFlush) {
        this(outputStream, charsetName, 8192, autoFlush);
    }

    public OutputStreamWriter(OutputStream outputStream, String charsetName, int outputBufferSize) {
        this(outputStream, charsetName, outputBufferSize, false);
    }

    public OutputStreamWriter(OutputStream outputStream, String charsetName, int outputBufferSize, boolean autoFlush) {
        if (outputBufferSize < 4) {
            throw new IllegalArgumentException("Output buffer size " + outputBufferSize + " is less than 4");
        }
        if (charsetName == null) {
            charsetName = StringPool.DEFAULT_CHARSET_NAME;
        }
        this._outputStream = outputStream;
        this._charsetName = charsetName;
        this._charsetEncoder = CharsetEncoderUtil.getCharsetEncoder(charsetName);
        this._outputByteBuffer = ByteBuffer.allocate(outputBufferSize);
        this._autoFlush = autoFlush;
    }

    @Override
    public void close() throws IOException {
        this._flushBuffer();
        this._outputStream.close();
    }

    @Override
    public void flush() throws IOException {
        this._flushBuffer();
        this._outputStream.flush();
    }

    public String getEncoding() {
        return this._charsetName;
    }

    @Override
    public void write(char[] chars) throws IOException {
        this._doWrite(CharBuffer.wrap(chars, 0, chars.length));
    }

    @Override
    public void write(char[] chars, int offset, int length) throws IOException {
        this._doWrite(CharBuffer.wrap(chars, offset, length));
    }

    @Override
    public void write(int c) throws IOException {
        this._inputArray[0] = (char)c;
        this._doWrite(this._inputCharBuffer);
        this._inputCharBuffer.clear();
    }

    @Override
    public void write(String string) throws IOException {
        this._doWrite(CharBuffer.wrap(string, 0, string.length()));
    }

    @Override
    public void write(String string, int offset, int length) throws IOException {
        this._doWrite(CharBuffer.wrap(string, offset, offset + length));
    }

    private void _doWrite(CharBuffer inputCharBuffer) throws IOException {
        CoderResult coderResult;
        while ((coderResult = this._charsetEncoder.encode(inputCharBuffer, this._outputByteBuffer, true)).isOverflow()) {
            this._flushBuffer();
        }
        if (coderResult.isUnderflow()) {
            if (this._autoFlush) {
                this._flushBuffer();
            }
        } else {
            throw new IOException("Unexcepted coder result " + coderResult);
        }
    }

    private void _flushBuffer() throws IOException {
        if (this._outputByteBuffer.position() > 0) {
            this._outputStream.write(this._outputByteBuffer.array(), 0, this._outputByteBuffer.position());
            this._outputByteBuffer.rewind();
        }
    }
}

