/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.dao.orm;

import aQute.bnd.annotation.ProviderType;
import com.liferay.portal.kernel.cache.key.CacheKeyGenerator;
import com.liferay.portal.kernel.cache.key.CacheKeyGeneratorUtil;
import com.liferay.portal.kernel.dao.orm.FinderCache;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import java.io.Serializable;

@ProviderType
public class FinderPath {
    private static final String _ARGS_SEPARATOR = "_A_";
    private static final String _PARAMS_SEPARATOR = "_P_";
    private final CacheKeyGenerator _cacheKeyGenerator;
    private final String _cacheKeyGeneratorCacheName;
    private String _cacheKeyPrefix;
    private final String _cacheName;
    private final long _columnBitmask;
    private final boolean _entityCacheEnabled;
    private final boolean _finderCacheEnabled;
    private String _localCacheKeyPrefix;
    private final Class<?> _resultClass;

    public FinderPath(boolean entityCacheEnabled, boolean finderCacheEnabled, Class<?> resultClass, String cacheName, String methodName, String[] params) {
        this(entityCacheEnabled, finderCacheEnabled, resultClass, cacheName, methodName, params, -1L);
    }

    public FinderPath(boolean entityCacheEnabled, boolean finderCacheEnabled, Class<?> resultClass, String cacheName, String methodName, String[] params, long columnBitmask) {
        this._entityCacheEnabled = entityCacheEnabled;
        this._finderCacheEnabled = finderCacheEnabled;
        this._resultClass = resultClass;
        this._cacheName = cacheName;
        this._columnBitmask = columnBitmask;
        this._cacheKeyGeneratorCacheName = BaseModel.class.isAssignableFrom(this._resultClass) ? FinderCache.class.getName() + "#BaseModel" : FinderCache.class.getName();
        CacheKeyGenerator cacheKeyGenerator = CacheKeyGeneratorUtil.getCacheKeyGenerator(this._cacheKeyGeneratorCacheName);
        this._cacheKeyGenerator = cacheKeyGenerator.isCallingGetCacheKeyThreadSafe() ? cacheKeyGenerator : null;
        this._initCacheKeyPrefix(methodName, params);
        this._initLocalCacheKeyPrefix();
    }

    public Serializable encodeCacheKey(Object[] arguments) {
        StringBundler sb = new StringBundler(arguments.length * 2 + 1);
        sb.append(this._cacheKeyPrefix);
        for (Object arg : arguments) {
            sb.append(".");
            sb.append(StringUtil.toHexString(arg));
        }
        return this._getCacheKey(sb);
    }

    public Serializable encodeLocalCacheKey(Object[] arguments) {
        StringBundler sb = new StringBundler(arguments.length * 2 + 1);
        sb.append(this._localCacheKeyPrefix);
        for (Object arg : arguments) {
            sb.append(".");
            sb.append(StringUtil.toHexString(arg));
        }
        return this._getCacheKey(sb);
    }

    public String getCacheName() {
        return this._cacheName;
    }

    public long getColumnBitmask() {
        return this._columnBitmask;
    }

    public Class<?> getResultClass() {
        return this._resultClass;
    }

    public boolean isEntityCacheEnabled() {
        return this._entityCacheEnabled;
    }

    public boolean isFinderCacheEnabled() {
        return this._finderCacheEnabled;
    }

    private Serializable _getCacheKey(StringBundler sb) {
        CacheKeyGenerator cacheKeyGenerator = this._cacheKeyGenerator;
        if (cacheKeyGenerator == null) {
            cacheKeyGenerator = CacheKeyGeneratorUtil.getCacheKeyGenerator(this._cacheKeyGeneratorCacheName);
        }
        return cacheKeyGenerator.getCacheKey(sb);
    }

    private void _initCacheKeyPrefix(String methodName, String[] params) {
        StringBundler sb = new StringBundler(params.length * 2 + 3);
        sb.append(methodName);
        sb.append(_PARAMS_SEPARATOR);
        for (String param : params) {
            sb.append(".");
            sb.append(param);
        }
        sb.append(_ARGS_SEPARATOR);
        this._cacheKeyPrefix = sb.toString();
    }

    private void _initLocalCacheKeyPrefix() {
        this._localCacheKeyPrefix = this._cacheName.concat(".").concat(this._cacheKeyPrefix);
    }
}

