/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.document.library.kernel.store;

import com.liferay.document.library.kernel.exception.NoSuchFileException;
import com.liferay.document.library.kernel.store.Store;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.io.unsync.UnsyncByteArrayInputStream;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.FileUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.Validator;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;

public abstract class BaseStore
implements Store {
    private static final Log _log = LogFactoryUtil.getLog(BaseStore.class);

    @Override
    public abstract void addDirectory(long var1, long var3, String var5);

    @Override
    public void addFile(long companyId, long repositoryId, String fileName, byte[] bytes) throws PortalException {
        File file = null;
        try {
            file = FileUtil.createTempFile(bytes);
            this.addFile(companyId, repositoryId, fileName, file);
        }
        catch (IOException ioe) {
            throw new SystemException("Unable to write temporary file", ioe);
        }
        finally {
            FileUtil.delete(file);
        }
    }

    @Override
    public void addFile(long companyId, long repositoryId, String fileName, File file) throws PortalException {
        FileInputStream is = null;
        try {
            is = new FileInputStream(file);
            this.addFile(companyId, repositoryId, fileName, is);
        }
        catch (FileNotFoundException fnfe) {
            throw new SystemException(fnfe);
        }
        finally {
            try {
                if (is != null) {
                    ((InputStream)is).close();
                }
            }
            catch (IOException ioe) {
                _log.error(ioe);
            }
        }
    }

    @Override
    public abstract void addFile(long var1, long var3, String var5, InputStream var6) throws PortalException;

    @Override
    public abstract void checkRoot(long var1);

    @Override
    public void copyFileVersion(long companyId, long repositoryId, String fileName, String fromVersionLabel, String toVersionLabel) throws PortalException {
        InputStream is = this.getFileAsStream(companyId, repositoryId, fileName, fromVersionLabel);
        if (is == null) {
            is = new UnsyncByteArrayInputStream(new byte[0]);
        }
        this.updateFile(companyId, repositoryId, fileName, toVersionLabel, is);
    }

    @Override
    public abstract void deleteDirectory(long var1, long var3, String var5);

    @Override
    public abstract void deleteFile(long var1, long var3, String var5);

    @Override
    public abstract void deleteFile(long var1, long var3, String var5, String var6);

    @Override
    public File getFile(long companyId, long repositoryId, String fileName) throws PortalException {
        return this.getFile(companyId, repositoryId, fileName, "");
    }

    @Override
    public File getFile(long companyId, long repositoryId, String fileName, String versionLabel) throws PortalException {
        throw new UnsupportedOperationException();
    }

    @Override
    public byte[] getFileAsBytes(long companyId, long repositoryId, String fileName) throws PortalException {
        byte[] bytes = null;
        try {
            InputStream is = this.getFileAsStream(companyId, repositoryId, fileName);
            bytes = FileUtil.getBytes(is);
        }
        catch (IOException ioe) {
            throw new SystemException(ioe);
        }
        return bytes;
    }

    @Override
    public byte[] getFileAsBytes(long companyId, long repositoryId, String fileName, String versionLabel) throws PortalException {
        byte[] bytes = null;
        try {
            InputStream is = this.getFileAsStream(companyId, repositoryId, fileName, versionLabel);
            bytes = FileUtil.getBytes(is);
        }
        catch (IOException ioe) {
            throw new SystemException(ioe);
        }
        return bytes;
    }

    @Override
    public InputStream getFileAsStream(long companyId, long repositoryId, String fileName) throws PortalException {
        return this.getFileAsStream(companyId, repositoryId, fileName, "");
    }

    @Override
    public abstract InputStream getFileAsStream(long var1, long var3, String var5, String var6) throws PortalException;

    @Override
    public abstract String[] getFileNames(long var1, long var3, String var5);

    @Override
    public abstract long getFileSize(long var1, long var3, String var5) throws PortalException;

    @Override
    public abstract boolean hasDirectory(long var1, long var3, String var5);

    @Override
    public boolean hasFile(long companyId, long repositoryId, String fileName) {
        return this.hasFile(companyId, repositoryId, fileName, "1.0");
    }

    @Override
    public abstract boolean hasFile(long var1, long var3, String var5, String var6);

    @Override
    public void move(String srcDir, String destDir) {
    }

    @Override
    public abstract void updateFile(long var1, long var3, long var5, String var7) throws PortalException;

    @Override
    public void updateFile(long companyId, long repositoryId, String fileName, String versionLabel, byte[] bytes) throws PortalException {
        File file = null;
        try {
            file = FileUtil.createTempFile(bytes);
            this.updateFile(companyId, repositoryId, fileName, versionLabel, file);
        }
        catch (IOException ioe) {
            throw new SystemException("Unable to write temporary file", ioe);
        }
        finally {
            FileUtil.delete(file);
        }
    }

    @Override
    public void updateFile(long companyId, long repositoryId, String fileName, String versionLabel, File file) throws PortalException {
        FileInputStream is = null;
        try {
            is = new FileInputStream(file);
            this.updateFile(companyId, repositoryId, fileName, versionLabel, is);
        }
        catch (FileNotFoundException fnfe) {
            throw new NoSuchFileException(companyId, repositoryId, fileName, versionLabel, fnfe);
        }
        finally {
            try {
                if (is != null) {
                    ((InputStream)is).close();
                }
            }
            catch (IOException ioe) {
                _log.error(ioe);
            }
        }
    }

    @Override
    public abstract void updateFile(long var1, long var3, String var5, String var6, InputStream var7) throws PortalException;

    @Override
    public void updateFileVersion(long companyId, long repositoryId, String fileName, String fromVersionLabel, String toVersionLabel) throws PortalException {
        InputStream is = this.getFileAsStream(companyId, repositoryId, fileName, fromVersionLabel);
        if (is == null) {
            is = new UnsyncByteArrayInputStream(new byte[0]);
        }
        this.updateFile(companyId, repositoryId, fileName, toVersionLabel, is);
        this.deleteFile(companyId, repositoryId, fileName, fromVersionLabel);
    }

    protected void logFailedDeletion(long companyId, long repositoryId, String fileName) {
        this.logFailedDeletion(companyId, repositoryId, fileName, null, null);
    }

    protected void logFailedDeletion(long companyId, long repositoryId, String fileName, Exception exception) {
        this.logFailedDeletion(companyId, repositoryId, fileName, null, exception);
    }

    protected void logFailedDeletion(long companyId, long repositoryId, String fileName, String versionLabel) {
        this.logFailedDeletion(companyId, repositoryId, fileName, versionLabel, null);
    }

    protected void logFailedDeletion(long companyId, long repositoryId, String fileName, String versionLabel, Exception cause) {
        if (_log.isWarnEnabled() && cause != null || _log.isDebugEnabled() && cause == null) {
            StringBundler sb = new StringBundler(9);
            sb.append("Unable to delete file {companyId=");
            sb.append(companyId);
            sb.append(", repositoryId=");
            sb.append(repositoryId);
            sb.append(", fileName=");
            sb.append(fileName);
            if (Validator.isNotNull(versionLabel)) {
                sb.append(", versionLabel=");
                sb.append(versionLabel);
            }
            sb.append("} because it does not exist");
            if (_log.isWarnEnabled() && cause != null) {
                _log.warn(sb.toString(), cause);
            }
            if (_log.isDebugEnabled() && cause == null) {
                _log.debug(sb.toString());
            }
        }
    }
}

