/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.upgrade.v6_0_2;

import com.liferay.portal.kernel.upgrade.UpgradeProcess;
import com.liferay.portal.kernel.util.LoggingTimer;
import com.liferay.portal.kernel.util.StringUtil;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class UpgradeNestedPortlets
extends UpgradeProcess {
    private static final String _GET_LAYOUT = "select plid, typeSettings from Layout where typeSettings like '%nested-column-ids=com_liferay_nested_portlets_web_portlet_NestedPortletsPortlet_INSTANCE_%'";
    private static final String _INSTANCE_SEPARATOR = "_INSTANCE_";
    private static final int _UNDERLINE_COUNT = StringUtil.count((String)"_INSTANCE_", (String)"_") + 1;
    private static final Pattern _pattern = Pattern.compile("(com_liferay_nested_portlets_web_portlet_NestedPortletsPortlet_INSTANCE_[^_,\\s=]+_)([^_,\\s=]+)");

    protected void doUpgrade() throws Exception {
        this.updateLayouts();
    }

    protected void updateLayout(long plid, String typeSettings) throws Exception {
        try (PreparedStatement ps = this.connection.prepareStatement("update Layout set typeSettings = ? where plid = " + plid);){
            ps.setString(1, typeSettings);
            ps.executeUpdate();
        }
    }

    protected void updateLayouts() throws Exception {
        try (LoggingTimer loggingTimer = new LoggingTimer();
             PreparedStatement ps = this.connection.prepareStatement(_GET_LAYOUT);
             ResultSet rs = ps.executeQuery();){
            while (rs.next()) {
                String typeSettings;
                long plid = rs.getLong("plid");
                String newTypeSettings = typeSettings = rs.getString("typeSettings");
                Matcher matcher = _pattern.matcher(typeSettings);
                while (matcher.find()) {
                    String nestedColumnIds = matcher.group();
                    int underlineCount = StringUtil.count((String)nestedColumnIds, (String)"_");
                    if (underlineCount != _UNDERLINE_COUNT) continue;
                    String newNestedColumnIds = "_" + matcher.group(1) + "_" + matcher.group(2);
                    newTypeSettings = StringUtil.replace((String)newTypeSettings, (String)nestedColumnIds, (String)newNestedColumnIds);
                }
                if (newTypeSettings.equals(typeSettings)) continue;
                this.updateLayout(plid, newTypeSettings);
            }
        }
    }
}

