/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.upgrade.v6_0_2;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.upgrade.UpgradeProcess;
import com.liferay.portal.kernel.util.LoggingTimer;
import com.liferay.portal.kernel.util.PortalUtil;
import java.sql.PreparedStatement;
import java.sql.ResultSet;

public class UpgradeExpando
extends UpgradeProcess {
    private static final Log _log = LogFactoryUtil.getLog(UpgradeExpando.class);

    protected void addRow(long rowId, long companyId, long tableId, long classPK) throws Exception {
        try (PreparedStatement ps = this.connection.prepareStatement("insert into ExpandoRow (rowId_, companyId, tableId, classPK) values (?, ?, ?, ?)");){
            ps.setLong(1, rowId);
            ps.setLong(2, companyId);
            ps.setLong(3, tableId);
            ps.setLong(4, classPK);
            ps.executeUpdate();
        }
    }

    protected void addValue(long valueId, long companyId, long tableId, long columnId, long rowId, long classNameId, long classPK, String data) throws Exception {
        try (PreparedStatement ps = this.connection.prepareStatement("insert into ExpandoValue (valueId, companyId, tableId, columnId, rowId_, classNameId, classPK, data_) values (?, ?, ?, ?, ?, ?, ?, ?)");){
            ps.setLong(1, valueId);
            ps.setLong(2, companyId);
            ps.setLong(3, tableId);
            ps.setLong(4, columnId);
            ps.setLong(5, rowId);
            ps.setLong(6, classNameId);
            ps.setLong(7, classPK);
            ps.setString(8, data);
            ps.executeUpdate();
        }
    }

    protected void doUpgrade() throws Exception {
        this.updateTables("com.liferay.portlet.journal.model.JournalArticle", "JournalArticle", "id_");
        this.updateTables("com.liferay.wiki.model.WikiPage", "WikiPage", "pageId");
    }

    /*
     * Exception decompiling
     */
    protected boolean hasRow(long companyId, long tableId, long classPK) throws Exception {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    protected boolean hasValue(long companyId, long tableId, long columnId, long rowId) throws Exception {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    protected void updateRow(long companyId, long classPK, String tableName, long tableId, String columnName, long rowId) throws Exception {
        try (PreparedStatement ps = this.connection.prepareStatement("select " + columnName + " from " + tableName + " where " + "resourcePrimKey = ?");){
            ps.setLong(1, classPK);
            try (ResultSet rs = ps.executeQuery();){
                boolean delete = false;
                while (rs.next()) {
                    long newClassPK = rs.getLong(columnName);
                    delete = true;
                    if (this.hasRow(companyId, tableId, newClassPK)) continue;
                    long newRowId = this.increment();
                    this.addRow(newRowId, companyId, tableId, newClassPK);
                    this.updateValues(classPK, newClassPK, tableId, rowId, newRowId);
                }
                if (delete) {
                    this.runSQL("delete from ExpandoRow where rowId_ = " + rowId);
                    this.runSQL("delete from ExpandoValue where rowId_ = " + rowId);
                }
            }
        }
    }

    protected void updateRows(String tableName, long tableId, String columnName) throws Exception {
        try (PreparedStatement ps = this.connection.prepareStatement("select * from ExpandoRow where tableId = ?");){
            ps.setLong(1, tableId);
            try (ResultSet rs = ps.executeQuery();){
                while (rs.next()) {
                    long rowId = rs.getLong("rowId_");
                    long companyId = rs.getLong("companyId");
                    long classPK = rs.getLong("classPK");
                    this.updateRow(companyId, classPK, tableName, tableId, columnName, rowId);
                }
            }
        }
    }

    protected void updateTables(String className, String tableName, String columnName) throws Exception {
        try (LoggingTimer loggingTimer = new LoggingTimer(className);){
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("Upgrading " + tableName));
            }
            long classNameId = PortalUtil.getClassNameId((String)className);
            try (PreparedStatement ps = this.connection.prepareStatement("select * from ExpandoTable where classNameId = ? and name = ?");){
                ps.setLong(1, classNameId);
                ps.setString(2, "CUSTOM_FIELDS");
                try (ResultSet rs = ps.executeQuery();){
                    while (rs.next()) {
                        long tableId = rs.getLong("tableId");
                        this.updateRows(tableName, tableId, columnName);
                    }
                }
            }
        }
    }

    protected void updateValues(long classPK, long newClassPK, long tableId, long rowId, long newRowId) throws Exception {
        try (PreparedStatement ps = this.connection.prepareStatement("select * from ExpandoValue where tableId = ? and rowId_ = ? and classPK = ?");){
            ps.setLong(1, tableId);
            ps.setLong(2, rowId);
            ps.setLong(3, classPK);
            try (ResultSet rs = ps.executeQuery();){
                while (rs.next()) {
                    long companyId = rs.getLong("companyId");
                    long columnId = rs.getLong("columnId");
                    long classNameId = rs.getLong("classNameId");
                    String data = rs.getString("data_");
                    if (this.hasValue(companyId, tableId, columnId, newRowId)) continue;
                    long newValueId = this.increment();
                    this.addValue(newValueId, companyId, tableId, columnId, newRowId, classNameId, newClassPK, data);
                }
            }
        }
    }
}

