/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.service.impl;

import com.liferay.asset.kernel.AssetRendererFactoryRegistryUtil;
import com.liferay.asset.kernel.model.AssetRendererFactory;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.jsonwebservice.JSONWebService;
import com.liferay.portal.kernel.jsonwebservice.JSONWebServiceMode;
import com.liferay.portal.kernel.model.AuditedModel;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.GroupedModel;
import com.liferay.portal.kernel.model.PermissionedModel;
import com.liferay.portal.kernel.model.ResourcePermission;
import com.liferay.portal.kernel.model.Role;
import com.liferay.portal.kernel.model.Team;
import com.liferay.portal.kernel.security.auth.PrincipalException;
import com.liferay.portal.kernel.security.permission.BaseModelPermissionChecker;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.security.permission.ResourceActionsUtil;
import com.liferay.portal.kernel.service.permission.PortletPermissionUtil;
import com.liferay.portal.kernel.service.permission.TeamPermissionUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.service.base.PermissionServiceBaseImpl;
import com.liferay.registry.Filter;
import com.liferay.registry.Registry;
import com.liferay.registry.RegistryUtil;
import com.liferay.registry.ServiceReference;
import com.liferay.registry.ServiceTracker;
import com.liferay.registry.ServiceTrackerCustomizer;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class PermissionServiceImpl
extends PermissionServiceBaseImpl {
    private final Map<String, BaseModelPermissionChecker> _baseModelPermissionCheckers = new ConcurrentHashMap<String, BaseModelPermissionChecker>();
    private ServiceTracker<BaseModelPermissionChecker, BaseModelPermissionChecker> _serviceTracker;

    @Override
    public void afterPropertiesSet() {
        Registry registry = RegistryUtil.getRegistry();
        Filter filter = registry.getFilter("(&(model.class.name=*)(objectClass=" + BaseModelPermissionChecker.class.getName() + "))");
        this._serviceTracker = registry.trackServices(filter, (ServiceTrackerCustomizer)new BaseModelPermissionCheckerServiceTrackerCustomizer());
        this._serviceTracker.open();
    }

    @JSONWebService(mode=JSONWebServiceMode.IGNORE)
    public void checkPermission(long groupId, String name, long primKey) throws PortalException {
        this.checkPermission(this.getPermissionChecker(), groupId, name, String.valueOf(primKey));
    }

    public void checkPermission(long groupId, String name, String primKey) throws PortalException {
        this.checkPermission(this.getPermissionChecker(), groupId, name, primKey);
    }

    protected boolean checkBaseModelPermission(PermissionChecker permissionChecker, long groupId, String className, long classPK) throws PortalException {
        BaseModelPermissionChecker baseModelPermissionChecker;
        String actionId = "PERMISSIONS";
        if (className.equals(Team.class.getName())) {
            className = Group.class.getName();
            Team team = this.teamLocalService.fetchTeam(classPK);
            classPK = team.getGroupId();
            actionId = "MANAGE_TEAMS";
        }
        if ((baseModelPermissionChecker = this._baseModelPermissionCheckers.get(className)) != null) {
            baseModelPermissionChecker.checkBaseModel(permissionChecker, groupId, classPK, actionId);
            return true;
        }
        return false;
    }

    protected void checkPermission(PermissionChecker permissionChecker, long groupId, String name, String primKey) throws PortalException {
        if (this.checkBaseModelPermission(permissionChecker, groupId, name, GetterUtil.getLong((String)primKey))) {
            return;
        }
        if (primKey != null && primKey.contains("_LAYOUT_")) {
            int pos = primKey.indexOf("_LAYOUT_");
            long plid = GetterUtil.getLong((String)primKey.substring(0, pos));
            String portletId = primKey.substring(pos + "_LAYOUT_".length());
            PortletPermissionUtil.check((PermissionChecker)permissionChecker, (long)plid, (String)portletId, (String)"CONFIGURATION");
        } else if (!permissionChecker.hasPermission(groupId, name, primKey, "PERMISSIONS")) {
            AssetRendererFactory assetRendererFactory = AssetRendererFactoryRegistryUtil.getAssetRendererFactoryByClassName((String)name);
            if (assetRendererFactory != null) {
                try {
                    if (assetRendererFactory.hasPermission(permissionChecker, GetterUtil.getLong((String)primKey), "PERMISSIONS")) {
                        return;
                    }
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            long ownerId = 0L;
            if (this.resourceBlockLocalService.isSupported(name)) {
                PermissionedModel permissionedModel = this.resourceBlockLocalService.getPermissionedModel(name, GetterUtil.getLong((String)primKey));
                if (permissionedModel instanceof GroupedModel) {
                    GroupedModel groupedModel = (GroupedModel)permissionedModel;
                    ownerId = groupedModel.getUserId();
                } else if (permissionedModel instanceof AuditedModel) {
                    AuditedModel auditedModel = (AuditedModel)permissionedModel;
                    ownerId = auditedModel.getUserId();
                }
            } else {
                ResourcePermission resourcePermission = this.resourcePermissionLocalService.getResourcePermission(permissionChecker.getCompanyId(), name, 4, primKey, permissionChecker.getOwnerRoleId());
                ownerId = resourcePermission.getOwnerId();
            }
            if (permissionChecker.hasOwnerPermission(permissionChecker.getCompanyId(), name, primKey, ownerId, "PERMISSIONS")) {
                return;
            }
            Role role = null;
            if (name.equals(Role.class.getName())) {
                long roleId = GetterUtil.getLong((String)primKey);
                role = this.rolePersistence.findByPrimaryKey(roleId);
            }
            if (role != null && role.isTeam()) {
                Team team = this.teamPersistence.findByPrimaryKey(role.getClassPK());
                TeamPermissionUtil.check((PermissionChecker)permissionChecker, (Team)team, (String)"PERMISSIONS");
            } else {
                List resourceActions = ResourceActionsUtil.getResourceActions((String)name);
                if (!resourceActions.contains("DEFINE_PERMISSIONS") || !permissionChecker.hasPermission(groupId, name, primKey, "DEFINE_PERMISSIONS")) {
                    throw new PrincipalException.MustHavePermission(permissionChecker, name, Long.valueOf(primKey).longValue(), new String[]{"DEFINE_PERMISSIONS"});
                }
            }
        }
    }

    private class BaseModelPermissionCheckerServiceTrackerCustomizer
    implements ServiceTrackerCustomizer<BaseModelPermissionChecker, BaseModelPermissionChecker> {
        private BaseModelPermissionCheckerServiceTrackerCustomizer() {
        }

        public BaseModelPermissionChecker addingService(ServiceReference<BaseModelPermissionChecker> serviceReference) {
            Registry registry = RegistryUtil.getRegistry();
            BaseModelPermissionChecker baseModelPermissionChecker = (BaseModelPermissionChecker)registry.getService(serviceReference);
            String modelClassName = GetterUtil.getString((Object)serviceReference.getProperty("model.class.name"));
            PermissionServiceImpl.this._baseModelPermissionCheckers.put(modelClassName, baseModelPermissionChecker);
            return baseModelPermissionChecker;
        }

        public void modifiedService(ServiceReference<BaseModelPermissionChecker> serviceReference, BaseModelPermissionChecker baseModelPermissionChecker) {
        }

        public void removedService(ServiceReference<BaseModelPermissionChecker> serviceReference, BaseModelPermissionChecker baseModelPermissionChecker) {
            Registry registry = RegistryUtil.getRegistry();
            registry.ungetService(serviceReference);
            String modelClassName = GetterUtil.getString((Object)serviceReference.getProperty("model.class.name"));
            PermissionServiceImpl.this._baseModelPermissionCheckers.remove(modelClassName);
        }
    }
}

