/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.service.impl;

import com.liferay.portal.kernel.exception.AddressCityException;
import com.liferay.portal.kernel.exception.AddressStreetException;
import com.liferay.portal.kernel.exception.AddressZipException;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.Account;
import com.liferay.portal.kernel.model.Address;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.Contact;
import com.liferay.portal.kernel.model.Country;
import com.liferay.portal.kernel.model.Organization;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.systemevent.SystemEvent;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.service.base.AddressLocalServiceBaseImpl;
import java.util.List;

public class AddressLocalServiceImpl
extends AddressLocalServiceBaseImpl {
    public Address addAddress(long userId, String className, long classPK, String street1, String street2, String street3, String city, String zip, long regionId, long countryId, long typeId, boolean mailing, boolean primary, ServiceContext serviceContext) throws PortalException {
        User user = this.userPersistence.findByPrimaryKey(userId);
        long classNameId = this.classNameLocalService.getClassNameId(className);
        this.validate(0L, user.getCompanyId(), classNameId, classPK, street1, city, zip, regionId, countryId, typeId, mailing, primary);
        long addressId = this.counterLocalService.increment();
        Address address = this.addressPersistence.create(addressId);
        address.setUuid(serviceContext.getUuid());
        address.setCompanyId(user.getCompanyId());
        address.setUserId(user.getUserId());
        address.setUserName(user.getFullName());
        address.setClassNameId(classNameId);
        address.setClassPK(classPK);
        address.setStreet1(street1);
        address.setStreet2(street2);
        address.setStreet3(street3);
        address.setCity(city);
        address.setZip(zip);
        address.setRegionId(regionId);
        address.setCountryId(countryId);
        address.setTypeId(typeId);
        address.setMailing(mailing);
        address.setPrimary(primary);
        this.addressPersistence.update((BaseModel)address);
        return address;
    }

    @Override
    @SystemEvent(action=1, type=1)
    public Address deleteAddress(Address address) {
        this.addressPersistence.remove((BaseModel)address);
        return address;
    }

    @Override
    public Address deleteAddress(long addressId) throws PortalException {
        Address address = this.addressPersistence.findByPrimaryKey(addressId);
        return this.addressLocalService.deleteAddress(address);
    }

    public void deleteAddresses(long companyId, String className, long classPK) {
        long classNameId = this.classNameLocalService.getClassNameId(className);
        List addresses = this.addressPersistence.findByC_C_C(companyId, classNameId, classPK);
        for (Address address : addresses) {
            this.addressLocalService.deleteAddress(address);
        }
    }

    public List<Address> getAddresses() {
        return this.addressPersistence.findAll();
    }

    public List<Address> getAddresses(long companyId, String className, long classPK) {
        long classNameId = this.classNameLocalService.getClassNameId(className);
        return this.addressPersistence.findByC_C_C(companyId, classNameId, classPK);
    }

    public Address updateAddress(long addressId, String street1, String street2, String street3, String city, String zip, long regionId, long countryId, long typeId, boolean mailing, boolean primary) throws PortalException {
        this.validate(addressId, 0L, 0L, 0L, street1, city, zip, regionId, countryId, typeId, mailing, primary);
        Address address = this.addressPersistence.findByPrimaryKey(addressId);
        address.setStreet1(street1);
        address.setStreet2(street2);
        address.setStreet3(street3);
        address.setCity(city);
        address.setZip(zip);
        address.setRegionId(regionId);
        address.setCountryId(countryId);
        address.setTypeId(typeId);
        address.setMailing(mailing);
        address.setPrimary(primary);
        this.addressPersistence.update((BaseModel)address);
        return address;
    }

    protected void validate(long addressId, long companyId, long classNameId, long classPK, boolean mailing, boolean primary) {
        List addresses;
        if (mailing) {
            addresses = this.addressPersistence.findByC_C_C_M(companyId, classNameId, classPK, mailing);
            for (Address address : addresses) {
                if (addressId > 0L && address.getAddressId() == addressId) continue;
                address.setMailing(false);
                this.addressPersistence.update((BaseModel)address);
            }
        }
        if (primary) {
            addresses = this.addressPersistence.findByC_C_C_P(companyId, classNameId, classPK, primary);
            for (Address address : addresses) {
                if (addressId > 0L && address.getAddressId() == addressId) continue;
                address.setPrimary(false);
                this.addressPersistence.update((BaseModel)address);
            }
        }
    }

    protected void validate(long addressId, long companyId, long classNameId, long classPK, String street1, String city, String zip, long regionId, long countryId, long typeId, boolean mailing, boolean primary) throws PortalException {
        Country country;
        if (Validator.isNull((String)street1)) {
            throw new AddressStreetException();
        }
        if (Validator.isNull((String)city)) {
            throw new AddressCityException();
        }
        if (Validator.isNull((String)zip) && (country = this.countryPersistence.fetchByPrimaryKey(countryId)) != null && country.isZipRequired()) {
            throw new AddressZipException();
        }
        if (addressId > 0L) {
            Address address = this.addressPersistence.findByPrimaryKey(addressId);
            companyId = address.getCompanyId();
            classNameId = address.getClassNameId();
            classPK = address.getClassPK();
        }
        if (classNameId == this.classNameLocalService.getClassNameId(Account.class) || classNameId == this.classNameLocalService.getClassNameId(Contact.class) || classNameId == this.classNameLocalService.getClassNameId(Organization.class)) {
            this.listTypeLocalService.validate(typeId, classNameId, ".address");
        }
        this.validate(addressId, companyId, classNameId, classPK, mailing, primary);
    }
}

