/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.repository.registry;

import com.liferay.portal.kernel.cache.CacheRegistryItem;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.repository.RepositoryFactory;
import com.liferay.portal.kernel.repository.registry.RepositoryDefiner;
import com.liferay.portal.kernel.util.PortalClassLoaderUtil;
import com.liferay.portal.kernel.util.ResourceBundleLoader;
import com.liferay.portal.repository.external.LegacyExternalRepositoryDefiner;
import com.liferay.portal.repository.registry.RepositoryClassDefinition;
import com.liferay.portal.repository.registry.RepositoryClassDefinitionCatalog;
import com.liferay.portal.repository.util.ExternalRepositoryFactory;
import com.liferay.portal.repository.util.ExternalRepositoryFactoryImpl;
import com.liferay.portal.repository.util.ExternalRepositoryFactoryUtil;
import com.liferay.portal.util.PropsValues;
import com.liferay.registry.Registry;
import com.liferay.registry.RegistryUtil;
import com.liferay.registry.ServiceReference;
import com.liferay.registry.ServiceRegistration;
import com.liferay.registry.ServiceTracker;
import com.liferay.registry.ServiceTrackerCustomizer;
import com.liferay.registry.collections.StringServiceRegistrationMap;
import com.liferay.registry.collections.StringServiceRegistrationMapImpl;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class RepositoryClassDefinitionCatalogImpl
implements CacheRegistryItem,
RepositoryClassDefinitionCatalog {
    private final Map<String, RepositoryClassDefinition> _externalRepositoryClassDefinitions = new ConcurrentHashMap<String, RepositoryClassDefinition>();
    private RepositoryFactory _legacyExternalRepositoryFactory;
    private final Map<String, RepositoryClassDefinition> _repositoryClassDefinitions = new ConcurrentHashMap<String, RepositoryClassDefinition>();
    private List<RepositoryDefiner> _repositoryDefiners;
    private final StringServiceRegistrationMap<RepositoryDefiner> _serviceRegistrations = new StringServiceRegistrationMapImpl();
    private ServiceTracker<RepositoryDefiner, RepositoryDefiner> _serviceTracker;

    @Override
    public Iterable<RepositoryClassDefinition> getExternalRepositoryClassDefinitions() {
        return this._externalRepositoryClassDefinitions.values();
    }

    @Override
    public Collection<String> getExternalRepositoryClassNames() {
        return this._externalRepositoryClassDefinitions.keySet();
    }

    public String getRegistryName() {
        Class<?> clazz = this.getClass();
        return clazz.getName();
    }

    @Override
    public RepositoryClassDefinition getRepositoryClassDefinition(String className) {
        return this._repositoryClassDefinitions.get(className);
    }

    public void invalidate() {
        for (RepositoryClassDefinition repositoryClassDefinition : this._repositoryClassDefinitions.values()) {
            repositoryClassDefinition.invalidateCache();
        }
    }

    public void loadDefaultRepositoryDefiners() {
        Registry registry = RegistryUtil.getRegistry();
        this._serviceTracker = registry.trackServices(RepositoryDefiner.class, (ServiceTrackerCustomizer)new RepositoryDefinerServiceTrackerCustomizer());
        this._serviceTracker.open();
        for (RepositoryDefiner repositoryDefiner : this._repositoryDefiners) {
            this.registerRepositoryDefiner(repositoryDefiner);
        }
        ClassLoader classLoader = PortalClassLoaderUtil.getClassLoader();
        for (String className : PropsValues.DL_REPOSITORY_IMPL) {
            ExternalRepositoryFactoryImpl externalRepositoryFactory = new ExternalRepositoryFactoryImpl(className, classLoader);
            this.registerLegacyExternalRepositoryFactory(className, externalRepositoryFactory, LanguageUtil.getPortalResourceBundleLoader());
        }
    }

    @Override
    public void registerLegacyExternalRepositoryFactory(String className, ExternalRepositoryFactory externalRepositoryFactory, ResourceBundleLoader resourceBundleLoader) {
        ExternalRepositoryFactoryUtil.registerExternalRepositoryFactory(className, externalRepositoryFactory);
        LegacyExternalRepositoryDefiner repositoryDefiner = new LegacyExternalRepositoryDefiner(className, this._legacyExternalRepositoryFactory, resourceBundleLoader);
        ServiceRegistration<RepositoryDefiner> serviceRegistration = this.registerRepositoryDefiner((RepositoryDefiner)repositoryDefiner);
        this._serviceRegistrations.put((Object)className, serviceRegistration);
    }

    public void setLegacyExternalRepositoryFactory(RepositoryFactory legacyExternalRepositoryFactory) {
        this._legacyExternalRepositoryFactory = legacyExternalRepositoryFactory;
    }

    public void setRepositoryDefiners(List<RepositoryDefiner> repositoryDefiners) {
        this._repositoryDefiners = repositoryDefiners;
    }

    @Override
    public void unregisterLegacyExternalRepositoryFactory(String className) {
        ExternalRepositoryFactoryUtil.unregisterExternalRepositoryFactory(className);
        ServiceRegistration serviceRegistration = (ServiceRegistration)this._serviceRegistrations.remove((Object)className);
        serviceRegistration.unregister();
        this.unregisterRepositoryDefiner(className);
    }

    protected ServiceRegistration<RepositoryDefiner> registerRepositoryDefiner(RepositoryDefiner repositoryDefiner) {
        Registry registry = RegistryUtil.getRegistry();
        return registry.registerService(RepositoryDefiner.class, (Object)repositoryDefiner);
    }

    protected void unregisterRepositoryDefiner(String className) {
        this._externalRepositoryClassDefinitions.remove(className);
        this._repositoryClassDefinitions.remove(className);
    }

    private class RepositoryDefinerServiceTrackerCustomizer
    implements ServiceTrackerCustomizer<RepositoryDefiner, RepositoryDefiner> {
        private RepositoryDefinerServiceTrackerCustomizer() {
        }

        public RepositoryDefiner addingService(ServiceReference<RepositoryDefiner> serviceReference) {
            Registry registry = RegistryUtil.getRegistry();
            RepositoryDefiner repositoryDefiner = (RepositoryDefiner)registry.getService(serviceReference);
            String className = repositoryDefiner.getClassName();
            RepositoryClassDefinition repositoryClassDefinition = RepositoryClassDefinition.fromRepositoryDefiner(repositoryDefiner);
            if (repositoryDefiner.isExternalRepository()) {
                RepositoryClassDefinitionCatalogImpl.this._externalRepositoryClassDefinitions.put(className, repositoryClassDefinition);
            }
            RepositoryClassDefinitionCatalogImpl.this._repositoryClassDefinitions.put(className, repositoryClassDefinition);
            return repositoryDefiner;
        }

        public void modifiedService(ServiceReference<RepositoryDefiner> serviceReference, RepositoryDefiner repositoryDefiner) {
            String className = repositoryDefiner.getClassName();
            RepositoryClassDefinition repositoryClassDefinition = RepositoryClassDefinition.fromRepositoryDefiner(repositoryDefiner);
            if (repositoryDefiner.isExternalRepository()) {
                RepositoryClassDefinitionCatalogImpl.this._externalRepositoryClassDefinitions.put(className, repositoryClassDefinition);
            } else {
                RepositoryClassDefinitionCatalogImpl.this._externalRepositoryClassDefinitions.remove(className);
            }
            RepositoryClassDefinitionCatalogImpl.this._repositoryClassDefinitions.put(className, repositoryClassDefinition);
        }

        public void removedService(ServiceReference<RepositoryDefiner> serviceReference, RepositoryDefiner repositoryDefiner) {
            RepositoryClassDefinitionCatalogImpl.this.unregisterRepositoryDefiner(repositoryDefiner.getClassName());
        }
    }
}

