/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.action;

import com.liferay.portal.kernel.audit.AuditMessage;
import com.liferay.portal.kernel.audit.AuditRouterUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Layout;
import com.liferay.portal.kernel.model.Portlet;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.portlet.LiferayPortletURL;
import com.liferay.portal.kernel.portlet.PortletContainerUtil;
import com.liferay.portal.kernel.portlet.PortletURLFactoryUtil;
import com.liferay.portal.kernel.service.PortletLocalServiceUtil;
import com.liferay.portal.kernel.servlet.MetaInfoCacheServletResponse;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.HttpUtil;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.ServerDetector;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.security.sso.SSOUtil;
import com.liferay.portal.util.PropsValues;
import com.liferay.portlet.PortletRequestImpl;
import com.liferay.portlet.RenderParametersPool;
import javax.portlet.PortletMode;
import javax.portlet.PortletRequest;
import javax.portlet.WindowState;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.struts.action.Action;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;

public class LayoutAction
extends Action {
    private static final Log _log = LogFactoryUtil.getLog(LayoutAction.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ActionForward execute(ActionMapping actionMapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) throws Exception {
        MetaInfoCacheServletResponse metaInfoCacheServletResponse = new MetaInfoCacheServletResponse(response);
        try {
            ActionForward actionForward = this.doExecute(actionMapping, actionForm, request, (HttpServletResponse)metaInfoCacheServletResponse);
            return actionForward;
        }
        finally {
            metaInfoCacheServletResponse.finishResponse(false);
        }
    }

    protected ActionForward doExecute(ActionMapping actionMapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ThemeDisplay themeDisplay = (ThemeDisplay)request.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        Boolean layoutDefault = (Boolean)request.getAttribute("LAYOUT_DEFAULT");
        if (Boolean.TRUE.equals(layoutDefault)) {
            Layout requestedLayout = (Layout)request.getAttribute("REQUESTED_LAYOUT");
            if (requestedLayout != null) {
                String authLoginURL;
                String redirectParam = "redirect";
                if (Validator.isNotNull((String)PropsValues.AUTH_LOGIN_PORTLET_NAME)) {
                    String portletNamespace = PortalUtil.getPortletNamespace((String)PropsValues.AUTH_LOGIN_PORTLET_NAME);
                    redirectParam = portletNamespace + redirectParam;
                }
                if (Validator.isNull((String)(authLoginURL = SSOUtil.getSignInURL(themeDisplay.getCompanyId(), themeDisplay.getURLSignIn())))) {
                    authLoginURL = PortalUtil.getSiteLoginURL((ThemeDisplay)themeDisplay);
                }
                if (Validator.isNull((String)authLoginURL)) {
                    authLoginURL = PropsValues.AUTH_LOGIN_URL;
                }
                if (Validator.isNull((String)authLoginURL)) {
                    LiferayPortletURL loginURL = PortletURLFactoryUtil.create((HttpServletRequest)request, (String)"com_liferay_login_web_portlet_LoginPortlet", (long)themeDisplay.getPlid(), (String)"RENDER_PHASE");
                    loginURL.setParameter("saveLastPath", Boolean.FALSE.toString());
                    loginURL.setParameter("mvcRenderCommandName", "/login/login");
                    loginURL.setPortletMode(PortletMode.VIEW);
                    loginURL.setWindowState(WindowState.MAXIMIZED);
                    authLoginURL = loginURL.toString();
                }
                authLoginURL = HttpUtil.setParameter((String)authLoginURL, (String)"p_p_id", (String)PropsValues.AUTH_LOGIN_PORTLET_NAME);
                String currentURL = PortalUtil.getCurrentURL((HttpServletRequest)request);
                authLoginURL = HttpUtil.setParameter((String)authLoginURL, (String)redirectParam, (String)currentURL);
                if (_log.isDebugEnabled()) {
                    _log.debug((Object)("Redirect requested layout to " + authLoginURL));
                }
                response.sendRedirect(authLoginURL);
            } else {
                Layout layout = themeDisplay.getLayout();
                String redirect = PortalUtil.getLayoutURL((Layout)layout, (ThemeDisplay)themeDisplay);
                if (_log.isDebugEnabled()) {
                    _log.debug((Object)("Redirect default layout to " + redirect));
                }
                response.sendRedirect(redirect);
            }
            return null;
        }
        long plid = ParamUtil.getLong((HttpServletRequest)request, (String)"p_l_id");
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("p_l_id is " + plid));
        }
        if (plid > 0L) {
            Layout layout = themeDisplay.getLayout();
            if (layout != null) {
                plid = layout.getPlid();
            }
            ActionForward actionForward = this.processLayout(actionMapping, request, response, plid);
            return actionForward;
        }
        try {
            this.forwardLayout(request);
            return actionMapping.findForward("/common/forward_jsp.jsp");
        }
        catch (Exception e) {
            PortalUtil.sendError((Exception)e, (HttpServletRequest)request, (HttpServletResponse)response);
            return null;
        }
    }

    protected void forwardLayout(HttpServletRequest request) throws Exception {
        String forwardURL;
        Layout layout = (Layout)request.getAttribute("LAYOUT");
        long plid = 0L;
        String layoutFriendlyURL = null;
        ThemeDisplay themeDisplay = (ThemeDisplay)request.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        if (layout != null) {
            plid = layout.getPlid();
            layoutFriendlyURL = PortalUtil.getLayoutFriendlyURL((Layout)layout, (ThemeDisplay)themeDisplay);
        }
        if (Validator.isNull(forwardURL = layoutFriendlyURL)) {
            forwardURL = themeDisplay.getPathMain() + "/portal/layout?p_l_id=" + plid;
        }
        if (Validator.isNotNull((String)themeDisplay.getDoAsUserId())) {
            forwardURL = HttpUtil.addParameter((String)forwardURL, (String)"doAsUserId", (String)themeDisplay.getDoAsUserId());
        }
        if (Validator.isNotNull((String)themeDisplay.getDoAsUserLanguageId())) {
            forwardURL = HttpUtil.addParameter((String)forwardURL, (String)"doAsUserLanguageId", (String)themeDisplay.getDoAsUserLanguageId());
        }
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Forward layout to " + forwardURL));
        }
        request.setAttribute("FORWARD_URL", (Object)forwardURL);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ActionForward processLayout(ActionMapping actionMapping, HttpServletRequest request, HttpServletResponse response, long plid) throws Exception {
        HttpSession session = request.getSession();
        ThemeDisplay themeDisplay = (ThemeDisplay)request.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        try {
            Layout layout = themeDisplay.getLayout();
            if (layout != null && layout.isTypeURL()) {
                String redirect = PortalUtil.getLayoutActualURL((Layout)layout);
                response.sendRedirect(redirect);
                ActionForward actionForward = null;
                return actionForward;
            }
            Long previousLayoutPlid = (Long)session.getAttribute("PREVIOUS_LAYOUT_PLID");
            if (previousLayoutPlid == null || layout.getPlid() != previousLayoutPlid.longValue()) {
                session.setAttribute("PREVIOUS_LAYOUT_PLID", (Object)layout.getPlid());
                if (themeDisplay.isSignedIn() && PropsValues.AUDIT_MESSAGE_COM_LIFERAY_PORTAL_MODEL_LAYOUT_VIEW && AuditRouterUtil.isDeployed()) {
                    User user = themeDisplay.getUser();
                    AuditMessage auditMessage = new AuditMessage("VIEW", user.getCompanyId(), user.getUserId(), user.getFullName(), Layout.class.getName(), String.valueOf(layout.getPlid()));
                    AuditRouterUtil.route((AuditMessage)auditMessage);
                }
            }
            boolean resetLayout = ParamUtil.getBoolean((HttpServletRequest)request, (String)"p_l_reset", (boolean)PropsValues.LAYOUT_DEFAULT_P_L_RESET);
            String portletId = ParamUtil.getString((HttpServletRequest)request, (String)"p_p_id");
            if (resetLayout && (Validator.isNull((String)portletId) || previousLayoutPlid != null && layout.getPlid() != previousLayoutPlid.longValue())) {
                RenderParametersPool.clear(request, plid);
            }
            Portlet portlet = null;
            if (Validator.isNotNull((String)portletId)) {
                long companyId = PortalUtil.getCompanyId((HttpServletRequest)request);
                portlet = PortletLocalServiceUtil.getPortletById((long)companyId, (String)portletId);
            }
            if (portlet != null) {
                PortletContainerUtil.preparePortlet((HttpServletRequest)request, portlet);
                if (themeDisplay.isLifecycleAction()) {
                    PortletContainerUtil.processAction((HttpServletRequest)request, (HttpServletResponse)response, (Portlet)portlet);
                    if (response.isCommitted()) {
                        ActionForward actionForward = null;
                        return actionForward;
                    }
                } else if (themeDisplay.isLifecycleResource()) {
                    PortletContainerUtil.serveResource((HttpServletRequest)request, (HttpServletResponse)response, (Portlet)portlet);
                    ActionForward actionForward = null;
                    return actionForward;
                }
            }
            if (layout != null) {
                if (themeDisplay.isStateExclusive()) {
                    PortletContainerUtil.render((HttpServletRequest)request, (HttpServletResponse)response, (Portlet)portlet);
                    ActionForward actionForward = null;
                    return actionForward;
                }
                if (layout.includeLayoutContent(request, response)) {
                    ActionForward actionForward = null;
                    return actionForward;
                }
            }
            ActionForward actionForward = actionMapping.findForward("portal.layout");
            return actionForward;
        }
        catch (Exception e) {
            PortalUtil.sendError((Exception)e, (HttpServletRequest)request, (HttpServletResponse)response);
            ActionForward actionForward = null;
            return actionForward;
        }
        finally {
            PortletRequest portletRequest;
            if (!ServerDetector.isResin() && (portletRequest = (PortletRequest)request.getAttribute("javax.portlet.request")) != null) {
                PortletRequestImpl portletRequestImpl = PortletRequestImpl.getPortletRequestImpl(portletRequest);
                portletRequestImpl.cleanUp();
            }
        }
    }
}

