/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.util;

import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.PropertiesUtil;
import com.liferay.portal.kernel.util.SystemEnv;
import com.liferay.portal.kernel.util.Validator;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;

public class SystemProperties {
    public static final String SYSTEM_PROPERTIES_QUIET = "system.properties.quiet";
    public static final String SYSTEM_PROPERTIES_SET = "system.properties.set";
    public static final String SYSTEM_PROPERTIES_SET_OVERRIDE = "system.properties.set.override";
    public static final String TMP_DIR = "java.io.tmpdir";
    private static final Map<String, String> _properties;

    public static void clear(String key) {
        System.clearProperty(key);
        _properties.remove(key);
    }

    public static String get(String key) {
        String value = _properties.get(key);
        if (value == null) {
            value = System.getProperty(key);
        }
        return value;
    }

    public static Properties getProperties() {
        return PropertiesUtil.fromMap(_properties);
    }

    public static void set(String key, String value) {
        System.setProperty(key, value);
        _properties.put(key, value);
    }

    static {
        Throwable throwable;
        InputStream inputStream;
        URL url2;
        Enumeration<URL> enumeration;
        Properties properties = new Properties();
        Thread currentThread = Thread.currentThread();
        ClassLoader classLoader = currentThread.getContextClassLoader();
        ArrayList<URL> urls = null;
        if (!GetterUtil.getBoolean(System.getProperty(SYSTEM_PROPERTIES_QUIET))) {
            urls = new ArrayList<URL>();
        }
        try {
            enumeration = classLoader.getResources("system.properties");
            while (enumeration.hasMoreElements()) {
                url2 = enumeration.nextElement();
                inputStream = url2.openStream();
                throwable = null;
                try {
                    properties.load(inputStream);
                }
                catch (Throwable x2) {
                    throwable = x2;
                    throw x2;
                }
                finally {
                    if (inputStream != null) {
                        if (throwable != null) {
                            try {
                                inputStream.close();
                            }
                            catch (Throwable x2) {
                                throwable.addSuppressed(x2);
                            }
                        } else {
                            inputStream.close();
                        }
                    }
                }
                if (urls == null) continue;
                urls.add(url2);
            }
        }
        catch (IOException ioe) {
            throw new ExceptionInInitializerError(ioe);
        }
        try {
            enumeration = classLoader.getResources("system-ext.properties");
            while (enumeration.hasMoreElements()) {
                url2 = enumeration.nextElement();
                inputStream = url2.openStream();
                throwable = null;
                try {
                    properties.load(inputStream);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (inputStream != null) {
                        if (throwable != null) {
                            try {
                                inputStream.close();
                            }
                            catch (Throwable x2) {
                                throwable.addSuppressed(x2);
                            }
                        } else {
                            inputStream.close();
                        }
                    }
                }
                if (urls == null) continue;
                urls.add(url2);
            }
        }
        catch (IOException ioe) {
            throw new ExceptionInInitializerError(ioe);
        }
        SystemEnv.setProperties(properties);
        if (GetterUtil.getBoolean(System.getProperty(SYSTEM_PROPERTIES_SET), true)) {
            boolean systemPropertiesSetOverride = GetterUtil.getBoolean(System.getProperty(SYSTEM_PROPERTIES_SET_OVERRIDE), true);
            for (Map.Entry<Object, Object> entry : properties.entrySet()) {
                String key = String.valueOf(entry.getKey());
                if (!systemPropertiesSetOverride && !Validator.isNull(System.getProperty(key))) continue;
                System.setProperty(key, String.valueOf(entry.getValue()));
            }
        }
        _properties = new ConcurrentHashMap<String, String>();
        PropertiesUtil.fromProperties(properties, _properties);
        if (urls != null) {
            for (URL url2 : urls) {
                System.out.println("Loading " + url2);
            }
        }
    }
}

