/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.backgroundtask.display;

import com.liferay.portal.kernel.backgroundtask.BackgroundTask;
import com.liferay.portal.kernel.backgroundtask.BackgroundTaskStatus;
import com.liferay.portal.kernel.backgroundtask.BackgroundTaskStatusRegistryUtil;
import com.liferay.portal.kernel.backgroundtask.display.BackgroundTaskDisplay;
import com.liferay.portal.kernel.io.unsync.UnsyncStringWriter;
import com.liferay.portal.kernel.json.JSONArray;
import com.liferay.portal.kernel.json.JSONException;
import com.liferay.portal.kernel.json.JSONFactoryUtil;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.template.Template;
import com.liferay.portal.kernel.template.TemplateException;
import com.liferay.portal.kernel.template.TemplateManager;
import com.liferay.portal.kernel.template.TemplateManagerUtil;
import com.liferay.portal.kernel.template.TemplateResource;
import com.liferay.portal.kernel.util.GetterUtil;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;

public abstract class BaseBackgroundTaskDisplay
implements BackgroundTaskDisplay {
    protected static final int PERCENTAGE_MAX = 100;
    protected static final int PERCENTAGE_MIN = 0;
    protected static final int PERCENTAGE_NONE = -1;
    protected final BackgroundTask backgroundTask;
    protected final BackgroundTaskStatus backgroundTaskStatus;
    private static final Log _log = LogFactoryUtil.getLog(BaseBackgroundTaskDisplay.class);

    public BaseBackgroundTaskDisplay(BackgroundTask backgroundTask) {
        this.backgroundTask = backgroundTask;
        this.backgroundTaskStatus = BackgroundTaskStatusRegistryUtil.getBackgroundTaskStatus(backgroundTask.getBackgroundTaskId());
    }

    @Override
    public abstract int getPercentage();

    @Override
    public int getStatus() {
        return this.backgroundTask.getStatus();
    }

    @Override
    public String getStatusLabel() {
        return this.getStatusLabel(Locale.getDefault());
    }

    @Override
    public String getStatusLabel(Locale locale) {
        return LanguageUtil.get(locale, this.backgroundTask.getStatusLabel());
    }

    @Override
    public boolean hasPercentage() {
        return this.getPercentage() >= 0;
    }

    @Override
    public String renderDisplayTemplate() {
        return this.renderDisplayTemplate(Locale.getDefault());
    }

    @Override
    public String renderDisplayTemplate(Locale locale) {
        TemplateResource templateResource = this.getTemplateResource();
        if (templateResource == null) {
            return "";
        }
        TemplateManager templateManager = TemplateManagerUtil.getTemplateManager("ftl");
        Template template = templateManager.getTemplate(templateResource, true);
        template.put("backgroundTask", this.backgroundTask);
        template.put("backgroundTaskDisplay", this);
        template.put("backgroundTaskStatus", this.backgroundTaskStatus);
        template.put("statusMessageJSONObject", this.getStatusMessageJSONObject(locale));
        Map<String, Object> templateVars = this.getTemplateVars();
        if (templateVars != null) {
            template.putAll(this.getTemplateVars());
        }
        UnsyncStringWriter writer = new UnsyncStringWriter();
        try {
            template.processTemplate(writer);
        }
        catch (TemplateException te) {
            if (_log.isDebugEnabled()) {
                _log.debug(te, te);
            }
            return "";
        }
        return ((Object)writer).toString();
    }

    protected long getBackgroundTaskStatusAttributeLong(String attributeKey) {
        return GetterUtil.getLong(this.backgroundTaskStatus.getAttribute(attributeKey));
    }

    protected String getBackgroundTaskStatusAttributeString(String attributeKey) {
        return GetterUtil.getString(this.backgroundTaskStatus.getAttribute(attributeKey));
    }

    protected JSONObject getStatusMessageJSONObject(Locale locale) {
        JSONObject jsonObject;
        block2: {
            jsonObject = null;
            try {
                jsonObject = JSONFactoryUtil.createJSONObject(this.backgroundTask.getStatusMessage());
            }
            catch (JSONException jsone) {
                if (!_log.isDebugEnabled()) break block2;
                _log.debug(jsone, jsone);
            }
        }
        return this.translateJSON(jsonObject, locale);
    }

    protected abstract TemplateResource getTemplateResource();

    protected abstract Map<String, Object> getTemplateVars();

    protected boolean hasBackgroundTaskStatus() {
        return this.backgroundTaskStatus != null;
    }

    protected JSONArray translateJSON(JSONArray jsonArray, Locale locale) {
        JSONArray translatedJSON = JSONFactoryUtil.createJSONArray();
        for (Object object : jsonArray) {
            if (object instanceof JSONObject) {
                translatedJSON.put(this.translateJSON((JSONObject)object, locale));
                continue;
            }
            if (object instanceof JSONArray) {
                translatedJSON.put(this.translateJSON((JSONArray)object, locale));
                continue;
            }
            if (object instanceof String) {
                translatedJSON.put(LanguageUtil.get(locale, (String)object));
                continue;
            }
            translatedJSON.put(object);
        }
        return translatedJSON;
    }

    protected JSONObject translateJSON(JSONObject jsonObject, Locale locale) {
        if (locale == null) {
            return jsonObject;
        }
        JSONObject translatedJSON = JSONFactoryUtil.createJSONObject();
        Iterator<String> iterator = jsonObject.keys();
        while (iterator.hasNext()) {
            String key = iterator.next();
            Object object = jsonObject.get(key);
            if (object instanceof JSONObject) {
                translatedJSON.put(key, this.translateJSON((JSONObject)object, locale));
                continue;
            }
            if (object instanceof JSONArray) {
                translatedJSON.put(key, this.translateJSON((JSONArray)object, locale));
                continue;
            }
            if (object instanceof String) {
                translatedJSON.put(key, LanguageUtil.get(locale, (String)object));
                continue;
            }
            translatedJSON.put(key, object);
        }
        return translatedJSON;
    }
}

