/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.upgrade.v6_0_3;

import com.liferay.portal.kernel.upgrade.UpgradeProcess;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.LoggingTimer;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.util.PortalInstances;
import java.sql.PreparedStatement;
import java.sql.ResultSet;

public class UpgradePermission
extends UpgradeProcess {
    private static final String _ROLE_COMMUNITY_CONTENT_REVIEWER = "Community Content Reviewer";
    private static final String _ROLE_ORGANIZATION_CONTENT_REVIEWER = "Organization Content Reviewer";
    private static final String _ROLE_PORTAL_CONTENT_REVIEWER = "Portal Content Reviewer";

    protected void addRole(long roleId, long companyId, long classNameId, long classPK, String name, int type) throws Exception {
        try (PreparedStatement ps = this.connection.prepareStatement("insert into Role_ (roleId, companyId, classNameId, classPK, name, type_) values (?, ?, ?, ?, ?, ?)");){
            ps.setLong(1, roleId);
            ps.setLong(2, companyId);
            ps.setLong(3, classNameId);
            ps.setLong(4, classPK);
            ps.setString(5, name);
            ps.setInt(6, type);
            ps.executeUpdate();
        }
    }

    protected void addSingleApproverWorkflowRoles() throws Exception {
        try (LoggingTimer loggingTimer = new LoggingTimer();){
            long[] companyIds;
            for (long companyId : companyIds = PortalInstances.getCompanyIdsBySQL()) {
                this.addSingleApproverWorkflowRoles(companyId);
            }
        }
    }

    protected void addSingleApproverWorkflowRoles(long companyId) throws Exception {
        long classNameId = PortalUtil.getClassNameId((String)"com.liferay.portal.model.Role");
        long roleId = this.increment();
        this.addRole(roleId, companyId, classNameId, roleId, _ROLE_COMMUNITY_CONTENT_REVIEWER, 2);
        classNameId = PortalUtil.getClassNameId((String)"com.liferay.portal.model.Organization");
        roleId = this.increment();
        this.addRole(roleId, companyId, classNameId, roleId, _ROLE_ORGANIZATION_CONTENT_REVIEWER, 3);
        classNameId = PortalUtil.getClassNameId((String)"com.liferay.portal.model.Company");
        roleId = this.increment();
        this.addRole(roleId, companyId, classNameId, roleId, _ROLE_PORTAL_CONTENT_REVIEWER, 1);
    }

    protected void addUserGroupRole(long userId, long groupId, long roleId) throws Exception {
        if (this.hasUserGroupRole(userId, groupId, roleId)) {
            return;
        }
        try (PreparedStatement ps = this.connection.prepareStatement("insert into UserGroupRole (userId, groupId, roleId) values (?, ?, ?)");){
            ps.setLong(1, userId);
            ps.setLong(2, groupId);
            ps.setLong(3, roleId);
            ps.executeUpdate();
        }
    }

    protected void addUserRole(long userId, long roleId) throws Exception {
        if (this.hasUserRole(userId, roleId)) {
            return;
        }
        try (PreparedStatement ps = this.connection.prepareStatement("insert into Users_Roles (userId, roleId) values (?, ?)");){
            ps.setLong(1, userId);
            ps.setLong(2, roleId);
            ps.executeUpdate();
        }
    }

    protected void assignSingleApproverWorkflowRoles(long companyId, long roleId, long groupId) throws Exception {
        try (PreparedStatement ps1 = this.connection.prepareStatement("select classNameId from Group_ where groupId = ?");){
            ps1.setLong(1, groupId);
            try (ResultSet rs1 = ps1.executeQuery();){
                long classNameId = 0L;
                if (rs1.next()) {
                    classNameId = rs1.getLong("classNameId");
                }
                String className = PortalUtil.getClassName((long)classNameId);
                long communityContentReviewerRoleId = this.getRoleId(companyId, _ROLE_COMMUNITY_CONTENT_REVIEWER);
                long organizationContentReviewerRoleId = this.getRoleId(companyId, _ROLE_ORGANIZATION_CONTENT_REVIEWER);
                long portalContentReviewerRoleId = this.getRoleId(companyId, _ROLE_PORTAL_CONTENT_REVIEWER);
                StringBundler sb = new StringBundler(5);
                sb.append("(select User_.* from User_, Users_Roles where ");
                sb.append("User_.userId = Users_Roles.userId and ");
                sb.append("Users_Roles.roleId = ?) union all (select User_.* ");
                sb.append("from User_, UserGroupRole where User_.userId = ");
                sb.append("UserGroupRole.userId and UserGroupRole.roleId = ?)");
                try (PreparedStatement ps2 = this.connection.prepareStatement(sb.toString());){
                    ps2.setLong(1, roleId);
                    ps2.setLong(2, roleId);
                    try (ResultSet rs2 = ps2.executeQuery();){
                        while (rs2.next()) {
                            long userId = rs2.getLong("userId");
                            if (className.equals("com.liferay.portal.model.Company")) {
                                this.addUserRole(userId, portalContentReviewerRoleId);
                                continue;
                            }
                            if (className.equals("com.liferay.portal.model.Group")) {
                                this.addUserGroupRole(userId, groupId, communityContentReviewerRoleId);
                                continue;
                            }
                            if (!className.equals("com.liferay.portal.model.Organization")) continue;
                            this.addUserGroupRole(userId, groupId, organizationContentReviewerRoleId);
                        }
                    }
                }
            }
        }
    }

    protected void doUpgrade() throws Exception {
        this.addSingleApproverWorkflowRoles();
        this.updatePermissions();
    }

    /*
     * Exception decompiling
     */
    protected long getRoleId(long companyId, String name) throws Exception {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    protected boolean hasUserGroupRole(long userId, long groupId, long roleId) throws Exception {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    protected boolean hasUserRole(long userId, long roleId) throws Exception {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    protected void updatePermissions() throws Exception {
        try (LoggingTimer loggingTimer = new LoggingTimer();){
            StringBundler sb = new StringBundler(11);
            sb.append("select ResourcePermission.companyId, ");
            sb.append("ResourcePermission.roleId, ResourcePermission.primKey ");
            sb.append("from ResourcePermission, ResourceAction where ");
            sb.append("ResourceAction.name = 'com.liferay.portlet.journal' ");
            sb.append("and ResourceAction.name = ResourcePermission.name and ");
            sb.append("ResourceAction.actionId = 'APPROVE_ARTICLE' and ");
            sb.append("ResourcePermission.scope = 4 and ");
            sb.append("ResourcePermission.actionIds >= ");
            sb.append("ResourceAction.bitwiseValue and ");
            sb.append("mod((ResourcePermission.actionIds / ");
            sb.append("ResourceAction.bitwiseValue), 2) = 1");
            try (PreparedStatement ps = this.connection.prepareStatement(sb.toString());
                 ResultSet rs = ps.executeQuery();){
                while (rs.next()) {
                    long companyId = rs.getLong("companyId");
                    long roleId = rs.getLong("roleId");
                    long groupId = GetterUtil.getLong((String)rs.getString("primKey"));
                    this.assignSingleApproverWorkflowRoles(companyId, roleId, groupId);
                }
            }
        }
    }
}

