/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.service.impl;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.Ticket;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.uuid.PortalUUIDUtil;
import com.liferay.portal.service.base.TicketLocalServiceBaseImpl;
import java.util.Date;

public class TicketLocalServiceImpl
extends TicketLocalServiceBaseImpl {
    public Ticket addDistinctTicket(long companyId, String className, long classPK, int type, String extraInfo, Date expirationDate, ServiceContext serviceContext) {
        long classNameId = this.classNameLocalService.getClassNameId(className);
        this.ticketPersistence.removeByC_C_T(classNameId, classPK, type);
        return this.addTicket(companyId, className, classPK, type, extraInfo, expirationDate, serviceContext);
    }

    public Ticket addTicket(long companyId, String className, long classPK, int type, String extraInfo, Date expirationDate, ServiceContext serviceContext) {
        long classNameId = this.classNameLocalService.getClassNameId(className);
        long ticketId = this.counterLocalService.increment();
        Ticket ticket = this.ticketPersistence.create(ticketId);
        ticket.setCompanyId(companyId);
        ticket.setCreateDate(new Date());
        ticket.setClassNameId(classNameId);
        ticket.setClassPK(classPK);
        ticket.setKey(PortalUUIDUtil.generate());
        ticket.setType(type);
        ticket.setExtraInfo(extraInfo);
        ticket.setExpirationDate(expirationDate);
        this.ticketPersistence.update((BaseModel)ticket);
        return ticket;
    }

    public Ticket fetchTicket(String key) {
        return this.ticketPersistence.fetchByKey(key);
    }

    public Ticket getTicket(String key) throws PortalException {
        return this.ticketPersistence.findByKey(key);
    }
}

