/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.cache.thread.local;

import com.liferay.portal.kernel.cache.thread.local.Lifecycle;
import com.liferay.portal.kernel.cache.thread.local.ThreadLocalCachable;
import com.liferay.portal.kernel.cache.thread.local.ThreadLocalCache;
import com.liferay.portal.kernel.cache.thread.local.ThreadLocalCacheManager;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.spring.aop.AnnotationChainableMethodAdvice;
import com.liferay.portal.spring.aop.ServiceBeanMethodInvocation;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import org.aopalliance.intercept.MethodInvocation;

public class ThreadLocalCacheAdvice
extends AnnotationChainableMethodAdvice<ThreadLocalCachable> {
    private static final ThreadLocalCachable _nullThreadLocalCacheable = new ThreadLocalCachable(){

        public Class<? extends Annotation> annotationType() {
            return ThreadLocalCachable.class;
        }

        public Lifecycle scope() {
            return null;
        }
    };

    @Override
    public void afterReturning(MethodInvocation methodInvocation, Object result) throws Throwable {
        ThreadLocalCachable threadLocalCachable = (ThreadLocalCachable)this.findAnnotation(methodInvocation);
        if (threadLocalCachable == _nullThreadLocalCacheable) {
            return;
        }
        Serializable cacheName = this._getCacheName(methodInvocation);
        ThreadLocalCache threadLocalCache = ThreadLocalCacheManager.getThreadLocalCache((Lifecycle)threadLocalCachable.scope(), (Serializable)cacheName);
        String cacheKey = this._getCacheKey(methodInvocation.getArguments());
        if (result == null) {
            threadLocalCache.put(cacheKey, this.nullResult);
        } else {
            threadLocalCache.put(cacheKey, result);
        }
    }

    @Override
    public Object before(MethodInvocation methodInvocation) throws Throwable {
        String cacheKey;
        ThreadLocalCachable threadLocalCachable = (ThreadLocalCachable)this.findAnnotation(methodInvocation);
        if (threadLocalCachable == _nullThreadLocalCacheable) {
            return null;
        }
        Serializable cacheName = this._getCacheName(methodInvocation);
        ThreadLocalCache threadLocalCache = ThreadLocalCacheManager.getThreadLocalCache((Lifecycle)threadLocalCachable.scope(), (Serializable)cacheName);
        Object value = threadLocalCache.get(cacheKey = this._getCacheKey(methodInvocation.getArguments()));
        if (value == this.nullResult) {
            return null;
        }
        return value;
    }

    @Override
    public ThreadLocalCachable getNullAnnotation() {
        return _nullThreadLocalCacheable;
    }

    private String _getCacheKey(Object[] arguments) {
        StringBundler sb = new StringBundler(arguments.length * 2 - 1);
        for (int i = 0; i < arguments.length; ++i) {
            sb.append(StringUtil.toHexString((Object)arguments[i]));
            if (i + 1 >= arguments.length) continue;
            sb.append("#");
        }
        return sb.toString();
    }

    private Serializable _getCacheName(MethodInvocation methodInvocation) {
        if (methodInvocation instanceof ServiceBeanMethodInvocation) {
            ServiceBeanMethodInvocation serviceBeanMethodInvocation = (ServiceBeanMethodInvocation)methodInvocation;
            return serviceBeanMethodInvocation.toCacheKeyModel();
        }
        return methodInvocation.toString();
    }
}

