/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.util;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.model.LayoutTypePortlet;
import com.liferay.portal.kernel.model.Portlet;
import com.liferay.portal.kernel.model.PortletApp;
import com.liferay.portal.kernel.model.PortletCategory;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.portlet.PortletConfigFactoryUtil;
import com.liferay.portal.kernel.service.PortletLocalServiceUtil;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.PortletLister;
import com.liferay.portal.kernel.util.ResourceBundleUtil;
import com.liferay.portal.kernel.util.TreeNodeView;
import com.liferay.portal.kernel.util.TreeView;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.util.comparator.PortletCategoryComparator;
import com.liferay.portal.kernel.util.comparator.PortletTitleComparator;
import com.liferay.portal.util.WebAppPool;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.Set;
import javax.portlet.PortletConfig;
import javax.servlet.ServletContext;

public class PortletListerImpl
implements PortletLister {
    private int _depth;
    private boolean _hierarchicalTree;
    private boolean _includeInstanceablePortlets;
    private boolean _iteratePortlets;
    private LayoutTypePortlet _layoutTypePortlet;
    private List<TreeNodeView> _list;
    private int _nodeId;
    private String _rootNodeName;
    private ServletContext _servletContext;
    private ThemeDisplay _themeDisplay;
    private User _user;

    public TreeView getTreeView() throws PortalException {
        this._nodeId = 1;
        this._list = new ArrayList<TreeNodeView>();
        TreeNodeView rootNodeView = null;
        if (this._rootNodeName != null) {
            rootNodeView = new TreeNodeView(this._nodeId);
            rootNodeView.setLeaf(false);
            rootNodeView.setName(this._rootNodeName);
            this._list.add(rootNodeView);
        }
        PortletCategory portletCategory = (PortletCategory)WebAppPool.get(this._user.getCompanyId(), "PORTLET_CATEGORY");
        List portletCategories = ListUtil.fromCollection((Collection)portletCategory.getCategories());
        this.iteratePortletCategories(rootNodeView, portletCategories, this._nodeId, 0);
        return new TreeView(this._list, this._depth);
    }

    public void setHierarchicalTree(boolean hierarchicalTree) {
        this._hierarchicalTree = hierarchicalTree;
    }

    public void setIncludeInstanceablePortlets(boolean includeInstanceablePortlets) {
        this._includeInstanceablePortlets = includeInstanceablePortlets;
    }

    public void setIteratePortlets(boolean iteratePortlets) {
        this._iteratePortlets = iteratePortlets;
    }

    public void setLayoutTypePortlet(LayoutTypePortlet layoutTypePortlet) {
        this._layoutTypePortlet = layoutTypePortlet;
    }

    public void setRootNodeName(String rootNodeName) {
        this._rootNodeName = rootNodeName;
    }

    public void setServletContext(ServletContext servletContext) {
        this._servletContext = servletContext;
    }

    public void setThemeDisplay(ThemeDisplay themeDisplay) {
        this._themeDisplay = themeDisplay;
    }

    public void setUser(User user) {
        this._user = user;
    }

    protected Locale getLocale() {
        if (this._themeDisplay == null) {
            return this._user.getLocale();
        }
        return this._themeDisplay.getLocale();
    }

    protected void iteratePortletCategories(TreeNodeView parentNodeView, List<PortletCategory> portletCategories, long parentId, int depth) throws PortalException {
        portletCategories = ListUtil.sort(portletCategories, (Comparator)new PortletCategoryComparator(this.getLocale()));
        for (int i = 0; i < portletCategories.size(); ++i) {
            PortletCategory portletCategory = (PortletCategory)portletCategories.get(i);
            if (portletCategory.isHidden()) continue;
            if (i == 0 && ++depth > this._depth) {
                this._depth = depth;
            }
            TreeNodeView nodeView = new TreeNodeView(++this._nodeId);
            nodeView.setDepth(depth);
            nodeView.setLeaf(false);
            if (i + 1 == portletCategories.size()) {
                nodeView.setLs("1");
            } else {
                nodeView.setLs("0");
            }
            nodeView.setName(LanguageUtil.get((Locale)this.getLocale(), (String)portletCategory.getName()));
            nodeView.setObjId(portletCategory.getPath());
            nodeView.setParentId(parentId);
            if (this._hierarchicalTree) {
                if (parentNodeView != null) {
                    parentNodeView.addChild(nodeView);
                }
            } else {
                this._list.add(nodeView);
            }
            int nodeId = this._nodeId;
            List subCategories = ListUtil.fromCollection((Collection)portletCategory.getCategories());
            this.iteratePortletCategories(nodeView, subCategories, nodeId, depth);
            if (!this._iteratePortlets) continue;
            this.iteratePortlets(nodeView, portletCategory, portletCategory.getPortletIds(), nodeId, depth + 1);
        }
    }

    protected void iteratePortlets(TreeNodeView parentNodeView, PortletCategory portletCategory, Set<String> portletIds, int parentNodeId, int depth) {
        List<Portlet> portlets = new ArrayList();
        String externalPortletCategory = null;
        for (String portletId : portletIds) {
            PortletApp portletApp;
            Portlet portlet = PortletLocalServiceUtil.getPortletById((long)this._user.getCompanyId(), (String)portletId);
            if (portlet == null) continue;
            if (!portlet.isSystem() && portlet.isActive() && (!portlet.isInstanceable() || this._includeInstanceablePortlets)) {
                if (!portlet.isInstanceable() && this._layoutTypePortlet.hasPortletId(portlet.getPortletId())) {
                    portlets.add(portlet);
                } else if (portlet.hasAddPortletPermission(this._user.getUserId())) {
                    portlets.add(portlet);
                }
            }
            if (!(portletApp = portlet.getPortletApp()).isWARFile() || !Validator.isNull(externalPortletCategory)) continue;
            PortletConfig portletConfig = PortletConfigFactoryUtil.create((Portlet)portlet, (ServletContext)this._servletContext);
            ResourceBundle resourceBundle = portletConfig.getResourceBundle(this.getLocale());
            externalPortletCategory = ResourceBundleUtil.getString((ResourceBundle)resourceBundle, (String)portletCategory.getName());
        }
        portlets = ListUtil.sort(portlets, (Comparator)new PortletTitleComparator(this.getLocale()));
        for (int i = 0; i < portlets.size(); ++i) {
            Portlet portlet = (Portlet)portlets.get(i);
            TreeNodeView nodeView = new TreeNodeView(++this._nodeId);
            nodeView.setDepth(depth);
            nodeView.setLeaf(true);
            if (i + 1 == portlets.size()) {
                nodeView.setLs("1");
            } else {
                nodeView.setLs("0");
            }
            nodeView.setName(PortalUtil.getPortletTitle((Portlet)portlet, (ServletContext)this._servletContext, (Locale)this.getLocale()));
            nodeView.setObjId(portlet.getRootPortletId());
            nodeView.setParentId((long)parentNodeId);
            if (this._hierarchicalTree) {
                parentNodeView.addChild(nodeView);
                continue;
            }
            this._list.add(nodeView);
        }
    }
}

