/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.upgrade.v6_1_0;

import com.liferay.portal.kernel.upgrade.UpgradeProcess;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.LoggingTimer;
import com.liferay.portal.kernel.util.UnicodeProperties;
import java.sql.PreparedStatement;
import java.sql.ResultSet;

public class UpgradeExpando
extends UpgradeProcess {
    protected void doUpgrade() throws Exception {
        this.updateColumnTypeSettingsIndexable();
        this.updateColumnTypeSettingsSelection();
    }

    protected void updateColumnTypeSettings(long columnId, String typeSettings) throws Exception {
        try (PreparedStatement ps = this.connection.prepareStatement("update ExpandoColumn set typeSettings = ? where columnId = ?");){
            ps.setString(1, typeSettings);
            ps.setLong(2, columnId);
            ps.executeUpdate();
        }
    }

    protected void updateColumnTypeSettingsIndexable() throws Exception {
        try (LoggingTimer loggingTimer = new LoggingTimer();
             PreparedStatement ps = this.connection.prepareStatement("select columnId, type_, typeSettings from ExpandoColumn where typeSettings like '%indexable%'");
             ResultSet rs = ps.executeQuery();){
            while (rs.next()) {
                long columnId = rs.getLong("columnId");
                int type = rs.getInt("type_");
                String typeSettings = rs.getString("typeSettings");
                UnicodeProperties typeSettingsProperties = new UnicodeProperties(true);
                typeSettingsProperties.load(typeSettings);
                boolean indexable = GetterUtil.getBoolean((String)typeSettingsProperties.getProperty("indexable"));
                if (indexable) {
                    if (type == 15 || type == 16) {
                        typeSettingsProperties.setProperty("index-type", String.valueOf(1));
                    } else {
                        typeSettingsProperties.setProperty("index-type", String.valueOf(2));
                    }
                } else {
                    typeSettingsProperties.setProperty("index-type", String.valueOf(0));
                }
                typeSettingsProperties.remove((Object)"indexable");
                this.updateColumnTypeSettings(columnId, typeSettingsProperties.toString());
            }
        }
    }

    protected void updateColumnTypeSettingsSelection() throws Exception {
        try (LoggingTimer loggingTimer = new LoggingTimer();
             PreparedStatement ps = this.connection.prepareStatement("select columnId, typeSettings from ExpandoColumn where typeSettings like '%selection%'");
             ResultSet rs = ps.executeQuery();){
            while (rs.next()) {
                long columnId = rs.getLong("columnId");
                String typeSettings = rs.getString("typeSettings");
                typeSettings = typeSettings.replace("selection=1", "display-type=selection-list");
                typeSettings = typeSettings.replace("selection=0", "display-type=text-box");
                this.updateColumnTypeSettings(columnId, typeSettings);
            }
        }
    }
}

